/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SwingWorker;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.HorizontalExpandedForm;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.monitor.ProgressDialog;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.ProgressMonitor;

class SampleProgressMonitor
extends SampleBase {
    SampleProgressMonitor() {
        super("Progress Monitor");
    }

    public static SampleProgressMonitor create() {
        return new SampleProgressMonitor();
    }

    @Override
    public UiComponent buildEditorPanel(final UiContainer parent) {
        Panel panel = new Panel(parent);
        Panel panel1 = new Panel(panel, UIMsg.TO_MSG("Simple ProgressMonitor"));
        BaseAction sample11 = new BaseAction(UIMsg.TO_MSG("ISample using Foxtrot Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingFoxtrotWorker(parent);
            }
        };
        BaseAction sample12 = new BaseAction(UIMsg.TO_MSG("ISample using Swing Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingSwingWorker(parent);
            }
        };
        panel1.add(new Button((UiContainer)panel1, sample11));
        panel1.add(new Button((UiContainer)panel1, sample12));
        Panel panel2 = new Panel(panel, UIMsg.TO_MSG("Log ProgressMonitor"));
        BaseAction sample21 = new BaseAction(UIMsg.TO_MSG("ISample using Foxtrot Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingFoxtrotWorker(parent);
            }
        };
        BaseAction sample22 = new BaseAction(UIMsg.TO_MSG("ISample using Swing Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingSwingWorker(parent);
            }
        };
        panel2.add(new Button((UiContainer)panel2, sample21));
        panel2.add(new Button((UiContainer)panel2, sample22));
        Panel panel3 = new Panel(panel, UIMsg.TO_MSG("Two Bars ProgressMonitor"));
        BaseAction sample31 = new BaseAction(UIMsg.TO_MSG("ISample using Foxtrot Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingFoxtrotWorker(parent);
            }
        };
        BaseAction sample32 = new BaseAction(UIMsg.TO_MSG("ISample using Swing Worker")){

            @Override
            public void run() {
                SampleProgressMonitor.this.testUsingSwingWorker(parent);
            }
        };
        panel3.add(new Button((UiContainer)panel3, sample31));
        panel3.add(new Button((UiContainer)panel3, sample32));
        HorizontalExpandedForm form = FormsFactory.createHorizontalExpandedForm(panel);
        form.add((UiComponent)panel1);
        form.add((UiComponent)panel2);
        form.add((UiComponent)panel3);
        form.add(this.createPercentualProgressMonitorPanel(panel));
        final Panel panel4 = new Panel(panel, UIMsg.TO_MSG("Cancellable Progress Monitor"));
        BaseAction sample4 = new BaseAction(UIMsg.TO_MSG("Launch Cancellable Progress Dialog")){

            @Override
            public void run() {
                SampleProgressMonitor.this.createCancelableProgressMonitor(panel4);
            }
        };
        panel4.add(new Button((UiContainer)panel4, sample4));
        form.add((UiComponent)panel4);
        return panel;
    }

    private UiComponent createPercentualProgressMonitorPanel(Panel parent) {
        Panel result = new Panel(parent, UIMsg.TO_MSG("Percentual ProgressMonitor"));
        ProgressMonitorBuilder monitorBuilder = ProgressMonitorBuilder.createSimpleBuilder(result);
        final ProgressMonitorGUI monitor = monitorBuilder.buildProgressMonitor(result);
        monitor.phase(Msg.QUOTE("Phase 1"));
        BaseAction action = new BaseAction(UIMsg.TO_MSG("Percentual ProgressMonitor")){

            @Override
            public void run() {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        monitor.phase(Msg.QUOTE("Working..."));
                        for (int i = 0; i <= 10; ++i) {
                            SampleProgressMonitor.this.sleep(1000);
                            monitor.progress(i * 10);
                        }
                    }
                }).start();
            }
        };
        result.setLayout(new BorderLayout());
        result.add(monitor, "Center");
        result.add(new Button((UiContainer)result, action), "East");
        return result;
    }

    private void longProcess(ProgressMonitor progressMonitor) {
        progressMonitor.phase(UIMsg.BACK);
        progressMonitor.progress(6000);
        progressMonitor.info(UIMsg.ADD);
        this.sleep(500);
        progressMonitor.info(UIMsg.CLOSE);
        this.sleep(500);
        progressMonitor.info(UIMsg.ADD_LANGUAGE);
        this.sleep(500);
        progressMonitor.info(UIMsg.AUTOHIDE);
        this.sleep(500);
        progressMonitor.phase(UIMsg.AUTOHIDE_OFF);
        progressMonitor.progress(2000);
        this.sleep(4000);
        progressMonitor.phase(UIMsg.BEAUTIFYING_COMPONENTS);
        progressMonitor.progress(3000);
        this.sleep(3000);
        progressMonitor.progress(100);
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void createCancelableProgressMonitor(UiContainer parent) {
        ProgressMonitorBuilder monitorBuilder = ProgressMonitorBuilder.createCancelableBuilder(parent);
        ProgressDialog dialog = monitorBuilder.buildProgressDialog(Ui.getRoot(), CoreMsg.START);
        try {
            final InterruptableTask interruptibleBooleanTask = new InterruptableTask(dialog);
            dialog.setCancelListener(new ProgressDialog.CancelListener(){

                @Override
                public void cancel() {
                    SampleProgressMonitor.this.doSthBizarre();
                    interruptibleBooleanTask.interrupt();
                }
            });
            dialog.run(interruptibleBooleanTask);
        }
        catch (Exception e) {
            System.out.println("SampleProgressMonitor.testMonitorUsingWorker\n" + e.getMessage());
        }
    }

    private void doSthBizarre() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SampleProgressMonitor.this.sleep(10000);
                System.out.println("Just after the sleep!");
            }
        }).start();
    }

    private void testUsingFoxtrotWorker(UiContainer parent) {
        ProgressMonitorBuilder monitorBuilder = ProgressMonitorBuilder.createSimpleBuilder(parent);
        final ProgressDialog d = monitorBuilder.buildProgressDialog(Ui.getRoot(), CoreMsg.START);
        final ProgressMonitor monitor = d.getProgressMonitor();
        try {
            FuegoWorker.Procedure procedure = new FuegoWorker.Procedure(){

                @Override
                public void run() throws Exception {
                    d.setVisible(true);
                    try {
                        SampleProgressMonitor.this.longProcess(monitor);
                        throw new Exception("Testing!");
                    }
                    catch (Throwable throwable) {
                        d.setVisible(false);
                        throw throwable;
                    }
                }
            };
            d.run(procedure);
        }
        catch (Exception e) {
            System.out.println("SampleProgressMonitor.testMonitorUsingWorker\n" + e.getMessage());
        }
    }

    private void testUsingSwingWorker(UiContainer parent) {
        ProgressMonitorBuilder monitorBuilder = ProgressMonitorBuilder.createSimpleBuilder(parent);
        final ProgressDialog d = monitorBuilder.buildProgressDialog(Ui.getRoot(), CoreMsg.START);
        final ProgressMonitor monitor = d.getProgressMonitor();
        System.out.println("TestUI.testMonitor START");
        SwingWorker worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                d.setVisible(true);
                try {
                    SampleProgressMonitor.this.longProcess(monitor);
                }
                finally {
                    d.setVisible(false);
                }
                return null;
            }

            @Override
            public void finished() {
                d.setVisible(false);
            }
        };
        try {
            d.run(worker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class InterruptableTask
    implements FuegoWorker.BooleanJob {
        private boolean cancel = false;
        private ProgressDialog dialog;
        private ProgressMonitor monitor;

        public InterruptableTask(ProgressDialog dialog) {
            this.dialog = dialog;
            this.monitor = dialog.getProgressMonitor();
        }

        public void interrupt() {
            this.cancel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run() {
            this.dialog.setVisible(true);
            int i = 0;
            try {
                this.monitor.phase(UIMsg.BACK);
                while (!this.cancel && ++i <= 5) {
                    this.monitor.info(UIMsg.ADD);
                    SampleProgressMonitor.this.sleep(500);
                    this.monitor.info(UIMsg.CLOSE);
                    SampleProgressMonitor.this.sleep(500);
                    this.monitor.info(UIMsg.ADD_LANGUAGE);
                    SampleProgressMonitor.this.sleep(500);
                    this.monitor.info(UIMsg.AUTOHIDE);
                    SampleProgressMonitor.this.sleep(500);
                    this.monitor.progress(i * 20);
                }
            }
            finally {
                this.dialog.setVisible(false);
            }
            return true;
        }
    }
}

