/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.HorizontalExpandedForm;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;

public class SamplePanel
extends SampleBase {
    private SamplePanel() {
        super("Panel / Panel with Title");
    }

    public static SamplePanel create() {
        return new SamplePanel();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel result = new Panel(parent);
        HorizontalExpandedForm form = FormsFactory.createHorizontalExpandedForm(result);
        form.add((UiComponent)SamplePanel.createInnerPanel(result, null));
        form.add((UiComponent)SamplePanel.createInnerPanel(result, UIMsg.TO_MSG("")));
        form.add((UiComponent)SamplePanel.createInnerPanel(result, UIMsg.TO_MSG("Sample Title")));
        return result;
    }

    private static Panel createInnerPanel(UiContainer parent, Msg title) {
        Panel result = new Panel(parent, title);
        StandardForm form = FormsFactory.createStandardForm(result);
        LabelMultiline label = form.createExplanation(UIMsg.TO_MSG("Press mouse buttons or keyboard in order to check events"));
        final TextArea textArea = form.createTextArea();
        textArea.setRows(8);
        form.add(label);
        form.add(UIMsg.TO_MSG("Events"), textArea);
        result.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textArea.append(".keyPressed()");
            }

            @Override
            public void keyReleased(KeyEvent e) {
                textArea.append(".keyReleased()");
            }

            @Override
            public void keyTyped(KeyEvent e) {
                textArea.append(".keyTyped()");
            }
        });
        result.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textArea.append(".mouseClicked()");
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                textArea.append(".mouseDoubleClicked()");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textArea.append(".mouseEntered()");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textArea.append(".mouseExited()");
            }

            @Override
            public void mousePressed(MouseEvent e) {
                textArea.append(".mousePressed()");
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                textArea.append(".mouseReleased()");
            }
        });
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                textArea.setText("");
            }
        });
        return result;
    }
}

