/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.Locale;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.Layout;
import oracle.bpm.ui.validators.NoSpacesInputValidator;

class SampleMessageDialog
extends SampleBase {
    SampleMessageDialog() {
        super("Message Dialog");
    }

    public static SampleMessageDialog create() {
        return new SampleMessageDialog();
    }

    @Override
    public UiComponent buildEditorPanel(final UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BoxLayout(panel, 1));
        BaseAction showError = new BaseAction(UIMsg.TO_MSG("Show Error")){

            @Override
            public void run() {
                MessageDialog.setFrame(Ui.getRoot());
                MessageDialog.showError(UIMsg.TO_MSG("Error Message"));
            }
        };
        BaseAction showDetailError = new BaseAction(UIMsg.TO_MSG("Show Detail Error")){

            @Override
            public void run() {
                MessageDialog.setFrame(Ui.getRoot());
                MessageDialog.showError(UIMsg.TO_MSG("Error Detail Message"), (Throwable)new Exception("My Error"));
            }
        };
        BaseAction showWarning = new BaseAction(UIMsg.TO_MSG("Show Warning")){

            @Override
            public void run() {
                MessageDialog.setFrame(Ui.getRoot());
                MessageDialog.showWarning(UIMsg.TO_MSG("Warning Message"));
            }
        };
        BaseAction showOkCancelDialog = new BaseAction(UIMsg.TO_MSG("Show Ok-Cancel Dialog")){

            @Override
            public void run() {
                TestDialog dlg = new TestDialog();
                dlg.setVisible(true);
            }
        };
        final InputValidator validator = new InputValidator(){

            @Override
            public void validate(String newValue) throws InputValidationException {
                if (newValue.length() >= 10) {
                    throw new InputValidationException(UIMsg.TO_MSG("La longitud ingresada es mayor o igual a 10"));
                }
            }
        };
        BaseAction showNewModuleDialog = new BaseAction(UIMsg.TO_MSG("Show New Module Dialog")){

            @Override
            public void run() {
                MessageDialog.setFrame(Ui.getRoot());
                System.out.println("showInputDialog result = " + MessageDialog.showInputModule(Ui.getRoot(), Msg.QUOTE("Module (len >= 10 show error msg)"), Msg.QUOTE("Module"), validator, "Name56789"));
            }
        };
        BaseAction showNormalInputDialog = new BaseAction(UIMsg.TO_MSG("Show Normal Input Dialog")){

            @Override
            public void run() {
                MessageDialog.setFrame(Ui.getRoot());
                System.out.println("showInputDialog result = " + MessageDialog.showInputDialog(Ui.getRoot(), Msg.QUOTE("Dialog"), Msg.QUOTE("Label"), new NoSpacesInputValidator(Msg.QUOTE("No spaces Error!")), "SuggestedName"));
            }
        };
        final Object[] locales = new Object[]{Locale.ENGLISH, Locale.US, Locale.JAPANESE};
        BaseAction showInputDialog = new BaseAction(UIMsg.TO_MSG("Show Input Dialog")){

            @Override
            public void run() {
                Object[] result = DialogFactory.showInputDialog(parent.getOwnerWindow(), UIMsg.TO_MSG("My Title"), UIMsg.TO_MSG("Show Input Dialog"), locales, Locale.US, true);
                System.out.println("showInputDialog result=" + result);
            }
        };
        panel.add(new Button((UiContainer)panel, showError));
        panel.add(new Button((UiContainer)panel, showDetailError));
        panel.add(new Button((UiContainer)panel, showWarning));
        panel.add(new Button((UiContainer)panel, showOkCancelDialog));
        panel.add(new Button((UiContainer)panel, showInputDialog));
        panel.add(new Button((UiContainer)panel, showNewModuleDialog));
        panel.add(new Button((UiContainer)panel, showNormalInputDialog));
        return panel;
    }

    private static class TestDialog
    extends OkCancelDialog {
        public TestDialog() {
            super(Ui.getRoot());
            this.initComponents();
        }

        public void initComponents() {
            UiContainer contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            Panel panel = this.createPagePanel(contentPane);
            contentPane.add(panel, "Center");
            this.setIconImage(Image.create(UIMsg.ARROW));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        @Override
        public void ok() {
            System.out.println("Ok was pressed!");
        }

        protected UiComponent createMainPanel(UiContainer parent) {
            Panel panel = this.createPanel(parent);
            Label label = Label.create((UiContainer)panel, Msg.QUOTE("This is just a demo. This page is not implemented yet."));
            label.setHorizontalAlignment(0);
            panel.add(label, "Center");
            return panel;
        }

        protected Panel createPanel(UiContainer parent) {
            Panel panel = new Panel(parent){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    for (UiComponent component : this.getComponents()) {
                        component.setEnabled(enabled);
                    }
                }
            };
            panel.setLayout(new BorderLayout());
            return panel;
        }

        protected Panel createOptionsPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            panel.setLayout(new FlowLayout(0));
            ItemListener radioBtnActionListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    System.out.println("SOURCE! = " + e.getSource());
                }
            };
            RadioButton r1 = new RadioButton(panel);
            RadioButton r2 = new RadioButton(panel);
            r1.addItemListener(radioBtnActionListener);
            r2.addItemListener(radioBtnActionListener);
            panel.add(r1);
            panel.add(r2);
            return panel;
        }

        private Panel createPagePanel(UiContainer parent) {
            RelativeLayout layout = new RelativeLayout();
            Panel contentPane = new Panel(parent);
            contentPane.setLayout(layout);
            Panel optionsPanel = this.createOptionsPanel(contentPane);
            LabelMultiline msgArea = new LabelMultiline(contentPane, this.createLabel());
            contentPane.add(optionsPanel, "optionsPanel");
            contentPane.add(msgArea, "label");
            contentPane.add(this.createMainPanel(contentPane), "mainPanel");
            Layout.fixToRoot(layout, "optionsPanel", AttributeType.TOP, 5);
            Layout.fixToRoot(layout, "optionsPanel", AttributeType.LEFT, 5);
            Layout.fixToRoot(layout, "optionsPanel", AttributeType.RIGHT, -5);
            Layout.fixToComp(layout, "label", AttributeType.TOP, "optionsPanel", AttributeType.BOTTOM, 5);
            Layout.fixToComp(layout, "label", AttributeType.LEFT, "optionsPanel");
            Layout.fixToComp(layout, "label", AttributeType.RIGHT, "optionsPanel");
            Layout.fixToComp(layout, "mainPanel", AttributeType.TOP, "label", AttributeType.BOTTOM, 5);
            Layout.fixToComp(layout, "mainPanel", AttributeType.LEFT, "label");
            Layout.fixToComp(layout, "mainPanel", AttributeType.RIGHT, "label");
            Layout.fixToRoot(layout, "mainPanel", AttributeType.BOTTOM, -5);
            return contentPane;
        }

        private Msg createLabel() {
            return UIMsg.TO_MSG("A title must be specified here for the default panel");
        }
    }
}

