/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;

public class SampleLayoutProblems
extends SampleBase {
    private static final String DESCRIPTION = "Esta es una descripcion bastante larga para ver que pasa con el layout cuando el texto se excede del ancho de la ventana. Hasta aca no hay ningun CRLF.";

    private SampleLayoutProblems() {
        super("Layout Problems");
    }

    public static SampleLayoutProblems create() {
        return new SampleLayoutProblems();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane(mainPanel);
        tabbedPane.addTab(UIMsg.TO_MSG("Tab Engine preferences"), this.buildTab(tabbedPane));
        tabbedPane.addTab(UIMsg.TO_MSG("Tab Relative Layout"), this.buildTabRelativeLayoutPanel(tabbedPane));
        tabbedPane.addTab(UIMsg.TO_MSG("Tab Border Layout"), this.buildTabBorderLayoutPanel(tabbedPane));
        tabbedPane.addTab(UIMsg.TO_MSG("Tab Button"), this.buildTabButton(tabbedPane));
        mainPanel.add(tabbedPane, "Center");
        return mainPanel;
    }

    private UiComponent buildTabButton(UiContainer parent) {
        return new Button(parent, "Test");
    }

    private UiComponent buildTabBorderLayoutPanel(UiContainer parent) {
        Panel panel = new Panel(parent, UIMsg.TO_MSG("TabBorderLayoutPanel"));
        panel.setLayout(new BorderLayout(5, 5));
        panel.setName("TabBorderLayoutPanel");
        TextArea textArea = new TextArea(panel);
        panel.add(new TextField((UiContainer)panel, "NORTH"), "North");
        panel.add(textArea, "Center");
        panel.add(new Button((UiContainer)panel, "EAST ->"), "East");
        panel.add(Label.create((UiContainer)panel, Msg.QUOTE("<- WEST")), "West");
        panel.add(new TextField((UiContainer)panel, "SOUTH"), "South");
        return panel;
    }

    private UiComponent buildTabRelativeLayoutPanel(UiContainer parent) {
        Panel panel = new Panel(parent, UIMsg.TO_MSG("TabRelativeLayoutPanel"));
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        panel.setName("TabRelativeLayoutPanel");
        LabelMultiline label = new LabelMultiline(panel, UIMsg.TO_MSG(DESCRIPTION));
        TextArea textArea = new TextArea(panel);
        Button button = new Button((UiContainer)panel, "EAST");
        TextField textField = new TextField((UiContainer)panel, "SOUTH");
        panel.add(label, "label");
        panel.add(textArea, "textArea");
        panel.add(button, "button");
        panel.add(textField, "textField");
        Layout.fixToRoot(layout, "label", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "label", AttributeType.RIGHT, -5);
        Layout.fixToRoot(layout, "label", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "textArea", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "textArea", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "textArea", AttributeType.TOP, "label", AttributeType.BOTTOM, 5);
        Layout.fixToComp(layout, "button", AttributeType.LEFT, "textArea");
        Layout.fixToComp(layout, "button", AttributeType.TOP, "textArea", AttributeType.BOTTOM, 5);
        Layout.fixToComp(layout, "textField", AttributeType.LEFT, "textArea");
        Layout.fixToComp(layout, "textField", AttributeType.RIGHT, "textArea");
        Layout.fixToComp(layout, "textField", AttributeType.TOP, "button", AttributeType.BOTTOM, 5);
        return panel;
    }

    private UiComponent buildTab(UiContainer parent) {
        ScrollPane scroll = new ScrollPane(parent);
        Panel panel = new Panel(scroll);
        panel.setName("TabRelativeLayoutPanel");
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        panel.add(this.buildGeneralNetworkingPanel(panel), "networking");
        panel.add(this.buildGeneralNetworkingPanel(panel), "execution");
        panel.add(this.buildGeneralNetworkingPanel(panel), "timeouts");
        panel.add(this.buildGeneralNetworkingPanel(panel), "roundtrip");
        panel.add(this.buildGeneralNetworkingPanel(panel), "jmx");
        Layout.fixTopDown(layout, "networking", "execution", "timeouts", "roundtrip", "jmx");
        scroll.setView(panel);
        return scroll;
    }

    private UiComponent buildGeneralNetworkingPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel panel = new Panel(parent, UIMsg.TO_MSG("Networking"));
        panel.setName("NetworkingRelativeLayoutPanel");
        panel.setLayout(layout);
        NumericField<Integer> workPortalPortSpinner = NumericField.createIntegerNumericField(panel);
        workPortalPortSpinner.setValue(8080);
        workPortalPortSpinner.setRange(1024, 64000);
        workPortalPortSpinner.setStepSize(1);
        workPortalPortSpinner.setColumns(6);
        TextField mailServerTextField = new TextField(panel);
        TextField adminMailTextField = new TextField(panel);
        Label workPortalPortLabel = Label.create((UiContainer)panel, UIMsg.TO_MSG("Web Portal Port"));
        Label mailServerLabel = Label.create((UiContainer)panel, UIMsg.TO_MSG("Mail.server"));
        Label adminMailLabel = Label.create((UiContainer)panel, UIMsg.TO_MSG("Admin@Mail.server"));
        panel.add(new LabelMultiline(panel, UIMsg.TO_MSG("Networking Additional Info")), "textArea");
        panel.add(workPortalPortLabel, "workPortalPortLabel");
        panel.add(workPortalPortSpinner, "workPortalPortSpinner");
        panel.add(mailServerLabel, "mailServerLabel");
        panel.add(mailServerTextField, "mailServerTextField");
        panel.add(adminMailLabel, "adminMailLabel");
        panel.add(adminMailTextField, "adminMailTextField");
        Layout.fixToRoot(layout, "textArea", AttributeType.TOP, 0);
        Layout.fixToRoot(layout, "textArea", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "textArea", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "workPortalPortSpinner", AttributeType.TOP, "textArea", AttributeType.BOTTOM, 10);
        Layout.fixToComp(layout, "workPortalPortSpinner", AttributeType.LEFT, "_container", AttributeType.HORIZONTAL_CENTER, 0);
        Layout.fixToComp(layout, "mailServerTextField", AttributeType.TOP, "workPortalPortSpinner", AttributeType.BOTTOM, 5);
        Layout.fixToComp(layout, "mailServerTextField", AttributeType.LEFT, "workPortalPortSpinner");
        Layout.fixToRoot(layout, "mailServerTextField", AttributeType.RIGHT, -10);
        Layout.fixToComp(layout, "adminMailTextField", AttributeType.TOP, "mailServerTextField", AttributeType.BOTTOM, 5);
        Layout.fixToComp(layout, "adminMailTextField", AttributeType.LEFT, "workPortalPortSpinner");
        Layout.fixToRoot(layout, "adminMailTextField", AttributeType.RIGHT, -10);
        Layout.fixToRoot(layout, "workPortalPortLabel", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "mailServerLabel", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "adminMailLabel", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "workPortalPortLabel", AttributeType.RIGHT, "workPortalPortSpinner", AttributeType.LEFT, -5);
        Layout.fixToComp(layout, "mailServerLabel", AttributeType.RIGHT, "mailServerTextField", AttributeType.LEFT, -5);
        Layout.fixToComp(layout, "adminMailLabel", AttributeType.RIGHT, "adminMailTextField", AttributeType.LEFT, -5);
        Layout.fixToComp(layout, "workPortalPortLabel", AttributeType.VERTICAL_CENTER, "workPortalPortSpinner");
        Layout.fixToComp(layout, "mailServerLabel", AttributeType.VERTICAL_CENTER, "mailServerTextField");
        Layout.fixToComp(layout, "adminMailLabel", AttributeType.VERTICAL_CENTER, "adminMailTextField");
        return panel;
    }
}

