/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SampleBaseTablePanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.EditionPanel;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

class SampleEditionPanel
extends SampleBase {
    SampleEditionPanel() {
        super("Edition Panel");
    }

    public static SampleEditionPanel create() {
        return new SampleEditionPanel();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        final EditionPanel editionPanel = new EditionPanel(parent);
        editionPanel.setLayout(new BorderLayout());
        Panel north = new Panel(editionPanel);
        north.setLayout(new FlowLayout());
        Button resetButton = new Button(north);
        final Label modifiedLabel = Label.create(north);
        modifiedLabel.setText("Not modified");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editionPanel.resetModified();
                modifiedLabel.setText("Not modified");
            }
        });
        resetButton.setText("Reset");
        north.add(modifiedLabel);
        north.add(resetButton);
        UiComponent center = SampleBaseTablePanel.create().buildEditorPanel(editionPanel);
        Panel south = new Panel(editionPanel);
        south.setLayout(new BoxLayout(south, 1));
        String[] values = new String[]{"Item1", "Item2", "Item3"};
        ComboBox<String> combo = UiFactory.createComboBox((UiContainer)south, false, values);
        ComboBox<String> editableCombo = UiFactory.createComboBox((UiContainer)south, true, values);
        CheckBox checkBox = CheckBox.create(south, UIMsg.TO_MSG("CheckBox"), false);
        RadioButton radio = new RadioButton((UiContainer)south, UIMsg.TO_MSG("Radio"));
        TextField textField = new TextField(south);
        TextArea textArea = new TextArea(south);
        NumericField<Integer> intNumber = NumericField.createIntegerNumericField(south, false);
        south.add(combo);
        south.add(editableCombo);
        south.add(checkBox);
        south.add(radio);
        south.add(textField);
        south.add(textArea);
        south.add(intNumber);
        editionPanel.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                modifiedLabel.setText("Modified");
            }
        });
        editionPanel.add(north, "North");
        editionPanel.add(center, "Center");
        editionPanel.add(south, "South");
        return editionPanel;
    }
}

