/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.io.Serializable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.text.NonScrollTextArea;
import oracle.bpm.ui.text.TextArea;

class SampleDraw
extends SampleBase {
    private SampleDraw() {
        super("Draw");
    }

    public static SampleDraw create() {
        return new SampleDraw();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        return new SampleCanvas(parent);
    }

    private static class SampleCanvas
    extends PaintCanvas {
        private UiComponent component;
        private JTextArea jtext;

        SampleCanvas(UiContainer parent) {
            super(parent);
            this.addComponentsToCanvas();
            this.initComponentToBeDrawnOnCanvas();
        }

        @Override
        public Dimension getPreferredSize() {
            return Dimension.valueOf(800, 800);
        }

        @Override
        public void paintCanvas(Graphics g) {
            Serializable bounds;
            g.setAntialiasing(AntialiasingMode.ON);
            Dimension size = this.getSize();
            System.out.println(size);
            g.drawLine(2, 2, size.getWidth(), size.getHeight());
            g.setBackground(Color.RED);
            g.fillOval(0, 0, 10, 10);
            g.setFont(Font.valueOf("Tahoma", FontStyle.PLAIN, 8));
            g.drawString("Hola Mundo (100, 100)", 100, 100);
            g.drawVerticalString("Hola Mundo Vertical (150, 350)", 150, 350, 128);
            g.drawVerticalString("Hola Mundo Vertical (170, 350)", 170, 350, 1024);
            Font font = Font.valueOf("SansSerif", FontStyle.PLAIN, 8);
            String text = "Hola Mundo size 8 (100, 50)";
            g.setFont(font);
            g.drawString(text, 100, 50);
            int width = Ui.getToolkit().getFontMetrics(font).stringWidth(text);
            int height = Ui.getToolkit().getFontMetrics(font).getHeight();
            Rectangle rect = new Rectangle(100, 50 - height, width, height);
            g.draw(rect);
            font = Font.valueOf("SansSerif", FontStyle.PLAIN, 10);
            text = "Hola Mundo size 10 (100, 100)";
            g.setFont(font);
            g.drawString(text, 100, 100);
            width = Ui.getToolkit().getFontMetrics(font).stringWidth(text);
            height = Ui.getToolkit().getFontMetrics(font).getHeight();
            rect = new Rectangle(100, 100 - height, width, height);
            g.draw(rect);
            font = Font.valueOf("SansSerif", FontStyle.PLAIN, 14);
            text = "Hola Mundo size 14 (100, 200)";
            g.setFont(font);
            g.drawString(text, 100, 200);
            width = Ui.getToolkit().getFontMetrics(font).stringWidth(text);
            height = Ui.getToolkit().getFontMetrics(font).getHeight();
            rect = new Rectangle(100, 200 - height, width, height);
            g.draw(rect);
            font = Font.valueOf("SansSerif", FontStyle.PLAIN, 18);
            text = "Hola Mundo size 18 (100, 200)";
            g.setFont(font);
            g.drawString(text, 100, 300);
            width = Ui.getToolkit().getFontMetrics(font).stringWidth(text);
            height = Ui.getToolkit().getFontMetrics(font).getHeight();
            rect = new Rectangle(100, 300 - height, width, height);
            g.draw(rect);
            font = Font.valueOf("SansSerif", FontStyle.PLAIN, 22);
            text = "Hola Mundo size 22 (100, 400)";
            g.setFont(font);
            g.drawString(text, 100, 400);
            width = g.getFontMetrics(font).stringWidth(text);
            height = g.getFontMetrics(font).getHeight();
            rect = new Rectangle(100, 400 - height, width, height);
            g.draw(rect);
            g.drawLine(100, 400, 1000, 400);
            text = "Hola Mundo Vertical (500, 450)";
            g.drawVerticalString(text, 500, 450, 128);
            rect = new Rectangle();
            g.draw(rect);
            g.drawLine(500, 450, 500, 0);
            g.drawVerticalString("Hola Mundo Vertical (550, 450)", 550, 450, 1024);
            g.drawLine(550, 450, 550, 0);
            g.drawLine(0, 150, size.getHeight(), 150);
            if (this.component != null) {
                this.component.setSize(this.component.getPreferredSize());
                this.component.setLocation(250, 400);
                bounds = this.component.getBounds();
                UiUtilities.paintComponent(g, this.component, this, (Rectangle)bounds);
            }
            if (this.jtext != null) {
                bounds = this.jtext.getBounds();
                SwingUtilities.paintComponent(AwtConverter.toAwt(g), this.jtext, this.asSwing(), bounds);
            }
        }

        private void initComponentToBeDrawnOnCanvas() {
            NonScrollTextArea component = this.createNonScrollTextArea();
            component.setLocation(250, 400);
            this.component = component;
        }

        private void addComponentsToCanvas() {
            Button button = this.createButton();
            this.add(button);
            TextArea area = this.createTextArea();
            this.add(area);
        }

        private Button createButton() {
            Button button = new Button((UiContainer)this, "Button Text");
            button.setLocation(100, 200);
            button.setSize(button.getPreferredSize());
            return button;
        }

        private TextArea createTextArea() {
            TextArea area = new TextArea(this, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
            area.setLocation(100, 300);
            area.setRows(5);
            area.setColumns(10);
            area.setLineWrap(true);
            area.setSize(area.getPreferredSize());
            area.setText("This is a component on canvas with scroll policy NEVER! \nThis is a component on canvas with scroll policy NEVER!");
            return area;
        }

        private NonScrollTextArea createNonScrollTextArea() {
            NonScrollTextArea area = new NonScrollTextArea(this);
            area.setLocation(100, 300);
            area.setRows(5);
            area.setColumns(10);
            area.setLineWrap(true);
            area.setSize(area.getPreferredSize());
            area.setText("This is a component on canvas with scroll policy NEVER! \nThis is a component on canvas with scroll policy NEVER!");
            return area;
        }

        private JTextArea createJTextArea() {
            JTextArea text = new JTextArea(5, 10);
            text.setBorder(new LineBorder(java.awt.Color.BLACK, 1));
            text.setLineWrap(true);
            text.setLocation(100, 400);
            text.setSize(text.getPreferredSize());
            text.setText("This is a component on canvas with scroll policy NEVER! \nThis is a component on canvas with scroll policy NEVER!");
            return text;
        }
    }
}

