/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ModifyEvent;
import oracle.bpm.ui.event.ModifyListener;

class SampleComboBox
extends SampleBase {
    private SampleComboBox() {
        super("ComboBox");
    }

    public static SampleComboBox create() {
        return new SampleComboBox();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        final ArrayList<Locale> contents = new ArrayList<Locale>();
        contents.add(Locale.US);
        contents.add(Locale.CANADA);
        contents.add(Locale.CHINA);
        contents.add(Locale.FRANCE);
        final ArrayList<Locale> contents2 = new ArrayList<Locale>();
        contents2.add(Locale.GERMANY);
        contents2.add(Locale.KOREAN);
        contents2.add(Locale.ITALIAN);
        contents2.add(Locale.FRANCE);
        contents2.add(Locale.UK);
        Panel regularComboBoxPanel = new Panel(panel);
        Label regularLabel = Label.create((UiContainer)regularComboBoxPanel, Msg.QUOTE("Regular: "));
        final ComboBox regularCombo = UiFactory.createComboBox(regularComboBoxPanel);
        regularCombo.setForeground(Color.YELLOW);
        regularCombo.setColorProvider(new ColorProvider(){

            public Color getBackground(Object element) {
                return Color.WHITE;
            }

            public Color getForeground(Object element) {
                return element.toString().equals("en_US") ? Color.RED : Color.BLUE;
            }
        });
        regularComboBoxPanel.add(regularLabel);
        regularComboBoxPanel.add(regularCombo);
        regularCombo.addItems(contents);
        assert (regularCombo.getItemCount() == 4) : regularCombo.getItemCount();
        Panel editableComboBoxPanel = new Panel(panel);
        Label editableLabel = Label.create((UiContainer)editableComboBoxPanel, Msg.QUOTE("Editable: "));
        ComboBox editableCombo = UiFactory.createComboBox((UiContainer)editableComboBoxPanel, true);
        editableComboBoxPanel.add(editableLabel);
        editableComboBoxPanel.add(editableCombo);
        editableCombo.addItems(contents);
        assert (editableCombo.getItemCount() == 4) : regularCombo.getItemCount();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.isStateSelected()) {
                    System.out.println("ItemListener.itemStateChanged() " + item + " source=" + e.getSource() + " item=" + e.getItem() + " selected=" + e.isStateSelected());
                }
            }
        };
        regularCombo.addItemListener(itemListener);
        editableCombo.addItemListener(itemListener);
        ItemListener itemListener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("ActionListener.actionPerformed()");
            }
        };
        regularCombo.addItemListener(itemListener1);
        editableCombo.addItemListener(itemListener1);
        editableCombo.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                System.out.println("ModifyListener.modifyText " + e);
            }
        });
        System.out.println("SampleComboBox.buildEditorPanel() Fuerzo un valor program\u00e1ticamente");
        regularCombo.setSelectedItem(Locale.CHINA);
        LabelProvider.Default<Locale> labelProvider = new LabelProvider.Default<Locale>(){

            @Override
            public String getText(Locale element) {
                String result = "";
                if (element != null) {
                    result = element.getDisplayLanguage() + " (" + element.getDisplayCountry() + ")";
                }
                return result;
            }
        };
        regularCombo.setLabelProvider(labelProvider);
        editableCombo.setLabelProvider(labelProvider);
        panel.add(regularComboBoxPanel);
        panel.add(editableComboBoxPanel);
        Button cleanButton = new Button(panel);
        cleanButton.setText("Clean and Create Item in Regular Combo");
        cleanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                regularCombo.removeAllItems();
                regularCombo.addItem(Locale.CANADA_FRENCH);
                regularCombo.setSelectedItem(Locale.CANADA_FRENCH);
            }
        });
        panel.add(cleanButton);
        Panel modelComboBoxPanel = new Panel(panel);
        Label modelLabel = Label.create((UiContainer)modelComboBoxPanel, Msg.QUOTE("Changing model: "));
        final ComboBox modelCombo = UiFactory.createComboBox(modelComboBoxPanel);
        modelComboBoxPanel.add(modelLabel);
        modelComboBoxPanel.add(modelCombo);
        modelCombo.addItems(contents);
        modelCombo.setLabelProvider(labelProvider);
        panel.add(modelComboBoxPanel);
        Button modelButton1 = new Button(panel);
        modelButton1.setText("Model 1 in Changing Model Combo");
        modelButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                modelCombo.setModelList(contents);
            }
        });
        Button modelButton2 = new Button(panel);
        modelButton2.setText("Model 2 in Changing Model Combo");
        modelButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                modelCombo.setModelList(contents2);
            }
        });
        panel.add(modelButton1);
        panel.add(modelButton2);
        return panel;
    }
}

