/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;

class SampleCheckTree
extends SampleBase {
    public SampleCheckTree(String description) {
        super(description);
    }

    public static Panel buildTree(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BorderLayout());
        final CheckTreeNode root = new CheckTreeNode("I am the Root of the world!");
        final CheckTree checkTree = new CheckTree((UiContainer)panel, root);
        panel.add(checkTree, "Center");
        checkTree.setRootVisible(false);
        CheckTreeNode child1 = new CheckTreeNode("Child 1");
        child1.setTree(checkTree);
        root.add(child1);
        child1.add(new CheckTreeNode("GrandChild 1-1"));
        child1.add(new CheckTreeNode("GrandChild 1-2"));
        CheckTreeNode child1_3 = new CheckTreeNode("GrandChild 1-3");
        child1.add(child1_3);
        child1_3.setTree(checkTree);
        child1_3.setSelected(TreeNode.Selection.ALL);
        CheckTreeNode child2 = new CheckTreeNode("Child 2");
        child2.setTree(checkTree);
        root.add(child2);
        child2.add(new CheckTreeNode("GrandChild 2-1"));
        child2.add(new CheckTreeNode("GrandChild 2-2"));
        CheckTreeNode child2_3 = new CheckTreeNode("GrandChild 2-3");
        child2_3.setTree(checkTree);
        child2_3.setSelected(TreeNode.Selection.ALL);
        child2.add(child2_3);
        checkTree.reload();
        Button button = new Button((UiContainer)panel, "Press me to add a node!");
        panel.add(button, "South");
        button.setAction(new BaseAction(){

            @Override
            public void run() {
                CheckTreeNode child2_3 = new CheckTreeNode("The new one");
                child2_3.setTree(checkTree);
                child2_3.setSelected(TreeNode.Selection.ALL);
                root.add(child2_3);
                checkTree.reload();
            }
        });
        checkTree.addCheckSelectionListener(new CheckSelectionListener(){

            @Override
            public void checkedSelectionChanged(CheckSelectionChangedEvent e) {
                System.out.println("Se cambi\u00f3 el conjunto de checkeados!!!");
                System.out.print("El cambio fue dado en nodo " + e.getSource().getUserObject());
                System.out.println(" y cambi\u00f3 a " + (Object)((Object)e.getSelection()) + "\n");
            }
        });
        checkTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                System.out.println("Se cambi\u00f3 el nodo seleccionado!!!\n");
            }
        });
        return panel;
    }

    public static SampleCheckTree create() {
        return new SampleCheckTree("CheckTree");
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        return SampleCheckTree.buildTree(parent);
    }
}

