/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.Arrays;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;

public class SampleBaseTablePanel
extends SampleBase {
    private SampleBaseTablePanel() {
        super("Base Table Panel");
    }

    public static SampleBaseTablePanel create() {
        return new SampleBaseTablePanel();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        return new AssignedValues(parent);
    }

    private static class AssignedValues
    extends BaseTablePanel {
        AssignedValues(UiContainer parent) {
            super(parent, UIMsg.TO_MSG("Title"), UIMsg.TO_MSG("Description"));
            this.setModel(new TableValueModel());
        }

        @Override
        protected void addAction() {
            String value = MessageDialog.showInput(this.getOwnerWindow(), UIMsg.TO_MSG("Value"), UIMsg.TO_MSG("Value"));
            if (value == null || value.trim().length() == 0) {
                return;
            }
            value = value.trim();
            TableValueModel model = this.getModel();
            if (model.getRowIndex(value.toUpperCase()) > -1) {
                MessageDialog.showError(UIMsg.TO_MSG("Value"), UIMsg.TO_MSG("Duplicated Value"));
                return;
            }
            model.insertRow(value);
        }

        @Override
        protected TableValueModel getModel() {
            return (TableValueModel)super.getModel();
        }

        void setValues(Collection<String> values) {
            this.getModel().setValues(values);
        }

        Collection<String> getValues() {
            return this.getModel().getValues();
        }

        public static class TableValueModel
        extends ProviderTableModel<String> {
            private static String[] VALUES = new String[]{"AAA", "BBB", "CCC", "DDD", "EEE"};

            TableValueModel() {
                this(Arrays.asList(VALUES));
            }

            TableValueModel(Collection<String> values) {
                super(MsgList.create(UIMsg.TO_MSG("Value")));
                this.setValues(values);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return this.getRow(row);
            }

            Collection<String> getValues() {
                return this.getData();
            }

            void insertRow(String value) {
                this.addRow(value.toUpperCase());
            }

            private void setValues(Collection<String> values) {
                this.removeAllElements();
                if (values == null) {
                    return;
                }
                for (String value : values) {
                    this.insertRow(value);
                }
            }
        }
    }
}

