/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.ProviderTableModel;

class LocaleTableModel
extends ProviderTableModel<Locale> {
    private static final int COLUMN_NAME = 0;
    private static final MsgList TITLES = MsgList.create(Msg.QUOTE("Display Name"), Msg.QUOTE("Display Language"));

    public LocaleTableModel() {
        super(TITLES);
        this.populate(LocaleTableModel.getLocales());
    }

    @Override
    public Object getValueAt(int row, int column) {
        Locale locale = (Locale)this.getRow(row);
        switch (column) {
            case 0: {
                return locale.getDisplayName();
            }
        }
        return locale.getDisplayLanguage(locale);
    }

    private static Locale[] getLocales() {
        return Locale.getAvailableLocales();
    }

    private void insertRow(Locale locale) {
        this.addRow(locale);
    }

    private void populate(Locale[] locales) {
        for (int i = 0; i < locales.length; ++i) {
            this.insertRow(locales[i]);
        }
    }
}

