/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import java.util.ArrayList;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.ProviderTableModel;

public class DynamicTableModel
extends ProviderTableModel<Locale> {
    boolean simpleMode = true;
    private static final int COLUMN_DISPLAY_NAME = 0;
    private static final int COLUMN_DISPLAY_LANGUAGE = 1;
    private static final int COLUMN_LANGUAGE = 2;
    private static final int COLUMN_COUNTRY = 3;
    private static final int COLUMN_VARIANT = 4;
    private static final MsgList TITLES_SIMPLE = MsgList.create(Msg.QUOTE("Display Name"), Msg.QUOTE("Display Language"));
    private static final MsgList TITLES_ADVANCE = MsgList.create(Msg.QUOTE("Display Name"), Msg.QUOTE("Display Language"), Msg.QUOTE("Language"), Msg.QUOTE("Country"), Msg.QUOTE("Variant"));

    public DynamicTableModel() {
        super(TITLES_SIMPLE);
        this.populate();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Locale locale = (Locale)this.getRow(row);
        switch (column) {
            case 0: {
                return locale.getDisplayName();
            }
            case 1: {
                return locale.getDisplayLanguage(locale);
            }
            case 2: {
                return locale.getLanguage();
            }
            case 3: {
                return locale.getCountry();
            }
            case 4: {
                return locale.getVariant();
            }
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return this.isSimpleMode() ? TITLES_SIMPLE.size() : TITLES_ADVANCE.size();
    }

    @Override
    public String getColumnName(int column) {
        MsgList list = this.isSimpleMode() ? TITLES_SIMPLE : TITLES_ADVANCE;
        Msg msg = (Msg)list.get(column);
        return msg != null ? msg.toString() : "<Null>";
    }

    public void switchView() {
        this.simpleMode = !this.simpleMode;
        this.removeAllElements();
        this.fireTableStructureChanged();
        this.populate();
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    private Locale[] getLocales() {
        Locale[] result;
        if (this.isSimpleMode()) {
            Locale[] locales = Locale.getAvailableLocales();
            ArrayList<Locale> list = new ArrayList<Locale>();
            for (int i = 0; i < locales.length; ++i) {
                if (locales[i].getCountry().length() != 0) continue;
                list.add(locales[i]);
            }
            result = list.toArray(new Locale[list.size()]);
        } else {
            result = Locale.getAvailableLocales();
        }
        return result;
    }

    private void populate() {
        this.addRows(this.getLocales());
    }
}

