/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.datastore;

import com.collaxa.cube.engine.core.ICubeProcess;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import oracle.bpm.analytics.bpel.datastore.model.BpmPartnerService;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcess;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcessPartner;
import oracle.j2ee.ws.wsdl.extensions.schema.Constants;
import oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TPartnerLink;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TPartnerLinks;

public class BpmProcessPartnerHandler {
    private static WSDLFactory s_wsdl_factory;

    private BpmProcessPartnerHandler() {
    }

    public static List<BpmProcessPartner> createProcessPartners(Session session, UnitOfWork uow, BpmProcess bpmProcess, TPartnerLinks partnerLinks, ICubeProcess.InitiationInfo[] initiationInfo, Definition wsdlDefinition) throws Exception {
        ArrayList<BpmProcessPartner> result = new ArrayList<BpmProcessPartner>();
        if (partnerLinks.getPartnerLinkList() == null) {
            return result;
        }
        Map portTypeMap = wsdlDefinition.getPortTypes();
        for (TPartnerLink partnerLink : partnerLinks.getPartnerLinkList()) {
            BpmProcessPartner bpmProcessPartner = (BpmProcessPartner)uow.registerObject((Object)new BpmProcessPartner());
            BpmProcess bpmProcessClone = (BpmProcess)uow.registerObject((Object)bpmProcess);
            bpmProcessPartner.setBpmProcess(bpmProcessClone);
            bpmProcessPartner.setName(partnerLink.getName());
            bpmProcessPartner.setPartnerLinkType(partnerLink.getPartnerLinkType().toString());
            if (partnerLink.isSetMyRole()) {
                bpmProcessPartner.setMyRole(partnerLink.getMyRole());
            }
            if (partnerLink.isSetPartnerRole()) {
                bpmProcessPartner.setPartnerrole(partnerLink.getPartnerRole());
            }
            for (Map.Entry p : portTypeMap.entrySet()) {
                if (!((QName)p.getKey()).toString().equals(bpmProcessPartner.getPartnerLinkType().toString())) continue;
                BpmProcessPartnerHandler.createPartnerServices(session, uow, bpmProcessPartner, initiationInfo, portTypeMap);
            }
            result.add(bpmProcessPartner);
        }
        return result;
    }

    private static void createPartnerServices(Session session, UnitOfWork uow, BpmProcessPartner bpmProcessPartner, ICubeProcess.InitiationInfo[] initiationInfo, Map<QName, PortType> portTypeMap) throws Exception {
        BpmPartnerService bpmPartnerService;
        if (initiationInfo != null) {
            for (int i = 0; i < initiationInfo.length; ++i) {
                if (!bpmProcessPartner.getName().equals(initiationInfo[i].partnerLinkName) || !bpmProcessPartner.getPartnerLinkType().equals(initiationInfo[i].partnerLinkTypeQName.toString())) continue;
                bpmPartnerService = (BpmPartnerService)uow.registerNewObject((Object)new BpmPartnerService());
                bpmPartnerService.setIsInitiating("Y");
                bpmPartnerService.setOperation(initiationInfo[i].operationName);
                bpmPartnerService.setPortType(initiationInfo[i].portTypeQName.toString());
                bpmProcessPartner.addToBpmPartnerServiceCollection(bpmPartnerService);
            }
        }
        for (Map.Entry<QName, PortType> portType : portTypeMap.entrySet()) {
            List opList = portType.getValue().getOperations();
            for (Operation op : opList) {
                if (BpmProcessPartnerHandler.isInitiating(initiationInfo, op)) continue;
                bpmPartnerService = (BpmPartnerService)uow.registerNewObject((Object)new BpmPartnerService());
                bpmPartnerService.setIsInitiating("N");
                bpmPartnerService.setOperation(op.getName());
                bpmPartnerService.setPortType(portType.getKey().toString());
                bpmProcessPartner.addToBpmPartnerServiceCollection(bpmPartnerService);
            }
        }
    }

    public static Definition readWSDL(String wsdlURI) throws Exception {
        Definition result = null;
        if (wsdlURI == null) {
            return null;
        }
        WSDLReader reader = s_wsdl_factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        String contextURI = null;
        ExtensionRegistry er = reader.getExtensionRegistry();
        if (er == null) {
            reader.setExtensionRegistry(BpmProcessPartnerHandler.getDefaultExtensionRegistry());
        } else {
            BpmProcessPartnerHandler.addDefaultSerializerAndDeserializer(er);
        }
        result = reader.readWSDL(contextURI, wsdlURI);
        if (result != null) {
            BpmProcessPartnerHandler.populateDocumentBaseURI(result, wsdlURI);
        }
        return result;
    }

    private static boolean isInitiating(ICubeProcess.InitiationInfo[] initiationInfo, Operation op) {
        if (initiationInfo != null) {
            for (int i = 0; i < initiationInfo.length; ++i) {
                if (!initiationInfo[i].operationName.equals(op.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static ExtensionRegistry getDefaultExtensionRegistry() {
        ExtensionRegistry er = ((WSDLFactoryImpl)s_wsdl_factory).newPopulatedExtensionRegistry();
        BpmProcessPartnerHandler.addDefaultSerializerAndDeserializer(er);
        return er;
    }

    private static void addDefaultSerializerAndDeserializer(ExtensionRegistry er) {
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_1999, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_1999, er.getDefaultSerializer());
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2000, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2000, er.getDefaultSerializer());
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2001, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2001, er.getDefaultSerializer());
    }

    private static void populateDocumentBaseURI(Definition def, String wsdlURI) {
        Map map;
        if (def.getDocumentBaseURI() == null) {
            def.setDocumentBaseURI(wsdlURI);
        }
        if ((map = def.getImports()) != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                List aList = (List)map.get(it.next());
                Import imp = (Import)aList.get(0);
                if (imp.getDefinition().getDocumentBaseURI() != null) continue;
                imp.getDefinition().setDocumentBaseURI(BpmProcessPartnerHandler.getDocumentBaseURI(wsdlURI, imp.getLocationURI()));
            }
        }
    }

    private static String getDocumentBaseURI(String wsdlURI, String impLocation) {
        if (impLocation != null) {
            try {
                URL impURL = new URL(impLocation);
                return impURL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            s_wsdl_factory = WSDLFactory.newInstance((String)"oracle.webservices.wsdl.WSDLFactoryImpl");
        }
        catch (WSDLException wsdle) {
            wsdle.printStackTrace();
        }
    }
}

