/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.datastore;

import com.oracle.schemas.bpel.extension.AnnotationDocument;
import com.oracle.schemas.bpel.extension.DocumentationDocument;
import com.oracle.schemas.bpel.extension.PropertyType;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.analytics.AnalyticsLogger;
import oracle.bpm.analytics.bpel.BpelActivityEnum;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivity;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivityProperty;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcess;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcessPartner;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TActivityContainer;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TActivityOrCompensateContainer;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TAssign;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCatch;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCompensate;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCompensationHandler;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCopy;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCorrelation;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TCorrelations;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TEmpty;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TEventHandlers;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TFaultHandlers;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TFlow;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TFrom;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TInvoke;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TOnAlarm;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TOnMessage;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TPick;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TProcess;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TReceive;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TReply;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TScope;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TSequence;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TSwitch;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TTerminate;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TThrow;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TTo;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TWait;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TWhile;

public final class BpmActivityHandler {
    private static final String CLASSNAME = "BpmActivityHandler";
    public static final String BPM_PARTNER_SERVICE_QUERY = "ExternalProcessServiceQuery";

    private BpmActivityHandler() {
    }

    public static BpmActivity createActivityNode(Session session, UnitOfWork uow, BpmProcess bpmProcess, List<BpmProcessPartner> partnerList, BpmActivity sourceActivity, XmlObject activity, int level, long seqNumber, String branchPrefix, long branchCounter) {
        String methodName = "createActivityNode";
        if (activity instanceof AnnotationDocument.Annotation) {
            BpmActivityProperty activityProperty;
            List propertyList;
            AnnotationDocument.Annotation annotation = (AnnotationDocument.Annotation)activity;
            List docList = annotation.getDocumentationList();
            if (annotation.getPattern() != null && annotation.getPattern().getPatternName() != null && sourceActivity != null) {
                sourceActivity.setPattern(annotation.getPattern().getPatternName().getLocalPart());
                AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"pattern ", (Object)sourceActivity.getPattern(), (Object)", name: ", (Object)sourceActivity.getName());
                if (annotation.getPattern().getPatternName().getLocalPart().equals("decide")) {
                    sourceActivity.setIsExtension(BpelActivityEnum.DECIDE.isExtension() ? "Y" : "N");
                    sourceActivity.setIsWsOperation(BpelActivityEnum.DECIDE.isWsOperation() ? "Y" : "N");
                    AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"decide activity: ", (Object)sourceActivity.getName());
                } else if (annotation.getPattern().getPatternName().getLocalPart().equals("workflow")) {
                    sourceActivity.setIsExtension(BpelActivityEnum.WORKFLOW.isExtension() ? "Y" : "N");
                    sourceActivity.setIsWsOperation(BpelActivityEnum.WORKFLOW.isWsOperation() ? "Y" : "N");
                    AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"workflow activity: ", (Object)sourceActivity.getName());
                }
            }
            if (docList != null && docList.size() > 1) {
                sourceActivity.setDocumentation(((DocumentationDocument.Documentation)docList.get(0)).toString());
            }
            if (annotation.isSetAnalysis()) {
                AnnotationDocument.Annotation.Analysis analysis = annotation.getAnalysis();
                propertyList = analysis.getPropertyList();
                for (PropertyType prop : propertyList) {
                    activityProperty = (BpmActivityProperty)uow.registerNewObject((Object)new BpmActivityProperty());
                    activityProperty.setBpmActivity(sourceActivity);
                    activityProperty.setName(prop.getName());
                    activityProperty.setQname(new QName(analysis.getDomNode().getNamespaceURI(), "analysis").toString());
                    activityProperty.setDefaultvalue(BpmActivityHandler.getTextToken((XmlObject)prop));
                    AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)sourceActivity.getName(), (Object)", analysis property: ", (Object)activityProperty.getName(), (Object)", value ", (Object)activityProperty.getDefaultvalue());
                }
            }
            if (annotation.isSetGeneral()) {
                AnnotationDocument.Annotation.General general = annotation.getGeneral();
                propertyList = general.getPropertyList();
                for (PropertyType prop : propertyList) {
                    activityProperty = (BpmActivityProperty)uow.registerNewObject((Object)new BpmActivityProperty());
                    activityProperty.setBpmActivity(sourceActivity);
                    activityProperty.setName(prop.getName());
                    activityProperty.setQname(new QName(general.getDomNode().getNamespaceURI(), "general").toString());
                    activityProperty.setDefaultvalue(BpmActivityHandler.getTextToken((XmlObject)prop));
                    AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)sourceActivity.getName(), (Object)", general property: ", (Object)activityProperty.getName(), (Object)", value ", (Object)activityProperty.getDefaultvalue());
                }
            }
            return null;
        }
        BpmActivity bpmActivity = (BpmActivity)uow.registerNewObject((Object)new BpmActivity());
        String nodeId = BpmActivityHandler.getNodeId(activity);
        if (nodeId != null) {
            bpmActivity.setNodeId(nodeId);
        }
        bpmActivity.setNodeLevel(level);
        bpmActivity.setNodeSequenceNumber(seqNumber);
        if (branchPrefix != null) {
            bpmActivity.setNodeBranch(branchPrefix + branchCounter);
        } else {
            bpmActivity.setNodeBranch(Long.toString(branchCounter));
        }
        AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"Activity Class ", (Object)activity.getClass().getName(), (Object)", node branch ", (Object)bpmActivity.getNodeBranch(), (Object)", level ", (Object)bpmActivity.getNodeLevel(), (Object)", seq# ", (Object)bpmActivity.getNodeSequenceNumber());
        if (activity instanceof TProcess) {
            TProcess process = (TProcess)activity;
            bpmActivity.setName(process.getName());
            bpmActivity.setType(BpelActivityEnum.PROCESS.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.PROCESS.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
            return bpmActivity;
        }
        if (activity instanceof TEmpty) {
            bpmActivity.setName(((TEmpty)activity).getName());
            bpmActivity.setType(BpelActivityEnum.EMPTY.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.EMPTY.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TInvoke) {
            TInvoke invoke = (TInvoke)activity;
            bpmActivity.setName(((TInvoke)activity).getName());
            bpmActivity.setType(BpelActivityEnum.INVOKE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.INVOKE.isWsOperation() ? "Y" : "N");
            bpmActivity.setOperation(invoke.getOperation());
            bpmActivity.setPortType(invoke.getPortType().toString());
            bpmActivity.setSourceCode(activity.xmlText());
            BpmProcessPartner processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, invoke.getPartnerLink());
            if (processPartner != null) {
                bpmActivity.setPartner(processPartner);
            }
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TReceive) {
            TReceive receive = (TReceive)activity;
            bpmActivity.setName(((TReceive)activity).getName());
            bpmActivity.setType(BpelActivityEnum.RECEIVE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.RECEIVE.isWsOperation() ? "Y" : "N");
            bpmActivity.setOperation(receive.getOperation());
            bpmActivity.setPortType(receive.getPortType().toString());
            bpmActivity.setVariable(receive.getVariable());
            bpmActivity.setSourceCode(activity.xmlText());
            BpmProcessPartner processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, receive.getPartnerLink());
            if (processPartner != null) {
                bpmActivity.setPartner(processPartner);
            }
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TReply) {
            TReply reply = (TReply)activity;
            bpmActivity.setName(((TReply)activity).getName());
            bpmActivity.setType(BpelActivityEnum.REPLY.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.REPLY.isWsOperation() ? "Y" : "N");
            bpmActivity.setOperation(reply.getOperation());
            bpmActivity.setPortType(reply.getPortType().toString());
            bpmActivity.setVariable(reply.getVariable());
            bpmActivity.setSourceCode(activity.xmlText());
            BpmProcessPartner processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, reply.getPartnerLink());
            if (processPartner != null) {
                bpmActivity.setPartner(processPartner);
            }
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TAssign) {
            bpmActivity.setName(((TAssign)activity).getName());
            bpmActivity.setType(BpelActivityEnum.ASSIGN.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.ASSIGN.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TCopy) {
            bpmActivity.setType(BpelActivityEnum.COPY.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.COPY.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TFrom) {
            BpmProcessPartner processPartner;
            TFrom from = (TFrom)activity;
            if (from.getExpression() != null) {
                bpmActivity.setExpression(from.getExpression());
            } else if (from.getVariable() != null) {
                bpmActivity.setVariable(from.getVariable());
                bpmActivity.setPart(from.getPart());
                bpmActivity.setExpression(from.getQuery());
            } else if (from.getPartnerLink() != null && (processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, from.getPartnerLink())) != null) {
                bpmActivity.setPartner(processPartner);
            }
            bpmActivity.setType(BpelActivityEnum.FROM.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.FROM.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TTo) {
            BpmProcessPartner processPartner;
            TTo to = (TTo)activity;
            if (to.getVariable() != null) {
                bpmActivity.setVariable(to.getVariable());
                bpmActivity.setPart(to.getPart());
                bpmActivity.setExpression(to.getQuery());
            } else if (to.getPartnerLink() != null && (processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, to.getPartnerLink())) != null) {
                bpmActivity.setPartner(processPartner);
            }
            bpmActivity.setType(BpelActivityEnum.TO.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.TO.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TWait) {
            bpmActivity.setName(((TWait)activity).getName());
            bpmActivity.setType(BpelActivityEnum.WAIT.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.WAIT.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TThrow) {
            bpmActivity.setName(((TThrow)activity).getName());
            bpmActivity.setType(BpelActivityEnum.THROW.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.THROW.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TTerminate) {
            bpmActivity.setName(((TTerminate)activity).getName());
            bpmActivity.setType(BpelActivityEnum.TERMINATE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.TERMINATE.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TFlow) {
            bpmActivity.setName(((TFlow)activity).getName());
            bpmActivity.setType(BpelActivityEnum.FLOW.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.FLOW.isWsOperation() ? "Y" : "N");
            bpmActivity.setIsSplit("Y");
            bpmActivity.setHasParallelBranch("Y");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TActivityOrCompensateContainer) {
            TActivityOrCompensateContainer activityContainer = (TActivityOrCompensateContainer)activity;
            if (activity instanceof TCompensationHandler) {
                bpmActivity.setType(BpelActivityEnum.COMPENSATION_HANDLER.getName());
                bpmActivity.setIsWsOperation(BpelActivityEnum.COMPENSATION_HANDLER.isWsOperation() ? "Y" : "N");
                AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
            } else if (activity instanceof TCatch) {
                bpmActivity.setType(BpelActivityEnum.CATCH.getName());
                bpmActivity.setVariable(((TCatch)activity).getFaultVariable());
                bpmActivity.setIsWsOperation(BpelActivityEnum.CATCH.isWsOperation() ? "Y" : "N");
                AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
            } else {
                bpmActivity.setType(BpelActivityEnum.CATCH_ALL.getName());
                bpmActivity.setIsWsOperation(BpelActivityEnum.CATCH_ALL.isWsOperation() ? "Y" : "N");
                AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
            }
        } else if (activity instanceof TSwitch) {
            TSwitch switchActivity = (TSwitch)activity;
            bpmActivity.setName(switchActivity.getName());
            bpmActivity.setType(BpelActivityEnum.SWITCH.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.SWITCH.isWsOperation() ? "Y" : "N");
            bpmActivity.setIsSwitch("Y");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TSwitch.Case) {
            TSwitch.Case switchActivity = (TSwitch.Case)activity;
            bpmActivity.setCondition(switchActivity.getCondition());
            bpmActivity.setType(BpelActivityEnum.SWITCH_CASE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.SWITCH_CASE.isWsOperation() ? "Y" : "N");
            bpmActivity.setIsSwitch("Y");
            bpmActivity.setIsSwitchCase("Y");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TActivityContainer) {
            bpmActivity.setType(BpelActivityEnum.SWITCH_OTHER.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.SWITCH_OTHER.isWsOperation() ? "Y" : "N");
            bpmActivity.setIsSwitch("Y");
            bpmActivity.setIsSwitchOtherwise("Y");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TWhile) {
            bpmActivity.setName(((TWhile)activity).getName());
            bpmActivity.setType(BpelActivityEnum.WHILE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.WHILE.isWsOperation() ? "Y" : "N");
            bpmActivity.setCondition(((TWhile)activity).getCondition());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TSequence) {
            bpmActivity.setName(((TSequence)activity).getName());
            bpmActivity.setType(BpelActivityEnum.SEQUENCE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.SEQUENCE.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TPick) {
            TPick pick = (TPick)activity;
            bpmActivity.setName(pick.getName());
            bpmActivity.setType(BpelActivityEnum.PICK.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.PICK.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TScope) {
            TScope scope = (TScope)activity;
            bpmActivity.setName(scope.getName());
            bpmActivity.setType(BpelActivityEnum.SCOPE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.SCOPE.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TEventHandlers) {
            bpmActivity.setType(BpelActivityEnum.EVENT_HANDLERS.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.EVENT_HANDLERS.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TCorrelations) {
            bpmActivity.setType(BpelActivityEnum.CORRELATIONS.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.CORRELATIONS.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TCorrelation) {
            bpmActivity.setType(BpelActivityEnum.CORRELATION.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.CORRELATION.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TOnMessage) {
            TOnMessage onMessage = (TOnMessage)activity;
            bpmActivity.setType(BpelActivityEnum.ON_MESSAGE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.ON_MESSAGE.isWsOperation() ? "Y" : "N");
            bpmActivity.setOperation(onMessage.getOperation());
            bpmActivity.setPortType(onMessage.getPortType().toString());
            bpmActivity.setSourceCode(activity.xmlText());
            BpmProcessPartner processPartner = BpmActivityHandler.getProcessPartner(session, partnerList, onMessage.getPartnerLink());
            if (processPartner != null) {
                bpmActivity.setPartner(processPartner);
            }
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TOnAlarm) {
            TOnAlarm onAlarm = (TOnAlarm)activity;
            bpmActivity.setType(BpelActivityEnum.ON_ALARM.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.ON_ALARM.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TFaultHandlers) {
            bpmActivity.setType(BpelActivityEnum.FAULT_HANDLERS.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.FAULT_HANDLERS.isWsOperation() ? "Y" : "N");
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (activity instanceof TCompensate) {
            bpmActivity.setName(((TCompensate)activity).getName());
            bpmActivity.setType(BpelActivityEnum.COMPENSATE.getName());
            bpmActivity.setIsWsOperation(BpelActivityEnum.COMPENSATE.isWsOperation() ? "Y" : "N");
            bpmActivity.setSourceCode(activity.xmlText());
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"type ", (Object)bpmActivity.getType(), (Object)", name: ", (Object)bpmActivity.getName());
        } else if (bpmActivity != null) {
            AnalyticsLogger.debug(CLASSNAME, "createActivityNode", (Object)"unregister ", (Object)bpmActivity.getName());
            uow.unregisterObject((Object)bpmActivity);
            return null;
        }
        return bpmActivity;
    }

    public static BpmProcessPartner getProcessPartner(Session session, List<BpmProcessPartner> partnerList, String plName) {
        String methodName = "getProcessPartner";
        AnalyticsLogger.debug(CLASSNAME, "getProcessPartner", (Object)"Find ", (Object)plName);
        for (BpmProcessPartner processPartner : partnerList) {
            if (!processPartner.getName().equals(plName)) continue;
            return processPartner;
        }
        AnalyticsLogger.debug(CLASSNAME, "getProcessPartner", (Object)plName, (Object)" not found.");
        return null;
    }

    public static String getTextToken(XmlObject xmlObj) {
        XmlCursor cursor = xmlObj.newCursor();
        while (!cursor.toNextToken().isNone()) {
            if (cursor.currentTokenType() != XmlCursor.TokenType.TEXT) continue;
            String result = cursor.getTextValue();
            cursor.dispose();
            return result;
        }
        return "N/A";
    }

    public static String getNodeId(XmlObject xmlObj) {
        XmlCursor cursor = xmlObj.newCursor();
        boolean hasNext = cursor.toFirstAttribute();
        String result = null;
        while (hasNext) {
            if (cursor.getName().toString().equals("id")) {
                result = cursor.getTextValue();
                hasNext = false;
                continue;
            }
            hasNext = cursor.toNextAttribute();
        }
        cursor.dispose();
        return result;
    }
}

