/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.MeasurementCacheInitializationException;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.impl.Measure;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataService;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceRemote;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementActionCacheElement;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementCacheElement;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementMetadataCache;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.fabric.composite.model.ComponentModel;

@Stateless(name="MeasurementMetadataService", mappedName="BPMAnalytics")
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class MeasurementMetadataService
implements IMeasurementMetadataService,
IMeasurementMetadataServiceLocal,
IMeasurementMetadataServiceRemote {
    private List<TAction> actionList = null;
    private MeasurementMetadataCache metadataCache = null;
    private static final String logClassName = MeasurementMetadataService.class.getName();

    public MeasurementMetadataService() {
        String logMethodName = "MeasurementMetadataService Constructor ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"MeasurementMetadataService Constructor ", (String)"BEGIN:");
        try {
            this.metadataCache = MeasurementMetadataCache.getCacheInstance();
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "MeasurementMetadataService Constructor ");
            exCtx.setErrorCode(50101);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)ex);
            BPMException exBpm = new BPMException(exCtx);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "MeasurementMetadataService Constructor ");
            exCtx.setErrorCode(50101);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            BPMException exBpm = new BPMException(exCtx);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"MeasurementMetadataService Constructor ", (String)"END:");
    }

    @Override
    public IMeasure isElementRegistered(IAuditInstance auditInstance) {
        String logMethodName = "isElementRegisteredAI";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredAI", (String)"BEGIN:");
        IMeasure measure = null;
        IElementContext ctx = MeasurementUtil.getElementContext(auditInstance);
        measure = this.isElementRegistered(ctx);
        if (measure == null) {
            measure = new Measure();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredAI", (String)"END:");
        return measure;
    }

    @Override
    public IMeasure isElementRegistered(IElementContext context) {
        String logMethodName = "isElementRegisteredEC";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)"BEGIN:");
        Measure measure = new Measure();
        boolean measurementEnable = false;
        this.actionList = new ArrayList<TAction>();
        try {
            List<MeasurementCacheElement> measurement;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)this.getContextInformation(context).toString());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)MeasurementMetadataCache.getCacheInstance().printCacheData().toString());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)MeasurementMetadataCache.getCacheInstance().printActionCacheData().toString());
            boolean checkProcessLevel = true;
            boolean checkCompositeLevel = true;
            boolean checkActivityLevel = true;
            if (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_START_STOP.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_START.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_STOP.toString().equalsIgnoreCase(context.getElementState())) {
                checkActivityLevel = false;
                checkProcessLevel = false;
            }
            if (!measurementEnable && checkActivityLevel) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim() + context.getElementId().trim());
                if (measurement != null) {
                    checkProcessLevel = false;
                    checkCompositeLevel = false;
                }
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), true);
            }
            if (!measurementEnable && checkProcessLevel) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim());
                if (measurement != null) {
                    checkCompositeLevel = false;
                }
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), false);
            }
            if (!measurementEnable && checkCompositeLevel) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim());
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), false);
            }
            if (!measurementEnable && (AuditInstanceOperation.INSTANCE_ABORTED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_CREATED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_FAULT.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.STALE_COMPLETED.toString().equalsIgnoreCase(context.getElementState())) && (measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim() + "_DUMMY_TEMP_ACTIVITY_")) != null && measurement.size() > 0) {
                measurementEnable = true;
                for (MeasurementCacheElement cacheData : measurement) {
                    this.updateCacheList(context.getCompositeDN(), cacheData);
                }
            }
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "isElementRegisteredEC");
            exCtx.setErrorCode(50100);
            exCtx.setSeverity(Severity.ERRORS);
            BPMException exBpm = new BPMException(exCtx);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "isElementRegisteredEC");
            exCtx.setErrorCode(50103);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            BPMException exBpm = new BPMException(exCtx);
        }
        measure.setMeasurementEnabled(measurementEnable);
        ArrayList<TAction> tempActionList = new ArrayList<TAction>();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("ActionList size before clearing the data 1)" + this.actionList.size() + " 2)" + tempActionList.size()));
        if (this.actionList.size() <= 0) {
            measure.setMeasurementEnabled(false);
        } else {
            for (TAction action : this.actionList) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("Measurement Action==>" + action.getName()));
                tempActionList.add(action);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("ActionList size after clearing the data 1)" + this.actionList.size() + " 2)" + tempActionList.size()));
        measure.setActions(tempActionList);
        StringBuffer strBuffer = new StringBuffer("\n");
        strBuffer.append("****************** RESULT FOR IS ELEMENT REGISTER CALL  ********************");
        strBuffer.append("\n");
        strBuffer.append("Result : " + measure.isMeasurementEnabled());
        strBuffer.append("\n");
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)strBuffer.toString());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)"End:");
        return measure;
    }

    @Override
    public HashMap<IElementContext, IMeasure> areElementsRegistered(List<IElementContext> mContextList) {
        HashMap<IElementContext, IMeasure> measureMap = new HashMap<IElementContext, IMeasure>();
        for (IElementContext context : mContextList) {
            IMeasure measure = this.isElementRegistered(context);
            measureMap.put(context, measure);
        }
        return measureMap;
    }

    @Override
    public TAction getAction(IElementContext ctx, String actionName) {
        TAction action = null;
        String logMethodName = "getAction ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"BEGIN:");
        ArrayList<MeasurementCacheElement> measurementList = new ArrayList<MeasurementCacheElement>();
        try {
            List<MeasurementCacheElement> componentMeasurementList;
            List<MeasurementCacheElement> compositeMeasurementList = MeasurementMetadataCache.getCacheInstance().getMeasurement(ctx.getCompositeDN());
            if (compositeMeasurementList != null && compositeMeasurementList.size() > 0) {
                measurementList.addAll(compositeMeasurementList);
            }
            if ((componentMeasurementList = MeasurementMetadataCache.getCacheInstance().getMeasurement(ctx.getCompositeDN() + ctx.getComponentName())) != null && componentMeasurementList.size() > 0) {
                measurementList.addAll(componentMeasurementList);
            }
            if (measurementList.size() > 0) {
                for (MeasurementCacheElement mCacheData : measurementList) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)("Action key is:" + ctx.getCompositeDN() + mCacheData.getMeasurementElementName()));
                    List<MeasurementActionCacheElement> elemList = MeasurementMetadataCache.getCacheInstance().getAction(ctx.getCompositeDN() + mCacheData.getMeasurementElementName());
                    if (elemList != null) {
                        Iterator<MeasurementActionCacheElement> i$ = elemList.iterator();
                        if (i$.hasNext()) {
                            MeasurementActionCacheElement element = i$.next();
                            if (element.getActionName().equals(actionName)) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"Action exist for above key");
                            }
                            return element.getAction();
                        }
                        return action;
                    }
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)("Action does not exist for Key ===>" + ctx.getCompositeDN() + mCacheData.getMeasurementElementName() + actionName));
                }
            }
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)logClassName, (String)"getAction ", (String)("Cache instance creation exception:" + ex.getMessage()));
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)logClassName, (String)"getAction ", (String)("Exception in constructor: " + e.getMessage()));
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"END:");
        return action;
    }

    @Override
    public void load(ComponentModel componentModel) {
        String logMethodName = "load ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"load ", (String)"BEGIN:");
        try {
            MeasurementMetadataCache.getCacheInstance().addToCache(componentModel);
        }
        catch (MeasurementCacheInitializationException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"load ", (String)"END:");
    }

    @Override
    public void unload(ComponentModel componentModel) {
        String logMethodName = "unload ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"unload ", (String)"BEGIN: unload");
        try {
            MeasurementMetadataCache.getCacheInstance().removeFromCache(componentModel);
        }
        catch (MeasurementCacheInitializationException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"unload ", (String)"END:");
    }

    private boolean getMeasurementEnabled(List<MeasurementCacheElement> measurement, String compositeDN, String elementName, String elementType, String elementState, boolean activityLevel) {
        String logMethodName = "getMeasurementEnabled ";
        boolean measurementEnabled = false;
        if (measurement != null && measurement.size() > 0) {
            for (MeasurementCacheElement cacheData : measurement) {
                if (AuditInstanceOperation.INSTANCE_ABORTED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_CREATED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_FAULT.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.STALE_COMPLETED.toString().equalsIgnoreCase(elementState)) {
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                if (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_START_STOP.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_START.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_STOP.toString().equalsIgnoreCase(elementState)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)("User Defined Measurement with element Type=" + elementType + "and Element state==" + elementState));
                    if (!cacheData.getElementType().contains(elementType) && !cacheData.getElementType().contains("ALL") && !"ALL".equals(cacheData.getElementSelection()) || !cacheData.getElementState().contains(elementState)) continue;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)"Measurement Enabled");
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                if (!cacheData.getElementState().contains("ALL") && !cacheData.getElementState().contains(elementState) && !AuditInstanceOperation.STALE_ABORTED.toString().equalsIgnoreCase(elementState)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)" Element State Match found");
                if (!activityLevel) {
                    if (!cacheData.getElementType().contains("ALL") && !cacheData.getElementType().contains(elementType) && !"ALL".equals(cacheData.getElementSelection()) && (!BpmnType.USER_TASK.toString().toUpperCase().equals(elementName.toUpperCase()) || !"INTERACTIVE".equals(cacheData.getElementSelection()))) continue;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)"Element Type or Element Name match found.");
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                measurementEnabled = true;
                this.updateCacheList(compositeDN, cacheData);
            }
        }
        return measurementEnabled;
    }

    private void updateCacheList(String compositeDn, MeasurementCacheElement element) {
        try {
            List<MeasurementActionCacheElement> actionList1 = MeasurementMetadataCache.getCacheInstance().getAction(compositeDn + element.getMeasurementElementName());
            for (MeasurementActionCacheElement elem : actionList1) {
                if (!elem.getAction().isEnabled()) continue;
                this.actionList.add(elem.getAction());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCompositeDNWithoutLabel(String compositeDn) {
        int index = compositeDn.indexOf("*");
        if (index != -1) {
            return compositeDn.substring(0, index);
        }
        return compositeDn;
    }

    private StringBuffer getContextInformation(IElementContext context) {
        StringBuffer strBuffer = new StringBuffer("\n");
        strBuffer.append("*************************  Received Context is  ****************** ");
        strBuffer.append("\n");
        strBuffer.append("1. Composite DN is   == > " + context.getCompositeDN());
        strBuffer.append("\n");
        strBuffer.append("2. Element State is  == > " + context.getElementState());
        strBuffer.append("\n");
        strBuffer.append("3. Element Type is   == > " + context.getElementType());
        strBuffer.append("\n");
        strBuffer.append("4. Element Id is     == > " + context.getElementId());
        strBuffer.append("\n");
        strBuffer.append("5. Element Name is   == > " + context.getElementName());
        strBuffer.append("\n");
        strBuffer.append("6. Component Name is == > " + context.getComponentName());
        strBuffer.append("\n");
        strBuffer.append("*************************  MEASUREMENT CACHE DATA  ****************** ");
        strBuffer.append("\n");
        return strBuffer;
    }
}

