/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.impl.ElementContext;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;

public class MeasurementUtil {
    private static final String LOG_CLASS_NAME = "oracle.bpm.analytics.measurement.MeasurementUtil";

    public static IElementContext getElementContext(IAuditInstance ai) {
        ElementContext c = new ElementContext();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Composite DN: " + ai.getCompositeDn()));
        c.setCompositeDN(ai.getCompositeDn());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Component Name: " + ai.getComponentName()));
        c.setComponentName(ai.getComponentName());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Name(=> ElementSelection): " + ai.getActivityName()));
        c.setElementName(ai.getActivityName());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element State: " + ai.getOperation().toString()));
        c.setElementState(ai.getOperation().toString());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Type: " + ai.getAuditInstanceType()));
        c.setElementType(ai.getAuditInstanceType());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Id: " + ai.getActivityId()));
        c.setElementId(ai.getActivityId());
        return c;
    }

    public static IElementContext getElementContext(String compositeDN, String componentName, String activityName, String operation, String auditInstanceType, String activityId) {
        ElementContext c = new ElementContext();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Composite DN: " + compositeDN));
        c.setCompositeDN(compositeDN);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Component Name: " + componentName));
        c.setComponentName(componentName);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Name(=> ElementSelection): " + activityName));
        c.setElementName(activityName);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element State: " + operation));
        c.setElementState(operation);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Type: " + auditInstanceType));
        c.setElementType(auditInstanceType);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"getElementContext", (String)(" Element Id: " + activityId));
        c.setElementId(activityId);
        return c;
    }

    public static List<TAction> getEnabledActionsList(IMeasure measure, String delimitedDisabledActionsList) {
        List<TAction> origActionsList = measure.getActions();
        ArrayList<TAction> modActionsList = new ArrayList<TAction>();
        if (delimitedDisabledActionsList != null && delimitedDisabledActionsList.length() > 0 && origActionsList.size() > 0) {
            for (TAction action : origActionsList) {
                if (delimitedDisabledActionsList.contains(action.getName())) continue;
                modActionsList.add(action);
            }
        } else {
            return origActionsList;
        }
        return modActionsList;
    }
}

