/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.parser.wsdl.OperationType;
import oracle.bpm.project.interfaces.ProcessOperationWrapper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessOperationWrapperImpl
implements ProcessOperationWrapper {
    private ConversationEnabled conversationEnabled;
    private DataAssociationSet dataAssociationSet;
    private FlowNode flowNode;
    private boolean isReference;
    private boolean isTwoWay;

    public ProcessOperationWrapperImpl(@NotNull FlowNode flowNode) {
        if (flowNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.<init> must not be null");
        }
        this.flowNode = flowNode;
        this.init();
    }

    @Override
    public boolean hasErrors() {
        boolean ret = false;
        if (this.flowNode.isEvent()) {
            Event event = (Event)this.flowNode;
            EventDefinition eventDefinition = event.getEventDefinition();
            assert (eventDefinition != null);
            MessageEventDefinition definition = eventDefinition.as(MessageEventDefinition.class);
            ret = definition.returnsErrors();
        }
        return ret;
    }

    @Override
    public ErrorObject getError() {
        ErrorObject ret = null;
        if (this.hasErrors()) {
            Event event = (Event)this.flowNode;
            EventDefinition eventDefinition = event.getEventDefinition();
            assert (eventDefinition != null);
            MessageEventDefinition definition = eventDefinition.as(MessageEventDefinition.class);
            ErrorEventDefinition errorEventDefinition = definition.getErrorEventDefinition();
            assert (errorEventDefinition != null);
            ret = errorEventDefinition.getError();
        }
        return ret;
    }

    @Override
    public DataAssociationSet getDataAssociationSet() {
        return this.dataAssociationSet;
    }

    @Override
    public boolean isSync() {
        boolean isSync;
        if (this.isServiceDefiner()) {
            isSync = this.isInitiator() ? this.conversationEnabled.isSync() : this.getConversationInitiator().isSync();
        } else if (this.getConversationEnabled().getAssociatedProcess() != null) {
            ConversationEnabled enabled = this.getConversationEnabled().getAssociatedNode();
            assert (enabled != null);
            ConversationEnabled conversationInitiator = enabled.getConversationInitiator();
            isSync = conversationInitiator == null ? enabled.isSync() : conversationInitiator.isSync();
        } else {
            ConversationEnabled conversation = this.conversationEnabled.getConversationInitiator();
            if (conversation != null) {
                XObjectTypeDescription bpmObject = this.getBpmObject(conversation);
                ServiceObject serviceObject = bpmObject.asServiceObject();
                isSync = serviceObject.isSynchronous();
            } else {
                isSync = false;
            }
        }
        return isSync;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public boolean isInitiator() {
        return this.conversationEnabled.getConversationInitiator() == null;
    }

    @Override
    public String getDefinedOperationName() {
        return this.conversationEnabled.getDefinedOperationName();
    }

    @Override
    public String findArgumentPartName(String argumentName) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getName() {
        String result;
        if (this.isReference()) {
            result = this.getExternalOperationName();
        } else if (this.isServiceDefiner()) {
            result = this.getDefinedOperationName();
            if (this.isSync() && !this.isInitiator()) {
                result = this.getConversationInitiator().getDefinedOperationName();
            }
        } else {
            result = this.getExternalOperationName();
        }
        return result;
    }

    @Override
    public boolean isServiceDefiner() {
        boolean useIpc = this.conversationEnabled.getAssociatedProcess() != null && this.conversationEnabled.getAssociatedNode() != null;
        boolean isDefined = this.conversationEnabled.getDefinedOperationName() != null || this.conversationEnabled.getAssociatedError() != null && this.conversationEnabled.getConversationInitiator().getDefinedOperationName() != null;
        return !this.isReference() && !useIpc && isDefined;
    }

    @Override
    public ConversationEnabled getConversationEnabled() {
        return this.conversationEnabled;
    }

    @Override
    public ServiceObject getServiceObject() {
        CatalogObject catalogObject = this.conversationEnabled.getParticipant();
        ServiceObject serviceObject = null;
        if (catalogObject != null) {
            ObjectTypeDescription typeDescription = catalogObject.getObjectType();
            serviceObject = typeDescription.asServiceObject();
        }
        return serviceObject;
    }

    @Override
    public CatalogMember getOperation() {
        return this.conversationEnabled.getOperation();
    }

    @Override
    public QName getInputType() {
        QName result;
        if (this.isServiceDefiner()) {
            String namespace = this.conversationEnabled.getProcess().getNamespace();
            String messageSuffix = this.isInitiator() ? "" : "Response";
            result = new QName(namespace, this.getName() + messageSuffix);
        } else {
            result = this.getExternalMessage(ArgumentType.INPUT);
        }
        return result;
    }

    @Override
    public QName getOutputType() {
        QName result = null;
        if (this.isTwoWay()) {
            if (this.isServiceDefiner()) {
                String namespace = this.conversationEnabled.getProcess().getNamespace();
                result = new QName(namespace, this.getName() + "Response");
            } else {
                result = this.getExternalMessage(ArgumentType.OUTPUT);
            }
        }
        return result;
    }

    @Override
    public QName getFaultCodeError() {
        QName qName = null;
        if (this.hasErrors()) {
            qName = this.isServiceDefiner() ? new QName(this.flowNode.getProcess().getNamespace(), this.getError().getName()) : this.getError().getErrorCode();
        }
        return qName;
    }

    @Override
    public QName getFaultMessageType() {
        QName qName = null;
        if (this.hasErrors()) {
            qName = this.isServiceDefiner() ? new QName(this.flowNode.getProcess().getNamespace(), this.getError().getName()) : this.getError().getMessageQName();
        }
        return qName;
    }

    @Override
    public boolean allowsWrappedArguments() {
        return this.isServiceDefiner() || this.getConversationEnabled().getAssociatedProcess() != null;
    }

    @Override
    public boolean isTwoWay() {
        return this.isTwoWay;
    }

    @Override
    public QName getPortType() {
        QName result;
        if (this.isServiceDefiner()) {
            Process process = this.conversationEnabled.getProcess();
            String namespace = process.getNamespace();
            String localPart = process.getId() + "PortType";
            if (!this.isInitiator()) {
                localPart = localPart + "CallBack";
            }
            result = new QName(namespace, localPart);
        } else {
            ConversationEnabled initator = this.getConversationInitiator();
            if (initator.getParticipant() != null) {
                ConversationEnabled conversation = this.conversationEnabled;
                WsdlTypeDescription wsdlTypeDescription = this.getServiceTypeDescription(conversation);
                String namespace = wsdlTypeDescription.getNamespace();
                String localPart = wsdlTypeDescription.getNativeName();
                result = new QName(namespace, localPart);
            } else if (this.conversationEnabled.getAssociatedProcess() != null) {
                ProcessOperationWrapperImpl wrapper = new ProcessOperationWrapperImpl(this.conversationEnabled.getAssociatedNode());
                result = wrapper.getPortType();
            } else {
                throw new IllegalArgumentException("Conversation is wrong. There are not operation/process or external services defined");
            }
        }
        return result;
    }

    @Override
    @Nullable
    public MethodTypeDescription getOperationTypeDescription(@NotNull ConversationEnabled conversation) {
        MethodTypeDescription result;
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.getOperationTypeDescription must not be null");
        }
        CatalogMember operation = conversation.getOperation();
        if (operation != null) {
            MethodTypeDescription method = operation.getMemberType();
            if (method.isDelegated()) {
                DelegatedMethodTypeDescription delegatedMethod = method.asDelegated();
                String signature = delegatedMethod.getDelegatedMethodSignature();
                TypeRef service = delegatedMethod.getDelegatedService();
                TypeDescription typeDescription = service.get();
                WsdlTypeDescription wsdlTypeDescription = (WsdlTypeDescription)typeDescription.asObject();
                result = wsdlTypeDescription.findMethod(signature);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public WsdlTypeDescription getServiceTypeDescription(@NotNull ConversationEnabled conversation) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.getServiceTypeDescription must not be null");
        }
        CatalogMember operation = conversation.getOperation();
        MethodTypeDescription method = operation.getMemberType();
        if (!(method instanceof DelegatedMethodTypeDescription)) {
            throw new IllegalArgumentException("Only Delegated methods can be used in tasks. \nOperation: " + operation.getName() + " Method: " + method.getName());
        }
        DelegatedMethodTypeDescription delegatedMethod = (DelegatedMethodTypeDescription)method;
        TypeRef service = delegatedMethod.getDelegatedService();
        TypeDescription typeDescription = service.get();
        WsdlTypeDescription result = (WsdlTypeDescription)typeDescription.asObject();
        return result;
    }

    public String toString() {
        return "ProcessOperationWrapperImpl{conversationEnabled=" + this.conversationEnabled + ", dataAssociationSet=" + this.dataAssociationSet + ", isReference=" + this.isReference + '}';
    }

    @Override
    public ConversationEnabled getConversationInitiator() {
        return this.conversationEnabled.getConversationInitiator() != null ? this.conversationEnabled.getConversationInitiator() : this.conversationEnabled;
    }

    private static boolean hasContinuators(@NotNull ConversationEnabled initiator) {
        if (initiator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.hasContinuators must not be null");
        }
        boolean result = false;
        Sequence<FlowNode> flowNodes = initiator.getProcess().getDescendants(FlowNode.class);
        for (FlowNode flowNode : flowNodes) {
            if (!flowNode.isConversationMember() || flowNode.getBpmnType() == BpmnType.SERVICE_TASK) continue;
            ConversationEnabled conversationEnabled = (ConversationEnabled)flowNode;
            ConversationEnabled conversationInitiator = conversationEnabled.getConversationInitiator();
            if (conversationEnabled.isConversationInitiator() || conversationInitiator == null || !conversationInitiator.getId().equals(initiator.getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isTwoWayInternal() {
        boolean result;
        if (this.isServiceDefiner()) {
            result = this.isConversationEnableTwoWay(this.conversationEnabled);
        } else if (this.conversationEnabled.getAssociatedProcess() != null && this.conversationEnabled.getAssociatedNode() != null) {
            ConversationEnabled associatedNode = this.conversationEnabled.getAssociatedNode();
            result = this.isConversationEnableTwoWay(associatedNode);
        } else {
            ConversationEnabled initiator = this.getConversationInitiator();
            if (initiator.getParticipant() != null) {
                MethodTypeDescription methodTypeDescription = this.getOperationTypeDescription(initiator);
                if (methodTypeDescription != null) {
                    String strmep = methodTypeDescription.getProperty("mep");
                    OperationType mep = OperationType.valueOf(strmep);
                    result = mep != OperationType.ONE_WAY;
                } else {
                    result = false;
                    Log.logWarning((Msg)Msg.QUOTE((String)"cannot decide whether operation is two-way or not"));
                }
            } else {
                result = false;
                Log.logWarning((Msg)Msg.QUOTE((String)"cannot decide whether operation is two-way or not"));
            }
        }
        return result;
    }

    private boolean isConversationEnableTwoWay(@NotNull ConversationEnabled conversationEnabled) {
        ConversationEnabled initiator;
        if (conversationEnabled == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.isConversationEnableTwoWay must not be null");
        }
        boolean result = !conversationEnabled.isConversationInitiator() ? (initiator = conversationEnabled.getConversationInitiator()) != null && initiator.isSync() : conversationEnabled.isSync() && ProcessOperationWrapperImpl.hasContinuators(conversationEnabled);
        return result;
    }

    private void init() {
        if (this.flowNode.isConversationMember()) {
            this.conversationEnabled = (ConversationEnabled)this.flowNode;
            this.isTwoWay = this.isTwoWayInternal();
            ConversationEnabled initiator = this.conversationEnabled.getConversationInitiator();
            if (this.flowNode.isEvent()) {
                Event event = (Event)this.flowNode;
                if (event.isCatchEvent()) {
                    this.isReference = initiator != null && (initiator.getParticipant() != null || initiator.getAssociatedProcess() != null);
                    this.dataAssociationSet = ((CatchEvent)event).getOutputDataAssociationSet();
                } else if (event.isThrowEvent()) {
                    this.isReference = initiator == null;
                    this.dataAssociationSet = ((ThrowEvent)event).getInputDataAssociationSet();
                }
            } else if (this.flowNode.isActivity()) {
                Activity activity = (Activity)this.flowNode;
                if (activity.isSendTask()) {
                    this.isReference = initiator == null;
                    this.dataAssociationSet = ((SendTask)activity).getInputDataAssociationSet();
                } else if (activity.isReceiveTask()) {
                    this.isReference = initiator != null && (initiator.getParticipant() != null || initiator.getAssociatedProcess() != null);
                    this.dataAssociationSet = ((ReceiveTask)activity).getOutputDataAssociationSet();
                } else if (activity.isServiceTask()) {
                    this.isReference = true;
                    this.dataAssociationSet = ((ServiceTask)activity).getOutputDataAssociationSet();
                }
            }
        }
    }

    private XObjectTypeDescription getBpmObject(@NotNull ConversationEnabled conversationInitiator) {
        if (conversationInitiator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.getBpmObject must not be null");
        }
        CatalogMember operation = conversationInitiator.getOperation();
        MethodTypeDescription method = operation.getMemberType();
        if (!(method instanceof DelegatedMethodTypeDescription)) {
            throw new IllegalArgumentException("Only Delegated methods can be used in tasks. \nOperation: " + operation.getName() + " Method: " + method.getName());
        }
        XObjectTypeDescription result = (XObjectTypeDescription)method.getParent();
        return result;
    }

    private String getExternalOperationName() {
        String ret;
        ConversationEnabled initiator = this.conversationEnabled;
        if (initiator.getParticipant() != null) {
            MethodTypeDescription operationTypeDescription = this.getOperationTypeDescription(initiator);
            ret = operationTypeDescription == null ? null : operationTypeDescription.getNativeName();
        } else {
            ConversationEnabled enabled = this.conversationEnabled.getAssociatedNode();
            if (enabled != null) {
                ProcessOperationWrapperImpl wrapper = new ProcessOperationWrapperImpl(enabled);
                ret = wrapper.getName();
            } else {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QName getExternalMessage(@NotNull ArgumentType argumentType) {
        if (argumentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessOperationWrapperImpl.getExternalMessage must not be null");
        }
        QName result = null;
        ConversationEnabled initiator = this.getConversationInitiator();
        if (initiator.getParticipant() != null) {
            MethodTypeDescription methodTypeDescription = this.getOperationTypeDescription(initiator);
            if (methodTypeDescription == null) throw new IllegalArgumentException("Conversation is not properly defined. There are not operation/process or external services defined");
            String strmep = methodTypeDescription.getProperty("mep");
            OperationType mep = OperationType.valueOf(strmep);
            if (mep == OperationType.ONE_WAY) {
                if (argumentType == ArgumentType.OUTPUT) return result;
            }
            String namespace = methodTypeDescription.getProperty(argumentType.getMessageNamespace());
            String localPart = methodTypeDescription.getProperty(argumentType.getMessageName());
            return new QName(namespace, localPart);
        }
        if (this.conversationEnabled.getAssociatedProcess() == null) throw new IllegalArgumentException("Conversation is not properly defined. There are not operation/process or external services defined");
        ProcessOperationWrapperImpl wrapper = new ProcessOperationWrapperImpl(this.conversationEnabled.getAssociatedNode());
        return wrapper.getInputType();
    }

    private static enum ArgumentType {
        INPUT{

            @Override
            public String getMessageNamespace() {
                return "inputMessageNamespace";
            }

            @Override
            public String getMessageName() {
                return "inputMessage";
            }
        }
        ,
        OUTPUT{

            @Override
            public String getMessageNamespace() {
                return "outputMessageNamespace";
            }

            @Override
            public String getMessageName() {
                return "outputMessage";
            }
        };


        public abstract String getMessageNamespace();

        public abstract String getMessageName();
    }
}

