/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeException;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Binding;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.Part;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.CData;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.parser.xsd.Sequence;
import oracle.bpm.project.catalog.type.AbstractBpmoTypeWriter;
import oracle.bpm.project.catalog.type.BpmObjectSchemaHelper;
import oracle.bpm.project.catalog.type.BpmoWriterContext;
import oracle.bpm.project.catalog.type.ElementBuilder;
import oracle.bpm.project.catalog.type.parser.BpmoBinding;
import oracle.bpm.project.catalog.type.parser.BpmoDelegate;
import oracle.bpm.project.catalog.type.parser.BpmoOperation;
import oracle.bpm.project.catalog.type.parser.BpmoProperties;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsdlTypeWriter
extends AbstractBpmoTypeWriter {
    private final boolean service;
    private final Set<oracle.bpm.project.catalog.parser.xsd.Import> wsdlSchemaImports;
    private final XmlUUID xmlUUID;
    public static final String OVERLOAD_SEPARATOR = "-";
    private static final String DEFAULT_SCHEMA_PREFIX = "xsd";
    public static final String CURRENT_NS_PREFIX = "tns";
    public static final String BPMO_SCHEMA_PREFIX = "oj";
    public static final String SETTER_PREFIX_SET = "set";
    public static final String GETTER_PREFIX_GET = "get";
    public static final String GETTER_PREFIX_IS = "is";

    public WsdlTypeWriter(@NotNull XObjectTypeDescription xotd, @NotNull VFile wsdlFile, @NotNull BpmoWriterContext context) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.<init> must not be null");
        }
        if (wsdlFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.<init> must not be null");
        }
        super(xotd, wsdlFile, context);
        this.wsdlSchemaImports = new HashSet<oracle.bpm.project.catalog.parser.xsd.Import>();
        this.rootContext.addNamespace(DEFAULT_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        this.targetNamespace = WsdlTypeWriter.makeWsdlNamespace((TypeDescription)xotd);
        this.rootContext.addNamespace(CURRENT_NS_PREFIX, this.targetNamespace);
        this.rootContext.addNamespace("", "http://schemas.xmlsoap.org/wsdl/");
        this.xmlUUID = UUIDFactory.parseXmlId((String)TypeUtils.getAttributesObjectId((ObjectTypeDescription)xotd));
        this.rootContext.addNamespace(BPMO_SCHEMA_PREFIX, this.xmlUUID.getNamespace());
        this.elementBuilder = new ElementBuilder(this.getXmlSchemaPrefix(), context);
        this.service = TypeUtils.isService((TypeRef)xotd);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String makeWsdlNamespace(TypeDescription xotd) {
        String string = "http://xmlns.oracle.com/bpm/bpmobject/" + xotd.getText().replace('.', '/') + ".Interface";
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/WsdlTypeWriter.makeWsdlNamespace must not return null");
        }
        return string;
    }

    public static String makePortTypeName(TypeDescription type) {
        return type.getName() + "PortType";
    }

    @Override
    DefaultElement build() throws TypeCatalogException {
        DefaultElement serviceDefinition = this.buildServiceDefinition();
        DefaultElement doc = WsdlTypeWriter.buildDocumentation((TypeDescription)this.xotd, serviceDefinition.getNSContext());
        if (doc.hasChilds()) {
            serviceDefinition.insertFirstChild(doc);
        }
        Map<String, WsdlOperationElement> operationsElements = this.loadOperations(this.xotd);
        Binding binding = this.buildBinding(this.rootContext, this.xotd, operationsElements);
        DefaultElement portType = this.buildPortType(this.rootContext, this.xotd, operationsElements);
        List<DefaultElement> messages = this.buildMessages(this.rootContext, operationsElements, CURRENT_NS_PREFIX);
        Binding callbackBinding = null;
        DefaultElement callbackPortType = null;
        List<DefaultElement> callbackMessages = null;
        XObjectTypeDescription callbackOtd = null;
        Map<String, WsdlOperationElement> callbackOperationsElements = null;
        if (this.xotd.hasInnerTypes()) {
            callbackOtd = (XObjectTypeDescription)this.xotd.getInnerType(0);
            callbackOperationsElements = this.loadOperations(callbackOtd);
            String callbackNamespace = WsdlTypeWriter.makeWsdlNamespace((TypeDescription)callbackOtd);
            String prefix = "cbck";
            this.rootContext.addNamespace("cbck", callbackNamespace);
            callbackBinding = this.buildBinding(this.rootContext, callbackOtd, callbackOperationsElements);
            callbackPortType = this.buildPortType(this.rootContext, callbackOtd, callbackOperationsElements);
            callbackMessages = this.buildMessages(this.rootContext, callbackOperationsElements, "cbck");
        }
        DefaultElement types = this.buildTypes(this.rootContext, this.xotd, operationsElements, callbackOtd, callbackOperationsElements);
        for (Import anImport : this.elementBuilder.getWsdlImports()) {
            anImport.setNSContext(new NamespaceContext(serviceDefinition.getNSContext()));
            serviceDefinition.addChild(anImport);
        }
        serviceDefinition.addChild(types);
        for (DefaultElement message : messages) {
            serviceDefinition.addChild(message);
        }
        if (callbackMessages != null) {
            for (DefaultElement message : callbackMessages) {
                serviceDefinition.addChild(message);
            }
        }
        serviceDefinition.addChild(portType);
        if (callbackPortType != null) {
            serviceDefinition.addChild(callbackPortType);
        }
        serviceDefinition.addChild(binding);
        if (callbackBinding != null) {
            serviceDefinition.addChild(callbackBinding);
        }
        return serviceDefinition;
    }

    @Override
    String getXmlSchemaPrefix() {
        return DEFAULT_SCHEMA_PREFIX;
    }

    private Binding buildBinding(NamespaceContext parentContext, XObjectTypeDescription bpmObject, Map<String, WsdlOperationElement> operationElements) {
        BpmoBinding bpmoBinding;
        Binding binding = WsdlElementFactory.createBinding(this.getBindingName(bpmObject), "tns:" + WsdlTypeWriter.makePortTypeName((TypeDescription)bpmObject), parentContext);
        NamespaceContext bindingContext = binding.getNSContext();
        XmlUUID xmlId = UUIDFactory.parseXmlId((String)TypeUtils.getAttributesObjectId((ObjectTypeDescription)bpmObject));
        if (xmlId.getElemType() == XmlElementType.ELEMENT) {
            String element = "oj:" + xmlId.getNativeName();
            bpmoBinding = WsdlElementFactory.createBpmoBindingWithElement(element, bindingContext);
        } else {
            String type = "oj:" + xmlId.getNativeName();
            bpmoBinding = WsdlElementFactory.createBpmoBindingWithType(type, bindingContext);
        }
        BpmoProperties bpmoProperties = WsdlElementFactory.createBpmoProperties(bpmObject.getProperties(), bindingContext);
        if (bpmoProperties.hasChilds()) {
            bpmoBinding.addChild(bpmoProperties);
        }
        bpmoBinding.setModifiers(bpmObject.getModifiers());
        binding.addChild(bpmoBinding);
        for (WsdlOperationElement operationElement : operationElements.values()) {
            binding.addChild(operationElement.buildBindingOperation(bindingContext));
        }
        return binding;
    }

    private List<DefaultElement> buildMessages(NamespaceContext parentContext, Map<String, WsdlOperationElement> operationElements, String prefix) {
        ArrayList<DefaultElement> result = new ArrayList<DefaultElement>();
        for (WsdlOperationElement operationElement : operationElements.values()) {
            result.addAll(operationElement.buildMessages(parentContext, prefix));
        }
        return result;
    }

    private DefaultElement buildPortType(NamespaceContext parentContext, XObjectTypeDescription xotd, Map<String, WsdlOperationElement> operationElements) {
        DefaultElement portType = WsdlElementFactory.createPortType(WsdlTypeWriter.makePortTypeName((TypeDescription)xotd), parentContext);
        for (WsdlOperationElement operationElement : operationElements.values()) {
            portType.addChild(operationElement.buildPortTypeOperation(portType.getNSContext()));
        }
        return portType;
    }

    private DefaultElement buildTypes(NamespaceContext parentContext, @NotNull XObjectTypeDescription xotd, @NotNull Map<String, WsdlOperationElement> operationElements, @Nullable XObjectTypeDescription callbackOtd, @Nullable Map<String, WsdlOperationElement> callbackOperationsElements) throws TypeCatalogException {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.buildTypes must not be null");
        }
        if (operationElements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.buildTypes must not be null");
        }
        DefaultElement types = WsdlElementFactory.createTypes(parentContext);
        NamespaceContext typesContext = types.getNSContext();
        Schema schema = this.createSchema(xotd, operationElements, typesContext);
        Schema callbackSchema = null;
        if (callbackOtd != null && callbackOperationsElements != null) {
            callbackSchema = this.createSchema(callbackOtd, callbackOperationsElements, typesContext);
        }
        for (oracle.bpm.project.catalog.parser.xsd.Import anImport : this.wsdlSchemaImports) {
            Schema schemaImport = SchemaElementFactory.createSchema();
            schemaImport.setNSContext(new NamespaceContext(typesContext));
            types.addChild(schemaImport);
            anImport.setNSContext(new NamespaceContext(schemaImport.getNSContext()));
            schemaImport.addChild(anImport);
        }
        if (schema.hasChilds()) {
            types.addChild(schema);
        }
        if (callbackSchema != null && callbackSchema.hasChilds()) {
            types.addChild(callbackSchema);
        }
        return types;
    }

    private Schema createSchema(XObjectTypeDescription xotd, Map<String, WsdlOperationElement> operationElements, NamespaceContext typesContext) throws TypeCatalogException {
        boolean wsdlInlineObject;
        String schemaLocation;
        String currentNamespace = WsdlTypeWriter.makeWsdlNamespace((TypeDescription)xotd);
        Schema schema = SchemaElementFactory.createSchema(currentNamespace);
        NamespaceContext schemaContext = new NamespaceContext(typesContext);
        schemaContext.addNamespace("", WsdlTypeWriter.makeWsdlNamespace((TypeDescription)xotd));
        schema.setNSContext(schemaContext);
        ArrayList<DefaultElement> elements = new ArrayList<DefaultElement>();
        String typeSchemaNamespace = this.xmlUUID.getNamespace();
        schemaContext.addNamespace(BPMO_SCHEMA_PREFIX, typeSchemaNamespace);
        Object property = xotd.getTransientProperty("external.schema.url");
        if (property != null) {
            schemaLocation = property.toString();
            wsdlInlineObject = (Boolean)xotd.getTransientProperty("wsdl.inline.object");
        } else {
            XmlTypeDescription xmlotd = BpmObjectSchemaHelper.findSchemaForBpmObject(xotd);
            schemaLocation = xmlotd.getLocation();
            wsdlInlineObject = xmlotd.isWsdlInlineObject();
        }
        String thisLocation = URLHelper.buildRelativeLocation((String)this.getContext().getWsdlLocation(), (String)schemaLocation);
        if (!wsdlInlineObject) {
            oracle.bpm.project.catalog.parser.xsd.Import thisTypeImport = SchemaElementFactory.createImport(typeSchemaNamespace, thisLocation);
            this.wsdlSchemaImports.add(thisTypeImport);
            if (xotd.hasConstructors()) {
                thisTypeImport = SchemaElementFactory.createImport(typeSchemaNamespace, thisLocation);
                thisTypeImport.setNSContext(new NamespaceContext(schemaContext));
                this.elementBuilder.addSchemaImport(thisTypeImport);
            }
        } else {
            Import wsdlImport = WsdlElementFactory.createImport(typeSchemaNamespace, thisLocation, null);
            this.elementBuilder.addWsdlImport(wsdlImport);
        }
        for (WsdlOperationElement operationElement : operationElements.values()) {
            elements.addAll(operationElement.buildTypeElements(schemaContext));
        }
        for (oracle.bpm.project.catalog.parser.xsd.Import anImport : this.elementBuilder.getSchemaImports()) {
            anImport.setNSContext(new NamespaceContext(schemaContext));
            schema.addChild(anImport);
        }
        this.elementBuilder.clearSchemaImports();
        for (DefaultElement element : elements) {
            schema.addChild(element);
        }
        return schema;
    }

    private Map<String, WsdlOperationElement> loadOperations(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.loadOperations must not be null");
        }
        assert (xotd.getSuperTypes().size() <= 1) : "Inheritance/Delegation not supported yet";
        Hashtable<String, WsdlOperationElement> operationsElements = new Hashtable<String, WsdlOperationElement>();
        for (MethodTypeDescription mtd : xotd.getMethods()) {
            if (mtd.isDelegated()) {
                DelegatedMethod elem = new DelegatedMethod(mtd.asDelegated());
                operationsElements.put(elem.getOperationName(), elem);
                continue;
            }
            int overloadedNumber = 0;
            do {
                Method elem = new Method(mtd, overloadedNumber);
                operationsElements.put(elem.getOperationName(), elem);
                mtd = mtd.getNextMethod();
                ++overloadedNumber;
            } while (mtd != null);
        }
        if (Utils.isBpmObjectNamespace(this.xmlUUID.getNamespace())) {
            XmlTypeDescription xmlotd = BpmObjectSchemaHelper.findSchemaForBpmObject(xotd);
            for (MethodTypeDescription mtd : xmlotd.getAttributes()) {
                BeanMethod elem;
                AttributeTypeDescription atd = mtd.asAttribute();
                if (atd.getCode() != null) {
                    elem = new Getter(atd);
                    operationsElements.put(elem.getOperationName(), elem);
                }
                if (atd.getWriteCode() == null) continue;
                elem = new Setter(atd);
                operationsElements.put(elem.getOperationName(), elem);
            }
        }
        return operationsElements;
    }

    private DefaultElement buildServiceDefinition() {
        DefaultElement definitions = WsdlElementFactory.createDefinitions(this.targetNamespace, this.xotd.getName());
        definitions.setNSContext(this.rootContext);
        return definitions;
    }

    private String getBindingName(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter.getBindingName must not be null");
        }
        return WsdlTypeWriter.makePortTypeName((TypeDescription)xotd) + "Binding";
    }

    private class Setter
    extends BeanMethod {
        private Setter(AttributeTypeDescription atd) {
            super(atd);
        }

        @Override
        String buildOperationName() {
            return WsdlTypeWriter.SETTER_PREFIX_SET + this.formatName(this.mtd.getName());
        }

        @Override
        List<ElementDef> buildSequenceRequestElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            result.add(this.buildThisElement(sequenceContext, schemaContext));
            Argument valueArg = new Argument("value", (TypeRef)this.atd.getType(), 0L);
            ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(valueArg, sequenceContext, schemaContext, false);
            if (elem == null) {
                throw new IllegalArgumentException("Unsupported type: '" + this.atd.getType() + "'");
            }
            result.add(elem);
            return result;
        }

        @Override
        List<ElementDef> buildSequenceResponseElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            result.add(this.buildThisElement(sequenceContext, schemaContext));
            return result;
        }

        @Override
        SourceCode getCode() {
            return this.atd.getWriteCode();
        }
    }

    private class Method
    extends WsdlOperationElement {
        private Boolean needsInput;
        private Boolean needsOutput;
        private final int overloadedNumber;

        private Method(MethodTypeDescription mtd, int overloadedNumber) {
            super(mtd);
            this.overloadedNumber = overloadedNumber;
        }

        @Override
        public boolean needsInput() {
            MethodTypeDescription rmtd = this.getMethod();
            if (this.needsInput == null) {
                this.needsInput = !this.mtd.isStatic() || this.hasInput(rmtd);
            }
            return this.needsInput;
        }

        @Override
        public boolean needsOutput() {
            MethodTypeDescription rmtd = this.getMethod();
            if (this.needsOutput == null) {
                this.needsOutput = !this.mtd.isStatic() || this.hasOutput(rmtd);
            }
            return this.needsOutput;
        }

        MethodTypeDescription getMethod() {
            return this.mtd;
        }

        boolean hasInput(MethodTypeDescription mtd) {
            return mtd.getInputArgumentCount() > 0;
        }

        boolean hasOutput(MethodTypeDescription mtd) {
            for (Argument argument : mtd.getArguments()) {
                if (!argument.isOut()) continue;
                return true;
            }
            return !mtd.getResultType().isVoid();
        }

        @Override
        String buildOperationName() {
            return this.overloadedNumber > 0 ? this.mtd.getName() + WsdlTypeWriter.OVERLOAD_SEPARATOR + this.overloadedNumber : this.mtd.getName();
        }

        @Override
        List<ElementDef> buildSequenceRequestElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            if (!this.mtd.isStatic()) {
                result.add(this.buildThisElement(sequenceContext, schemaContext));
            }
            for (Argument argument : this.mtd.getArguments()) {
                if (!argument.isIn()) continue;
                ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(argument, sequenceContext, schemaContext, WsdlTypeWriter.this.service);
                if (elem != null) {
                    result.add(elem);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type: '" + argument.getType() + "'");
            }
            return result;
        }

        @Override
        List<ElementDef> buildSequenceResponseElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            Argument resultArgument = this.mtd.getResultArgument();
            TypeDescription resultType = resultArgument.getType();
            if (!resultType.isVoid()) {
                ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(resultArgument, sequenceContext, schemaContext, WsdlTypeWriter.this.service);
                if (elem != null) {
                    result.add(elem);
                } else {
                    throw new IllegalArgumentException("Unsupported type: '" + this.mtd.getResultType() + "'");
                }
            }
            for (Argument argument : this.mtd.getArguments()) {
                if (!argument.isOut()) continue;
                ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(argument, sequenceContext, schemaContext, WsdlTypeWriter.this.service);
                if (elem != null) {
                    result.add(elem);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type: '" + argument.getType() + "'");
            }
            if (!this.mtd.isStatic()) {
                result.add(this.buildThisElement(sequenceContext, schemaContext));
            }
            return result;
        }

        @Override
        BpmoOperation buildBpmoOperation(NamespaceContext operationContext) {
            return WsdlElementFactory.createBpmoOperation(operationContext);
        }
    }

    private class Getter
    extends BeanMethod {
        private Getter(AttributeTypeDescription atd) {
            super(atd);
        }

        @Override
        String buildOperationName() {
            String prefix = this.mtd.asAttribute().getType().isBool() ? WsdlTypeWriter.GETTER_PREFIX_IS : WsdlTypeWriter.GETTER_PREFIX_GET;
            return prefix + this.formatName(this.mtd.getName());
        }

        @Override
        List<ElementDef> buildSequenceRequestElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            result.add(this.buildThisElement(sequenceContext, schemaContext));
            return result;
        }

        @Override
        List<ElementDef> buildSequenceResponseElements(NamespaceContext sequenceContext, NamespaceContext schemaContext) throws TypeCatalogException {
            ArrayList<ElementDef> result = new ArrayList<ElementDef>();
            Argument returnArg = new Argument("return", (TypeRef)this.atd.getType(), 0L);
            ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(returnArg, sequenceContext, schemaContext, false);
            if (elem == null) {
                throw new TypeCatalogException(WsdlTypeWriter.this.xotd.getCatalog(), ProjectCatalogMsg.UNSUPPORTED_TYPE(this.atd.getType()));
            }
            result.add(elem);
            return result;
        }
    }

    private class DelegatedMethod
    extends Method {
        private final DelegatedMethodTypeDescription dmtd;
        private ObjectTypeDescription service;

        private DelegatedMethod(DelegatedMethodTypeDescription dmtd) {
            if (dmtd == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter$DelegatedMethod.<init> must not be null");
            }
            super((MethodTypeDescription)dmtd, 0);
            this.dmtd = dmtd;
            this.init(dmtd);
        }

        public ObjectTypeDescription getService() {
            return this.service;
        }

        public String getSignature() {
            return this.dmtd.getDelegatedMethodSignature();
        }

        @Override
        void addOperationBpmoElements(DefaultElement operation, NamespaceContext operationContext) {
            String signature = this.getSignature();
            BpmoDelegate bpmoDelegate = null;
            if (this.getService().getComponentType().equals(ComponentType.PORT_TYPE.getText())) {
                assert (this.getService() instanceof WsdlTypeDescription) : "The service is not an XmlObjectTypeDescription";
                WsdlTypeDescription xmlotd = (WsdlTypeDescription)this.getService();
                bpmoDelegate = WsdlElementFactory.createBpmoDelegateForWsdlService(operationContext, signature, xmlotd.getNamespace(), xmlotd.getNativeName());
            }
            if (bpmoDelegate == null) {
                throw new TypeException(ProjectCatalogMsg.UNSUPPORTED_SERVICE_TYPE(this.getService().getText(), this.getService().getComponentType()));
            }
            operation.addChild(bpmoDelegate);
        }

        private void init(DelegatedMethodTypeDescription dmtd) {
            TypeRef ref = dmtd.getDelegatedService();
            TypeDescription td = ref.get();
            if (td == null) {
                throw new TypeException(ProjectCatalogMsg.MISSING_SERVICE(ref.getText()));
            }
            this.service = td.asObject();
        }
    }

    private abstract class WsdlOperationElement {
        MethodTypeDescription mtd;
        private String inputName;
        private String operationName;
        private String outputName;
        private static final String PARAMETERS = "parameters";

        private WsdlOperationElement(MethodTypeDescription mtd) {
            this.mtd = mtd;
        }

        public abstract boolean needsInput();

        public abstract boolean needsOutput();

        public String getInputName() {
            if (this.inputName == null) {
                this.inputName = this.buildInputName(this.getOperationName());
            }
            return this.inputName;
        }

        public String getOutputName() {
            if (this.outputName == null) {
                this.outputName = this.buildOutputName(this.getOperationName());
            }
            return this.outputName;
        }

        public String getOperationName() {
            if (this.operationName == null) {
                this.operationName = this.buildOperationName();
            }
            return this.operationName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WsdlOperationElement)) {
                return false;
            }
            WsdlOperationElement that = (WsdlOperationElement)o;
            return this.getOperationName().equals(that.getOperationName());
        }

        public int hashCode() {
            return this.getOperationName().hashCode();
        }

        abstract String buildOperationName();

        abstract List<ElementDef> buildSequenceRequestElements(NamespaceContext var1, NamespaceContext var2);

        abstract List<ElementDef> buildSequenceResponseElements(NamespaceContext var1, NamespaceContext var2) throws TypeCatalogException;

        abstract BpmoOperation buildBpmoOperation(NamespaceContext var1);

        Operation buildBindingOperation(NamespaceContext bindingContext) {
            String name = this.getOperationName();
            Operation operation = WsdlElementFactory.createOperation(name, bindingContext);
            if (!this.mtd.isAttribute()) {
                BpmoProperties properties = new BpmoProperties();
                properties.putAll(this.mtd.getProperties());
                if (properties.hasChilds()) {
                    operation.addChild(properties);
                }
            }
            NamespaceContext operationContext = operation.getNSContext();
            this.addOperationBpmoElements(operation, operationContext);
            if (this.needsInput()) {
                String in = this.getInputName();
                DefaultElement input = WsdlElementFactory.createInput(in, operationContext);
                operation.addChild(input);
            }
            if (this.needsOutput()) {
                String out = this.getOutputName();
                DefaultElement output = WsdlElementFactory.createOutput(out, operationContext);
                operation.addChild(output);
            }
            WsdlTypeWriter.this.getContext().addBindingOperation(name, operation);
            return operation;
        }

        void addOperationBpmoElements(DefaultElement operation, NamespaceContext operationContext) {
            SourceCode code = this.getCode();
            BpmoOperation bpmoOperation = this.buildBpmoOperation(operationContext);
            operation.addChild(bpmoOperation);
            DefaultElement bpmoScript = WsdlElementFactory.createBpmoScript(code != null ? code.getLanguage() : null, bpmoOperation.getNSContext());
            bpmoOperation.addChild(bpmoScript);
            if (code != null) {
                CData data = new CData(code.asString());
                data.setNSContext(new NamespaceContext(bpmoScript.getNSContext()));
                bpmoScript.addChild(data);
            }
        }

        SourceCode getCode() {
            return this.mtd.getCode();
        }

        DefaultElement buildPortTypeOperation(NamespaceContext portTypeContext) {
            Operation operation = WsdlElementFactory.createOperation(this.getOperationName(), portTypeContext);
            NamespaceContext operationContext = operation.getNSContext();
            DefaultElement doc = AbstractBpmoTypeWriter.buildDocumentation((TypeDescription)this.mtd, operationContext);
            if (doc.hasChilds()) {
                operation.insertFirstChild(doc);
            }
            if (this.needsInput()) {
                String inMessageName = "tns:" + this.getInputName();
                Input input = WsdlElementFactory.createInputMessage(this.getInputName(), inMessageName, operationContext);
                operation.addChild(input);
            }
            if (this.needsOutput()) {
                String outMessageName = "tns:" + this.getOutputName();
                Output output = WsdlElementFactory.createOutputMessage(this.getOutputName(), outMessageName, operation.getNSContext());
                operation.addChild(output);
            }
            return operation;
        }

        List<DefaultElement> buildMessages(NamespaceContext serviceDefinitionContext, String prefix) {
            String elementName;
            ArrayList<DefaultElement> result = new ArrayList<DefaultElement>();
            if (this.needsInput()) {
                Message messageIn = WsdlElementFactory.createMessage(this.getInputName(), serviceDefinitionContext);
                elementName = this.getRequestMessageElementName(prefix);
                Part partIn = WsdlElementFactory.createPart(PARAMETERS, elementName, messageIn.getNSContext());
                messageIn.addChild(partIn);
                result.add(messageIn);
            }
            if (this.needsOutput()) {
                Message messageOut = WsdlElementFactory.createMessage(this.getOutputName(), serviceDefinitionContext);
                elementName = this.getResponseMessageElementName(prefix);
                Part partOut = WsdlElementFactory.createPart(PARAMETERS, elementName, messageOut.getNSContext());
                messageOut.addChild(partOut);
                result.add(messageOut);
            }
            return result;
        }

        String getResponseMessageElementName(String prefix) {
            return prefix + ":" + this.getOutputName();
        }

        String getRequestMessageElementName(String prefix) {
            return prefix + ":" + this.getInputName();
        }

        List<DefaultElement> buildTypeElements(NamespaceContext schemaContext) throws TypeCatalogException {
            Sequence sequence;
            ComplexType complexType;
            ArrayList<DefaultElement> result = new ArrayList<DefaultElement>(2);
            if (this.needsInput()) {
                ElementDef elementIn = SchemaElementFactory.createElement(this.getInputName(), schemaContext);
                complexType = SchemaElementFactory.createComplexType(elementIn.getNSContext());
                elementIn.addChild(complexType);
                sequence = SchemaElementFactory.createSequence(complexType.getNSContext());
                for (ElementDef elementDef : this.buildSequenceRequestElements(sequence.getNSContext(), schemaContext)) {
                    sequence.addChild(elementDef);
                }
                if (sequence.hasChilds()) {
                    complexType.addChild(sequence);
                }
                result.add(elementIn);
            }
            if (this.needsOutput()) {
                ElementDef elementOut = SchemaElementFactory.createElement(this.getOutputName(), schemaContext);
                complexType = SchemaElementFactory.createComplexType(elementOut.getNSContext());
                elementOut.addChild(complexType);
                sequence = SchemaElementFactory.createSequence(complexType.getNSContext());
                for (ElementDef elementDef : this.buildSequenceResponseElements(sequence.getNSContext(), schemaContext)) {
                    sequence.addChild(elementDef);
                }
                if (sequence.hasChilds()) {
                    complexType.addChild(sequence);
                }
                result.add(elementOut);
            }
            return result;
        }

        ElementDef buildThisElement(NamespaceContext sequenceContext, NamespaceContext schemaContext) {
            Argument thisArg = new Argument("this", (TypeRef)WsdlTypeWriter.this.xotd, 0L);
            ElementDef elem = WsdlTypeWriter.this.elementBuilder.buildElementForArgument(thisArg, sequenceContext, schemaContext, false);
            if (elem != null) {
                return elem;
            }
            throw new RuntimeException("Unable to construct this object schema type '" + WsdlTypeWriter.this.xotd.getText() + "'");
        }

        private String buildOutputName(String operationName) {
            return operationName + "Response";
        }

        private String buildInputName(String operationName) {
            return operationName;
        }
    }

    private abstract class BeanMethod
    extends WsdlOperationElement {
        AttributeTypeDescription atd;

        private BeanMethod(AttributeTypeDescription atd) {
            super((MethodTypeDescription)atd);
            this.atd = atd;
        }

        @Override
        public boolean needsInput() {
            return true;
        }

        @Override
        public boolean needsOutput() {
            return true;
        }

        @Override
        BpmoOperation buildBpmoOperation(NamespaceContext operationContext) {
            BpmoOperation bpmoOperation = WsdlElementFactory.createBpmoOperation(operationContext);
            bpmoOperation.setAttributeName(this.atd.getName());
            bpmoOperation.setVirtual(this.atd.isVirtual());
            return bpmoOperation;
        }

        String formatName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/WsdlTypeWriter$BeanMethod.formatName must not be null");
            }
            StringBuilder builder = new StringBuilder();
            builder.append(Character.toUpperCase(name.charAt(0)));
            if (name.length() > 1) {
                builder.append(name.substring(1));
            }
            return builder.toString();
        }
    }
}

