/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.recognizer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import org.jetbrains.annotations.NotNull;

public class FileHeader {
    @NotNull
    private final VFile file;
    private String header;
    private static int MAX_HEADER_LEN = 1024;

    private FileHeader(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/FileHeader.<init> must not be null");
        }
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FileHeader createFileHeader(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/FileHeader.createFileHeader must not be null");
        }
        FileHeader fileHeader = new FileHeader(vFile);
        if (fileHeader == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/FileHeader.createFileHeader must not return null");
        }
        return fileHeader;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFile getFile() {
        VFile vFile = this.file;
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/FileHeader.getFile must not return null");
        }
        return vFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getHeader() throws IOException {
        if (this.header == null) {
            this.readFileHeader();
        }
        String string = this.header;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/FileHeader.getHeader must not return null");
        }
        return string;
    }

    private void readFileHeader() throws IOException {
        this.header = "";
        if (!this.file.isDirectory()) {
            int n;
            int count;
            BufferedInputStream is = new BufferedInputStream((InputStream)new VFileInputStream(this.file));
            byte[] buffer = new byte[MAX_HEADER_LEN];
            for (n = 0; n < MAX_HEADER_LEN && (count = ((InputStream)is).read(buffer, n, MAX_HEADER_LEN - n)) >= 0; n += count) {
            }
            ((InputStream)is).close();
            if (n > 0) {
                this.header = new String(buffer, 0, n, "UTF-8");
            }
        }
    }
}

