/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.Annotation;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.InvalidSchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaElement
extends DefaultElement {
    protected String javaType;
    protected TypeDescription type;
    private Annotation annotation;

    protected SchemaElement() {
    }

    SchemaElement(SchemaElement element) {
        this.setNamespace(element.getNamespace());
        this.setNSContext(element.getNSContext());
    }

    public static String buildSignature(TypeDescription type) {
        String signature;
        switch (type.getKind()) {
            case 10: {
                signature = String.valueOf('A');
                break;
            }
            case 12: {
                String namespace;
                ArrayTypeDescription arrayType = (ArrayTypeDescription)type;
                boolean isSoap = Boolean.TRUE.toString().equals(arrayType.getProperty("soapArray"));
                TypeDescription elementType = type.getElementType();
                signature = (isSoap ? (char)'{' : '[') + SchemaElement.buildSignature(elementType);
                if (!elementType.isObject() || (namespace = elementType.asObject().getProperty("namespace")) == null) break;
                signature = signature + ":" + namespace;
                break;
            }
            case 8: {
                if (type == SFSNamespace.HEX_BINARY) {
                    signature = String.valueOf('H');
                    break;
                }
                signature = String.valueOf('Y');
                break;
            }
            case 1: {
                signature = String.valueOf('B');
                break;
            }
            case 3: {
                signature = String.valueOf('D');
                break;
            }
            case 2: {
                if (type == SFSNamespace.GDAY) {
                    signature = String.valueOf('5');
                    break;
                }
                if (type == SFSNamespace.GMONTH) {
                    signature = String.valueOf('6');
                    break;
                }
                signature = String.valueOf('I') + type.getLength() / 8;
                break;
            }
            case 7: {
                signature = String.valueOf('V');
                break;
            }
            case 4: {
                signature = String.valueOf('R') + type.getLength() / 8;
                break;
            }
            case 5: {
                signature = String.valueOf('S');
                break;
            }
            case 6: {
                if (type == SFSNamespace.TIME_TIME) {
                    signature = String.valueOf('1');
                    break;
                }
                if (type == SFSNamespace.GYEARMONTH_TIME) {
                    signature = String.valueOf('3');
                    break;
                }
                if (type == SFSNamespace.GMONTHDAY_TIME) {
                    signature = String.valueOf('4');
                    break;
                }
                if (type == SFSNamespace.DATE) {
                    signature = String.valueOf('7');
                    break;
                }
                signature = String.valueOf('2');
                break;
            }
            case 11: {
                String objectSignature = type.getSignature();
                int index = objectSignature.indexOf(59);
                if (index != -1) {
                    objectSignature = objectSignature.substring(0, index);
                }
                signature = String.valueOf('X') + objectSignature;
                break;
            }
            case 17: {
                signature = String.valueOf('E');
                int count = type.getMemberCount();
                for (int i = 0; i < count; ++i) {
                    MethodTypeDescription enumItem = type.getMemberType(i);
                    String nativeName = enumItem.getProperty("nativeName");
                    signature = signature + nativeName;
                    if (i + 1 >= count) continue;
                    signature = signature + ",";
                }
                break;
            }
            default: {
                throw new IllegalTypeException(type.getText() + "' (" + type.getClass().getName() + ")");
            }
        }
        return signature;
    }

    public Context getContext() {
        return (Context)this.getNSContext();
    }

    public TypeDescription getTypeDescription() throws TypeBuildException {
        if (this.type == null) {
            this.type = this.buildType(null);
        }
        return this.type;
    }

    public TypeDescription getTypeIfCreated() {
        return this.type;
    }

    @Override
    public void addChild(Element element) {
        if (element instanceof Annotation) {
            this.setAnnotation((Annotation)element);
        }
        super.addChild(element);
    }

    public Schema getSchema() {
        return this.findAncestorByClass(Schema.class);
    }

    public ExtendedNamespace getTarget() {
        return this.getContext().getTarget();
    }

    protected final TypeDescription buildSubElements(TypeDescription current) throws TypeBuildException {
        TypeDescription last = null;
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            this.type = element.buildType(current);
            if (this.type == null) continue;
            last = this.type;
        }
        return last;
    }

    protected AttrGroupTypeDescription buildAttributes(TypeDescription current, boolean mergeGroups) throws TypeBuildException {
        return this.buildAttributes(this.getFirst(), current, mergeGroups);
    }

    protected final AttrGroupTypeDescription buildAttributes(SchemaElement element, TypeDescription current, boolean mergeGroups) throws TypeBuildException {
        AttrGroupTypeDescription group;
        ArrayList<Object> attributes = new ArrayList<Object>();
        boolean hasAnyAttribute = false;
        while (element != null) {
            TypeDescription type = element.buildType(current);
            if (type != null && type.isAttribute()) {
                boolean isAttribute;
                String name = type.getName();
                boolean bl = isAttribute = type.getSignature().charAt(0) == 'A';
                if (this.findAttributeByName(attributes, name) != null) {
                    if (type instanceof AttributeTypeDescription && type.getSignature() != null && isAttribute) {
                        AttributeTypeDescription attr = (AttributeTypeDescription)type;
                        attr = attr.clone();
                        attr.setName(name + "Attribute");
                        attributes.add(attr);
                    }
                } else {
                    attributes.add(type);
                }
            } else if (mergeGroups && type instanceof AttrGroupTypeDescription) {
                AttributeTypeDescription[] elements;
                group = (AttrGroupTypeDescription)type;
                hasAnyAttribute = hasAnyAttribute || group.hasAnyAttribute();
                for (AttributeTypeDescription attr : elements = group.getAttributes()) {
                    AttributeTypeDescription prev;
                    String name = attr.getName();
                    int number = 1;
                    String numberText = "";
                    while ((prev = this.findAttributeByName(attributes, name + numberText)) != null && !prev.getType().equals(attr.getType())) {
                        numberText = String.valueOf(++number);
                    }
                    if (prev != null) continue;
                    if (number > 1) {
                        attr = attr.clone();
                        attr.setName(name + numberText);
                    }
                    attributes.add(attr);
                }
            }
            element = element.getNext();
        }
        group = new AttrGroupTypeDescription(attributes);
        group.setAnyAttribute(hasAnyAttribute);
        return group;
    }

    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        if (this.type != null) {
            return this.type;
        }
        return this.buildSubElements(current);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected TypeRef lookupTypeRef(@NotNull String type, @NotNull ComponentCatalog catalog) throws TypeBuildException {
        TypeRef typeRef;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaElement.lookupTypeRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaElement.lookupTypeRef must not be null");
        }
        try {
            typeRef = this.getContext().lookupTypeRef(type, catalog);
        }
        catch (ContextLookupException e) {
            throw TypeNotFoundException.wrap(e, (DefaultElement)this);
        }
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaElement.lookupTypeRef must not return null");
        }
        return typeRef;
    }

    protected void declare() throws TypeBuildException {
    }

    @Nullable
    protected TypeDescription findType(@NotNull String text) throws TypeNotFoundException {
        TypeDescription type;
        block5: {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaElement.findType must not be null");
            }
            try {
                type = this.getContext().lookupType(text).buildType(null);
            }
            catch (ContextLookupException e) {
                type = this.findExternalType(text);
                if (type == null) {
                    throw TypeNotFoundException.wrap(e, (DefaultElement)this);
                }
            }
            catch (TypeBuildException e) {
                type = this.findExternalType(text);
                if (type != null) break block5;
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
        return type;
    }

    protected String localName(String name) {
        return XmlUtils.localname((String)name);
    }

    protected String prefix(String name) {
        return XmlUtils.prefix((String)name);
    }

    @Override
    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding, DefaultElement.DumpParameters parameters) {
        boolean originalValue = parameters.isAddContextNamespaces();
        parameters.setAddContextNamespaces(true);
        super.dump(out, root, fuegoProcessingInstruction, currentCtx, encoding, parameters);
        parameters.setAddContextNamespaces(originalValue);
    }

    void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    SchemaElement getFirst() {
        DefaultElement firstElement = this.getFirstElement();
        if (firstElement != null && !(firstElement instanceof SchemaElement)) {
            firstElement = new InvalidSchemaElement(firstElement);
        }
        while (firstElement != null && firstElement instanceof Annotation) {
            firstElement = ((SchemaElement)firstElement).getNext();
        }
        return (SchemaElement)firstElement;
    }

    void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    SchemaElement getNext() {
        DefaultElement nextElement = this.getNextElement();
        if (nextElement != null && !(nextElement instanceof SchemaElement)) {
            nextElement = new InvalidSchemaElement(nextElement);
        }
        return (SchemaElement)nextElement;
    }

    SchemaParser getSchemaParser() {
        return (SchemaParser)this.getXMLParser();
    }

    void setTypeDescription(TypeDescription type) {
        this.type = type;
    }

    void addAnnotations(TypeDescription type) throws TypeBuildException {
        if (this.annotation != null) {
            this.annotation.buildType(type);
        }
    }

    @Nullable
    private TypeDescription findExternalType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaElement.findExternalType must not be null");
        }
        TypeDescription type = null;
        Namespace namespace = this.getContext().findNamespace(this.prefix(text));
        String uri = "";
        if (namespace != null) {
            uri = namespace.getUri();
        }
        XmlUUID id = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)uri, (String)this.localName(text));
        TypeRef typeRef = this.getSchemaParser().getTypeFinder().findById(ComponentType.XML.getText(), id.getId());
        if (typeRef != null) {
            type = typeRef.get();
        }
        return type;
    }

    private AttributeTypeDescription findAttributeByName(List attributes, String name) {
        AttributeTypeDescription result = null;
        for (Object attribute : attributes) {
            AttributeTypeDescription attr = (AttributeTypeDescription)attribute;
            if (!attr.getName().equals(name)) continue;
            result = attr;
            break;
        }
        return result;
    }
}

