/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeToXsdMapping;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import org.jetbrains.annotations.NotNull;

public class SFSNamespace
extends ExtendedNamespace {
    private static final Map<String, SFSNamespace> instances = new HashMap<String, SFSNamespace>();
    static final String S2001 = "http://www.w3.org/2001/XMLSchema";
    static final TypeDescription BASE64_BINARY = TypeDescriptionImpl.createTypeDescription((int)8, (int)-1, (int)0, (boolean)false);
    static final TypeDescription HEX_BINARY = TypeDescriptionImpl.createTypeDescription((int)8, (int)-1, (int)1, (boolean)false);
    static final TypeDescription TIME_TIME = TypeDescriptionImpl.createTypeDescription((int)6, (int)-1, (int)1, (boolean)false);
    static final TypeDescription DATE = TypeDescriptionImpl.createTypeDescription((int)6, (int)-1, (int)0, (boolean)false);
    static final TypeDescription DATETIME_TIME = TypeDescriptionImpl.createTypeDescription((int)6, (int)-1, (int)2, (boolean)false);
    static final TypeDescription GYEARMONTH_TIME = TypeDescriptionImpl.createTypeDescription((int)6, (int)-1, (int)4, (boolean)false);
    static final TypeDescription GMONTHDAY_TIME = TypeDescriptionImpl.createTypeDescription((int)6, (int)-1, (int)3, (boolean)false);
    static final TypeDescription GDAY = TypeDescriptionImpl.createTypeDescription((int)2, (int)-1, (int)-1, (boolean)false);
    static final TypeDescription GMONTH = TypeDescriptionImpl.createTypeDescription((int)2, (int)-1, (int)-1, (boolean)false);
    public static final SFSNamespace S2001_NAMESPACE = SFSNamespace.get("http://www.w3.org/2001/XMLSchema");
    static final long serialVersionUID = 4618604833645299491L;
    static final long serialCheck = 5323702424466743775L;

    private SFSNamespace(String uri) {
        super(uri);
        this.names.putAll(TypeToXsdMapping.getTypesToXsd());
        this.mappingXsdTypesToTypeDef();
        this.mappingTypeDefToXsdTypes();
    }

    public static boolean isSFS(String uri) {
        return uri != null && uri.startsWith("http://www.w3.org/") && uri.endsWith("/XMLSchema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SFSNamespace get(String uri) {
        Map<String, SFSNamespace> map = instances;
        synchronized (map) {
            SFSNamespace result = instances.get(uri);
            if (result == null) {
                result = new SFSNamespace(uri);
                instances.put(uri, result);
            }
            return result;
        }
    }

    @Override
    void declareAnonymous(@NotNull TypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareAnonymous must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    void declareAttribute(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareAttribute must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareAttribute must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    void declareAttributeGroup(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareAttributeGroup must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareAttributeGroup must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    void declareElement(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareElement must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SFSNamespace.declareElement must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    void declareGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareType(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    private void addXsdToTypeDef(String name, TypeDescription type) {
        this.addXsdToTypeDef(name, type, null);
    }

    private void addXsdToTypeDef(String name, TypeDescription type, String javaType) {
        SchemaElement typeHolder = new SchemaElement();
        if (type.isReal() || type.isInt() && type != GDAY && type != GMONTH) {
            type = type.primitiveEquivalent(true);
        }
        typeHolder.setTypeDescription(type);
        typeHolder.setJavaType(javaType);
        typeHolder.setNamespace(this.getUri());
        typeHolder.setAttribute("name", name);
        this.types.put(name, typeHolder);
        if (!this.names.containsKey(type)) {
            this.names.put(type, name);
        }
    }

    private void addTypeDefToXsd(TypeDescription type, String xsdType) {
        if ((type.isReal() || type.isInt()) && type != GDAY && type != GMONTH) {
            this.names.put(type.primitiveEquivalent(true), xsdType);
        }
        this.names.put(type, xsdType);
    }

    private void mappingTypeDefToXsdTypes() {
        this.addTypeDefToXsd((TypeDescription)TypeFactory.getArray((TypeRef)TypeFactory.getString()), "IDREFS");
    }

    private void mappingXsdTypesToTypeDef() {
        this.addXsdToTypeDef("string", TypeFactory.getString());
        this.addXsdToTypeDef("normalizedString", TypeFactory.getString());
        this.addXsdToTypeDef("token", TypeFactory.getString());
        this.addXsdToTypeDef("Name", TypeFactory.getString());
        this.addXsdToTypeDef("QName", TypeFactory.getString());
        this.addXsdToTypeDef("NCName", TypeFactory.getString());
        this.addXsdToTypeDef("anyURI", TypeFactory.getString());
        this.addXsdToTypeDef("language", TypeFactory.getString());
        this.addXsdToTypeDef("ID", TypeFactory.getString());
        this.addXsdToTypeDef("IDREF", TypeFactory.getString());
        this.addXsdToTypeDef("ENTITY", TypeFactory.getString());
        this.addXsdToTypeDef("NOTATION", TypeFactory.getString());
        this.addXsdToTypeDef("NMTOKEN", TypeFactory.getString());
        this.addXsdToTypeDef("uriReference", TypeFactory.getString());
        this.addXsdToTypeDef("IDREFS", (TypeDescription)TypeFactory.getArray((TypeRef)TypeFactory.getString()));
        this.addXsdToTypeDef("ENTITIES", (TypeDescription)TypeFactory.getArray((TypeRef)TypeFactory.getString()));
        this.addXsdToTypeDef("NMTOKENS", (TypeDescription)TypeFactory.getArray((TypeRef)TypeFactory.getString()));
        this.addXsdToTypeDef("byte", TypeFactory.getInt((int)8), "byte");
        this.addXsdToTypeDef("unsignedByte", TypeFactory.getInt((int)8), "byte");
        this.addXsdToTypeDef("integer", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("positiveInteger", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("negativeInteger", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("nonNegativeInteger", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("nonPositiveInteger", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("int", TypeFactory.getInt((int)32), "int");
        this.addXsdToTypeDef("unsignedInt", TypeFactory.getInt((int)32), "int");
        this.addXsdToTypeDef("long", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("unsignedLong", TypeFactory.getInt((int)64), "int");
        this.addXsdToTypeDef("short", TypeFactory.getInt((int)16), "short");
        this.addXsdToTypeDef("unsignedShort", TypeFactory.getInt((int)16), "short");
        this.addXsdToTypeDef("gMonth", GMONTH, "int");
        this.addXsdToTypeDef("gYear", TypeFactory.getInt((int)16), "int");
        this.addXsdToTypeDef("gDay", GDAY, "int");
        this.addXsdToTypeDef("decimal", TypeFactory.getDecimal());
        this.addXsdToTypeDef("float", TypeFactory.getReal((int)32), "float");
        this.addXsdToTypeDef("double", TypeFactory.getReal(), "double");
        this.addXsdToTypeDef("boolean", TypeFactory.getBool());
        this.addXsdToTypeDef("boolean", TypeFactory.getPrimitiveBool());
        this.addXsdToTypeDef("dateTime", DATETIME_TIME);
        this.addXsdToTypeDef("time", TIME_TIME);
        this.addXsdToTypeDef("date", DATE);
        this.addXsdToTypeDef("gYearMonth", GYEARMONTH_TIME);
        this.addXsdToTypeDef("gMonthDay", GMONTHDAY_TIME);
        this.addXsdToTypeDef("timeInstant", TypeFactory.getTime());
        this.addXsdToTypeDef("duration", TypeFactory.getInterval());
        this.addXsdToTypeDef("timeDuration", TypeFactory.getInterval());
        this.addXsdToTypeDef("base64Binary", BASE64_BINARY);
        this.addXsdToTypeDef("hexBinary", HEX_BINARY);
        this.addXsdToTypeDef("anySimpleType", TypeFactory.getString());
        this.addXsdToTypeDef("anyType", TypeFactory.getAny());
    }
}

