/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import org.jetbrains.annotations.Nullable;

class Group
extends ComponentDef {
    Group() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        String ref = this.getRef();
        if (ref != null) {
            try {
                current = this.getContext().lookupGroupType(this.getSchemaParser().getTypeFinder(), ref);
            }
            catch (ContextLookupException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        } else {
            current = super.buildType(current);
            current = this.buildSubElements(current);
            AttrGroupTypeDescription att = (AttrGroupTypeDescription)current;
            att.setName(this.getName());
            ExtendedNamespace currentNamespace = this.getContext().getTarget();
            String namespace = currentNamespace.getUri();
            att.setNamespace(namespace);
        }
        return current;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareGroup(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
    }

    String getRef() {
        return this.getAttribute("ref");
    }
}

