/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlEnumTypeDescription;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLenghtException;
import oracle.bpm.project.catalog.parser.xsd.exception.XsdTypeBuildException;
import oracle.bpm.type.TypeFactory;
import org.jetbrains.annotations.Nullable;

public class Facet
extends SchemaElement {
    private int facet;
    static final int FACET_LENGTH = 1;
    static final int FACET_MIN_LENGTH = 2;
    static final int FACET_MAX_LENGTH = 3;
    static final int FACET_PATTERN = 4;
    static final int FACET_ENUMERATION = 5;
    static final int FACET_WHITE_SPACE = 6;
    static final int FACET_MAX_INCLUSIVE = 7;
    static final int FACET_MAX_EXCLUSIVE = 8;
    static final int FACET_MIN_INCLUSIVE = 9;
    static final int FACET_MIN_EXCLUSIVE = 10;
    static final int FACET_TOTAL_DIGITS = 11;
    static final int FACET_FRACTION_DIGITS = 12;

    Facet(int facet) {
        this.facet = facet;
    }

    @Override
    public void verify() throws NoWellFormedContentException {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws XsdTypeBuildException {
        switch (this.facet) {
            case 1: 
            case 3: {
                if (current == null || !current.isString()) break;
                try {
                    current = TypeFactory.getString((int)Integer.parseInt(this.getValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new InvalidLenghtException(this.getValue(), (SchemaElement)this);
                }
            }
            case 12: {
                if (current == null || !current.isDecimal()) break;
                break;
            }
            case 5: {
                if (current == null || !current.isEnum()) break;
                XmlEnumTypeDescription enumType = (XmlEnumTypeDescription)current;
                enumType.addItem(this.getValue(), Integer.valueOf(enumType.getMemberCount()));
                break;
            }
        }
        return current;
    }

    String getValue() {
        return this.getAttribute("value");
    }
}

