/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

class Extension
extends ComponentDef {
    Extension() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        String base = this.getBase();
        ObjectTypeDescription baseType = XmlTypeHelper.XMLOBJECT;
        Boolean implementsAbstract = false;
        if (base != null) {
            baseType = this.findType(base);
        }
        AttrGroupTypeDescription group = this.buildAttributes((TypeDescription)baseType, true);
        if (baseType.isObject()) {
            ObjectTypeDescription subclass = super.buildType(current).asObject();
            subclass.addSuperType(new SuperType((TypeRef)baseType, 32768L));
            group.addTo(subclass);
            if (baseType.isAbstract()) {
                implementsAbstract = true;
            }
            baseType = subclass;
            if (implementsAbstract.booleanValue()) {
                baseType.setProperty("implementsAbstractType", Boolean.TRUE.toString());
            }
        } else if (group.hasAttributes()) {
            ObjectTypeDescription subclass = super.buildType(current).asObject();
            String signature = "Cvalue";
            AttributeTypeDescription value = new AttributeTypeDescription("value", (TypeRef)baseType);
            value.setModifiers(12L);
            value.setReadSignature(signature + ";" + Extension.buildSignature((TypeDescription)baseType));
            value.setWriteSignature(signature + ";" + Extension.buildSignature((TypeDescription)baseType));
            subclass.addMember((MethodTypeDescription)value);
            group.addTo(subclass);
            baseType = subclass;
        }
        return baseType;
    }

    String getBase() {
        return this.getAttribute("base");
    }
}

