/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlEnumTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.Nullable;

class Enumeration
extends SchemaElement {
    private static final String UNSUPPORTED_PREFIX = "X_";

    Enumeration() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) {
        if (current != null && current.isEnum()) {
            XmlEnumTypeDescription enumType = (XmlEnumTypeDescription)current;
            String value = this.getValue();
            int memberCount = enumType.getMemberCount();
            String label = value;
            if (!(Identifier.isValid((String)label) || (label = Identifier.constant((String)label)) != null && label.length() != 0)) {
                label = UNSUPPORTED_PREFIX + memberCount;
            }
            enumType.addItem(label, Integer.valueOf(memberCount), value);
        }
        return null;
    }

    String getValue() {
        return this.getAttribute("value");
    }
}

