/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.List;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.AttributeDef;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Particle;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.MissingAttributeException;
import oracle.bpm.project.catalog.parser.xsd.exception.PartNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementDef
extends AttributeDef {
    private static final String QUALIFIED = "qualified";

    public ElementDef() {
    }

    public ElementDef(SchemaElement context, String name) {
        super(context);
        this.setTagName("element");
        this.setAttribute("name", name);
    }

    public static void setSignature(AttributeTypeDescription attr, String elementName, int maxOccurs, Namespace namespace, String elementNamespace, boolean elementIsQualified) {
        ElementDef.setSignature(attr, elementName, maxOccurs, namespace, elementNamespace, elementIsQualified, false);
    }

    public static void setSignature(AttributeTypeDescription attr, String elementName, int maxOccurs, Namespace namespace, String elementNamespace, boolean elementIsQualified, boolean isPartElement) {
        int signatureType;
        attr.setProperty("nativeName", elementName);
        if (attr.getReadSignature() == null || attr.getWriteSignature() == null) {
            attr.setReadSignature('A' + elementName);
            attr.setWriteSignature('A' + elementName);
        }
        TypeDescription td = null;
        TypeRef typeRef = attr.getTypeRef();
        if (typeRef instanceof DynamicRef) {
            if (maxOccurs > 1) {
                signatureType = 78;
                attr.setType((TypeRef)TypeFactory.createArray((TypeRef)attr.getTypeRef()));
            } else {
                signatureType = 86;
            }
        } else {
            td = attr.getType();
            if (maxOccurs > 1) {
                signatureType = 78;
                td = TypeFactory.createArray((TypeRef)attr.getTypeRef());
                attr.setType((TypeRef)td);
            } else {
                signatureType = isPartElement ? 90 : (td.isObject() || td.isAny() ? 69 : 86);
            }
        }
        String signature = (char)signatureType + attr.getWriteSignature().substring(1);
        int index = signature.indexOf(59);
        if (index != -1) {
            signature = signature.substring(0, index);
        }
        signature = td != null ? signature + ';' + ElementDef.buildSignature(td) : signature + 147 + typeRef.getName();
        signature = signature + ';';
        if (namespace != null && namespace.getUri() != null) {
            signature = signature + namespace.getUri().trim();
        }
        signature = signature + ';';
        if (elementNamespace != null) {
            signature = signature + elementNamespace;
        }
        signature = signature + ';' + (elementIsQualified ? "elementQualified" : "N");
        attr.setReadSignature(signature);
        attr.setWriteSignature(signature);
    }

    public void setMaxOccurs(String occurs) {
        this.setAttribute("maxOccurs", occurs);
    }

    public void setMinOccurs(String occurs) {
        this.setAttribute("minOccurs", occurs);
    }

    public String getFixed() {
        return this.getAttribute("fixed");
    }

    public String getDefaultValue() {
        return this.getAttribute("default");
    }

    @Nullable
    public Argument buildBpmObjectArgument() throws TypeBuildException {
        TypeRef argType;
        String name;
        block8: {
            name = this.getBpmElementName();
            String type = this.getType();
            String element = this.getName();
            String ref = this.getRef();
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            if (name == null && (name = this.getName()) == null) {
                throw new MissingAttributeException("name", "part", this);
            }
            if (type == null && element == null) {
                element = ref;
            }
            Context context = this.getContext();
            try {
                if (this.isHolderType(type)) {
                    AttributeTypeDescription attr = this.getElementTypeFromHolder(type);
                    argType = this.createLazyRef(catalog, attr.getTypeRef());
                    break block8;
                }
                if (type != null) {
                    argType = this.getContext().lookupTypeRef(type, catalog);
                    break block8;
                }
                if (element != null) {
                    argType = context.lookupElementRef(element, catalog);
                    break block8;
                }
                throw new PartNotFoundException(this);
            }
            catch (ContextLookupException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
        Argument arg = new Argument(Identifier.argument((String)name), argType, 0L);
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            arg.setDefaultValue(defaultValue);
        }
        arg.setProperty("nativeName", name);
        arg.setProperty("partName", name);
        return arg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        String defaultValue;
        String fixed;
        String form;
        TypeDescription typeDescription;
        if (this.type != null) {
            typeDescription = this.type;
            if (typeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ElementDef.buildType must not return null");
            return typeDescription;
        }
        String name = this.getName();
        boolean isQualified = false;
        boolean isRef = this.getRef() != null;
        ExtendedNamespace targetNamespace = this.getContext().getTarget();
        ExtendedNamespace namespace = null;
        ExtendedNamespace target = this.resolveNamespaceFromReferedElement();
        if (target != null && target.getUri() != null && !"".equals(target.getUri().trim())) {
            namespace = target;
            boolean isSubstitution = this.getSubstitutionGroup() != null;
            isQualified = isRef;
            if (isRef || isSubstitution) {
                targetNamespace = namespace;
            }
        }
        if ((form = this.getForm()) != null) {
            isQualified = QUALIFIED.equalsIgnoreCase(form);
        } else if (!isQualified && this.getSchema() != null && this.getSchema().isElementQualified()) {
            isQualified = true;
        }
        ExtendedNamespace currectNamespace = this.getContext().getTarget();
        this.getContext().setTarget(namespace);
        AttributeTypeDescription attr = this.buildAttribute(current);
        this.getContext().setTarget(currectNamespace);
        if (name == null && (name = this.localName(this.getRef())) == null) {
            name = this.localName(this.getSubstitutionGroup());
        }
        if ((fixed = this.getFixed()) != null) {
            attr.setProperty("fixedValue", fixed);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            attr.setProperty("defaultValue", defaultValue);
            attr.setDefaultValue(defaultValue);
        }
        attr.setProperty("nativeNamespace", targetNamespace.getUri());
        attr.setProperty("elementType", "elementType");
        attr.setProperty("isNilable", this.isNilable().toString());
        String elementNamespace = targetNamespace.getUri();
        if (!isQualified && !isRef) {
            elementNamespace = "";
        }
        attr.setProperty("elementNamespace", elementNamespace);
        int maxOccurs = this.getMaxOccurs();
        ElementDef.setSignature(attr, name, maxOccurs, targetNamespace, elementNamespace, isQualified);
        this.type = attr;
        typeDescription = attr;
        if (typeDescription != null) return typeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ElementDef.buildType must not return null");
    }

    public Boolean isNilable() {
        String nillableAttribute = this.getAttribute("nillable");
        return nillableAttribute != null && Boolean.valueOf(nillableAttribute) != false;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareElement(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
    }

    int getMaxOccurs() {
        return Particle.getMaxOccurs(this);
    }

    private boolean isHolderType(@Nullable String type) {
        boolean result = false;
        if (type != null) {
            String prefix = XmlUtils.prefix((String)type);
            String schemaNamespace = this.getContext().findNamespace(prefix).getUri();
            if (Utils.isHolderType(schemaNamespace, type)) {
                result = true;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private AttributeTypeDescription getElementTypeFromHolder(@NotNull String type) throws TypeBuildException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ElementDef.getElementTypeFromHolder must not be null");
        }
        TypeDescription typeRef = this.findType(type);
        TypeDescription typeDescription = typeRef.get();
        ObjectTypeDescription otd = typeDescription.asObject();
        List methodTypeDescriptions = otd.getAttributes();
        AttributeTypeDescription attributeTypeDescription = ((MethodTypeDescription)methodTypeDescriptions.get(0)).asAttribute();
        if (attributeTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/ElementDef.getElementTypeFromHolder must not return null");
        }
        return attributeTypeDescription;
    }

    private ExtendedNamespace resolveNamespaceFromReferedElement() {
        String elementName = this.resolveElementTypeName();
        ExtendedNamespace namespace = this.getContext().getTarget();
        if (elementName != null) {
            namespace = this.getContext().lookupNamespace(elementName);
        }
        return namespace;
    }

    private AttributeTypeDescription buildAttribute(TypeDescription current) throws TypeBuildException {
        AttributeTypeDescription attr;
        boolean isSubstitution;
        boolean isRef = this.getRef() != null;
        String attType = this.getType();
        boolean bl = isSubstitution = this.getSubstitutionGroup() != null && attType == null;
        if (isRef || isSubstitution) {
            String elementName = isRef ? this.getRef() : this.getSubstitutionGroup();
            String prefix = XmlUtils.prefix((String)elementName);
            ExtendedNamespace extendedNamespace = (ExtendedNamespace)this.getContext().findNamespace(prefix);
            String attributeName = this.getBpmElementName();
            String name = XmlUtils.localname((String)elementName);
            if (attributeName == null) {
                attributeName = name;
            }
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            XmlUUID xmluuid = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)extendedNamespace.getUri(), (String)name);
            BpmObjectDynamicRef ref = new BpmObjectDynamicRef(xmluuid.getId(), name, catalog);
            attr = new AttributeTypeDescription(Identifier.attribute((String)attributeName), (TypeRef)ref);
        } else {
            attr = super.buildType(current).asAttribute();
        }
        if (current != null && this.getContext().isTarget()) {
            TypeDescription attrType;
            ExtendedNamespace target = this.getContext().getTarget();
            TypeRef typeRef = attr.getTypeRef();
            if (!(typeRef instanceof DynamicRef) && target.isAnonymousType(attrType = attr.getType())) {
                assert (current instanceof ObjectTypeDescription);
                ObjectTypeDescription otd = attrType.asObject();
                otd.addModifier(0x2000000L);
                if (otd.isEnum()) {
                    String namespace = this.getTarget().getUri();
                    boolean elementsAreQualified = this.getSchema().isElementQualified();
                    boolean attributesAreQualified = this.getSchema().isAttributeQualified();
                    XmlTypeDescription object = XmlTypeHelper.createXmlTypeDescription(this.getName(), namespace, null, elementsAreQualified, attributesAreQualified, XmlElementType.ELEMENT);
                    object.addModifier(0x2000000L);
                    XmlTypeHelper.addElementTypeInfo((ObjectTypeDescription)object, otd.getNativeName(), namespace, (TypeRef)new DynamicRef(otd, ((SchemaParser)this.getXMLParser()).getCatalog()));
                    object.addInnerType((TypeRef)otd);
                    attr.setType((TypeRef)object);
                    try {
                        this.getTarget().declareAnonymous((TypeDescription)object);
                    }
                    catch (InvalidLocalNameException e) {
                        throw TypeNotFoundException.wrap(e, (DefaultElement)this);
                    }
                    ((ObjectTypeDescription)current).addInnerType((TypeRef)object);
                } else {
                    ((ObjectTypeDescription)current).addInnerType((TypeRef)attrType);
                }
            }
        }
        return attr;
    }

    private String resolveElementTypeName() {
        String name = this.getRef();
        if (name == null) {
            name = this.getType();
        }
        if (name == null) {
            name = this.getSubstitutionGroup();
        }
        return name;
    }
}

