/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import org.jetbrains.annotations.NotNull;

class AttrGroupTypeDescription
extends TypeDescriptionImpl {
    private boolean anyAttribute;
    private AttributeTypeDescription[] attributes;
    private String name;
    private String namespace;
    private static final AttributeTypeDescription[] TYPES = new AttributeTypeDescription[0];

    AttrGroupTypeDescription() {
        this(TYPES);
    }

    AttrGroupTypeDescription(List<?> attributes) {
        this(attributes.toArray(new AttributeTypeDescription[attributes.size()]));
    }

    AttrGroupTypeDescription(AttributeTypeDescription[] attributes) {
        super(0, -1, -1, false);
        this.attributes = attributes;
    }

    public String toString() {
        return "AttributeGroup(" + Arrays.asList(this.attributes) + " anyAttr = " + this.anyAttribute + ")";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setAnyAttribute(boolean anyAttr) {
        this.anyAttribute = anyAttr;
    }

    AttributeTypeDescription[] getAttributes() {
        return this.attributes;
    }

    void addAttribute(AttributeTypeDescription attr) {
        int length = this.attributes.length;
        for (int i = 0; i < length; ++i) {
            AttributeTypeDescription attribute = this.attributes[i];
            if (!attribute.getName().equals(attr.getName())) continue;
            throw new IllegalStateException("Duplicated attribute: " + attr);
        }
        AttributeTypeDescription[] attrs = new AttributeTypeDescription[length + 1];
        System.arraycopy(this.attributes, 0, attrs, 0, length);
        attrs[length] = attr;
        this.attributes = attrs;
    }

    void addTo(@NotNull ObjectTypeDescription objType) {
        if (objType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/AttrGroupTypeDescription.addTo must not be null");
        }
        if (this.attributes != null) {
            for (AttributeTypeDescription attribute : this.attributes) {
                attribute = attribute.clone();
                objType.addMember((MethodTypeDescription)attribute);
            }
        }
    }

    boolean hasAnyAttribute() {
        return this.anyAttribute;
    }

    boolean hasAttributes() {
        return this.attributes.length > 0 || this.anyAttribute;
    }
}

