/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.catalog.loaders.ResourceTypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.impl.TypeErrorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaxTypeBuildException
extends ResourceTypeBuildException {
    protected DefaultElement element;
    static final long serialVersionUID = 3312785257176453869L;
    static final long serialCheck = -4621844754006553476L;

    protected SaxTypeBuildException(@NotNull Msg causeMsg, @NotNull DefaultElement element) {
        if (causeMsg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.<init> must not be null");
        }
        this(causeMsg, element, null);
    }

    protected SaxTypeBuildException(@NotNull Msg causeMsg, @NotNull DefaultElement element, @Nullable Exception cause) {
        if (causeMsg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.<init> must not be null");
        }
        super(SaxTypeBuildException.resourceUri(element), (TypeError)SaxTypeBuildException.createTypeError(causeMsg, element, cause));
        this.element = element;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static TypeErrorImpl createTypeError(@NotNull Msg msg, @NotNull DefaultElement element, @Nullable Exception exception) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.createTypeError must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.createTypeError must not be null");
        }
        Msg shortMsg = SaxTypeBuildException.appendLineNumber(msg, element);
        String resourcePath = SaxTypeBuildException.getResourcePath(element);
        String tagName = SaxTypeBuildException.tagName(element);
        int line = SaxTypeBuildException.getLine(element);
        ErrorMsg logMsg = element instanceof WsdlElement ? ProjectCatalogMsg.WSDL_RESOURCE_COULD_NOT_BE_LOADED(resourcePath, tagName, line, SaxTypeBuildException.getCause(msg)) : ProjectCatalogMsg.XSD_RESOURCE_COULD_NOT_BE_LOADED(resourcePath, tagName, line, SaxTypeBuildException.getCause(msg));
        TypeErrorImpl typeErrorImpl = TypeErrorImpl.create((Msg)shortMsg, (ErrorMsg)logMsg, (Exception)exception);
        if (typeErrorImpl == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.createTypeError must not return null");
        }
        return typeErrorImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String tagName(@Nullable DefaultElement element) {
        String result = "undefined";
        if (element != null) {
            String tagname = element.getTagName();
            result = tagname != null ? tagname : result;
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.tagName must not return null");
        }
        return string;
    }

    private static int getLine(@Nullable DefaultElement element) {
        int result = -1;
        if (element != null) {
            result = element.getLine();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Msg appendLineNumber(@NotNull Msg msg, @NotNull DefaultElement element) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.appendLineNumber must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.appendLineNumber must not be null");
        }
        String result = SaxTypeBuildException.getCause(msg);
        result = "Line " + element.getLine() + ": " + result;
        Msg msg2 = Msg.QUOTE((String)result);
        if (msg2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.appendLineNumber must not return null");
        }
        return msg2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getCause(@NotNull Msg msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.getCause must not be null");
        }
        String result = msg instanceof ErrorMsg ? ((ErrorMsg)msg).getCause() : msg.toString();
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.getCause must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getResourcePath(@NotNull DefaultElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.getResourcePath must not be null");
        }
        URL url = SaxTypeBuildException.getResourceUrl(element);
        String result = "unknown";
        if (url != null) {
            result = SaxTypeBuildException.relativePathFromUrl(url);
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.getResourcePath must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static URI resourceUri(@NotNull DefaultElement element) {
        URI result;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.resourceUri must not be null");
        }
        URL url = SaxTypeBuildException.getResourceUrl(element);
        if (url != null) {
            try {
                result = url.toURI();
            }
            catch (URISyntaxException e) {
                result = SaxTypeBuildException.findValidUri(element);
            }
        } else {
            result = SaxTypeBuildException.findValidUri(element);
        }
        URI uRI = result;
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.resourceUri must not return null");
        }
        return uRI;
    }

    private static URI findValidUri(DefaultElement element) {
        URI result;
        try {
            String label = element.getTagName();
            label = !Str.isEmpty((String)label) ? label.replace(" ", "") : "CannotFindValidUri";
            result = new URI(label);
        }
        catch (URISyntaxException e1) {
            throw new IllegalStateException("Cannot find valid uri to element", e1);
        }
        return result;
    }

    @Nullable
    private static URL getResourceUrl(@NotNull DefaultElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/SaxTypeBuildException.getResourceUrl must not be null");
        }
        URL url = null;
        if (element instanceof WsdlElement) {
            ServiceDefinition serviceDefinition = element.findAncestorByClass(ServiceDefinition.class);
            if (serviceDefinition != null) {
                url = serviceDefinition.getLocation();
            }
        } else {
            Schema schema = element.findAncestorByClass(Schema.class);
            if (schema != null) {
                url = schema.getLocation();
            }
        }
        return url;
    }
}

