/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.List;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.exception.MessageNotFoundException;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.type.Argument;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class Output
extends WsdlElement {
    private Message msg;

    public Output() {
        this.setTagName("output");
    }

    public String getMessage() {
        return this.getAttribute("message");
    }

    public void setMessage(String message) {
        this.setAttribute("message", message);
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        String msgId = this.getMessage();
        URL location = this.getServiceDefinition().getLocation();
        if (msgId == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("message", "output"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Argument> buildBpmObjectArguments() throws TypeBuildException {
        List<Argument> args = this.msg.buildBpmObjectArguments();
        for (Argument arg : args) {
            arg.setModifiers(arg.getModifiers() | 2L);
        }
        List<Argument> list = args;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Output.buildBpmObjectArguments must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<Argument> buildArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Output.buildArguments must not be null");
        }
        String msgId = this.getMessage();
        this.msg = this.getServiceDefinition().getMessage(msgId);
        if (this.msg == null) {
            throw new MessageNotFoundException(this, msgId, operation);
        }
        List<Argument> args = this.msg.buildArguments();
        if (args.size() == 1) {
            Argument argument = args.get(0);
            String typeName = argument.getTypeRef().getName();
            argument.setName(Identifier.argument((String)typeName));
        }
        this.makeOutArgs(args);
        List<Argument> list = args;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Output.buildArguments must not return null");
        }
        return list;
    }

    void setMsg(Message msg) {
        this.msg = msg;
    }

    Message getMsg() {
        return this.msg;
    }

    @Override
    void bind(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Output.bind must not be null");
        }
        super.bindOutput(operation);
    }

    private void makeOutArgs(@NotNull List<Argument> args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Output.makeOutArgs must not be null");
        }
        for (Argument arg : args) {
            arg.setModifiers(arg.getModifiers() | 2L);
            String name = arg.getName();
            int length = name.length();
            if (!name.startsWith("get") || length <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            name = Identifier.argument((String)name.substring(3));
            arg.setName(name);
        }
    }
}

