/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.msg;

import javax.xml.namespace.QName;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCatalogMsg
extends MsgBundle {
    public static TMsg WSDL_ALREADY_IMPORTED = ProjectCatalogMsg.tmsg((String)"URL '%0' was already imported");
    public static TMsg CANNOT_FIND_DECL = ProjectCatalogMsg.tmsg((String)"Cannot find namespace declaration for prefix '%0'");
    public static TMsg IMPORT_COULD_NOT_BE_PARSED = ProjectCatalogMsg.tmsg((String)"Resource could not be parsed: '%0'.");
    public static TMsg ELEMENT_COULD_NOT_BE_RESOLVED = ProjectCatalogMsg.tmsg((String)"Element '%0' could not be found.");
    public static TMsg ENCODING_NOT_SUPPORTED = ProjectCatalogMsg.tmsg((String)"Encoding '%0' is not supported.");
    public static TMsg MISSING_ATTRIBUTE = ProjectCatalogMsg.tmsg((String)"Missing attribute '%0' for tag '%1'.");
    private static final TMsg UNSUPPORTED_SERVICE_TYPE = ProjectCatalogMsg.tmsg((String)"Unsupported service type. Service: '%0' of type: '%1'.");
    private static final TErrorMsg MISSING_BPMO_SCRIPT = ProjectCatalogMsg.tErrorMsg((String)"Missing script for operation '%1'.", (String)"The %(BPM_OBJECT) '%0' cannot be correctly loaded because operation '%0' has not script", (String)"Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TMsg MISSING_SERVICE = ProjectCatalogMsg.tmsg((String)"Service '%0' cannot be found.");
    private static final TMsg UNSUPPORTED_TYPE = ProjectCatalogMsg.tmsg((String)"Unsupported type: '%0'");
    public static TMsg MESSAGE_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Wsdl message '%0' for operation '%1' not found.");
    public static TMsg OP_OVERLOADED = ProjectCatalogMsg.tmsg((String)"Operation '%0' is overloaded. Operation name overloading in a wsdl:portType is not WS-I compliant. ");
    public static Msg WSDL_BUILDER_ERROR = ProjectCatalogMsg.msg((String)"Wsdl could not be generated");
    private static final TErrorMsg INVALID_BPMO_NAMESPACE = ProjectCatalogMsg.tErrorMsg((String)"Invalid %(BPM_OBJECT) Namespace: %0", (String)"The %(BPM_OBJECT) namespace '%0' does not exists in context", (String)"Please verify that the %(BPM_OBJECT) wsdl and xsd are valid");
    private static final TErrorMsg DELEGATED_SERVICE_NOT_FOUND = ProjectCatalogMsg.tErrorMsg((String)"Unable to load operation '%0'", (String)"The service definition '%1' does not exist in this project or it is corrupted", (String)"Please verify that the definition exists in the composite and is valid");
    private static final TErrorMsg MISSING_BPMO_SCHEMA = ProjectCatalogMsg.tErrorMsg((String)"Unable to load %(BPM_OBJECT) '%1'", (String)"The element or type '%0' represented by %(BPM_OBJECT) does not exist in this project or it is corrupted", (String)"Please verify that the schema exists and is valid");
    private static final TErrorMsg UNEXPECTED_PARSER_ERROR = ProjectCatalogMsg.tErrorMsg((String)"Unexpected error parsing '%0'", (String)"%1", (String)"Verify that file is valid and accessible");
    private static final TErrorMsg UNEXPECTED_TYPEBUILD_ERROR = ProjectCatalogMsg.tErrorMsg((String)"Unexpected error build types for '%0'", (String)"%1", (String)"Verify that file is valid and accessible");
    private static final TErrorMsg INVALID_BPMO_FORMAT = ProjectCatalogMsg.tErrorMsg((String)"Unable to load %(BPM_OBJECT) '%0'", (String)"The %(BPM_OBJECT) format is invalid or it is corrupted", (String)"Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TErrorMsg INVALID_BPMO_OPERATION = ProjectCatalogMsg.tErrorMsg((String)"Unable to load %(BPM_OBJECT)", (String)"The '%0' operation is invalid", (String)"Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TErrorMsg MISSING_DELEGATED_OPERATION = ProjectCatalogMsg.tErrorMsg((String)"Unable to load operation '%0'", (String)"Unable to find an operation named '%1' on the delegated service", (String)"Please check that the delegated operation exists on the service.");
    private static final TErrorMsg MISSING_OPERATION = ProjectCatalogMsg.tErrorMsg((String)"Unable to load operation '%0'", (String)"Cannot find binding for operation named '%0' on the delegated service", (String)"Please check that the delegated operation exists on the service.");
    private static final TErrorMsg MISSING_BPMO_BINDING = ProjectCatalogMsg.tErrorMsg((String)"Unable to load %(BPM_OBJECT) '%0'", (String)"Cannot find binding in %(BPM_OBJECT)", (String)"The %(BPM_OBJECT) is invalid. It must be regenerated");
    private static final TErrorMsg MISSING_BPMO_PORT = ProjectCatalogMsg.tErrorMsg((String)"Unable to load %(BPM_OBJECT) '%0'", (String)"Cannot find port in %(BPM_OBJECT)", (String)"The %(BPM_OBJECT) is invalid. It must be regenerated");
    private static final TErrorMsg MISSING_DELEGATED_OPERATION_NAME = ProjectCatalogMsg.tErrorMsg((String)"Cannot find right name to the operation in %(BPM_OBJECT) %0", (String)"Unable to find the operation's right name on the delegated service", (String)"Please check that the delegated operation exists on the service.");
    private static final TErrorMsg NONMATCHING_DUPLICATED_SCHEMA = ProjectCatalogMsg.tErrorMsg((String)"Unable to load resource '%0' referenced by '%1'", (String)"Resource cannot be loaded because an element/type with qname '%2' already exists in '%3' and they differ", (String)"Please check the resources for duplicated elements/types.");
    private static final TErrorMsg DUPLICATED_PORTTYPE = ProjectCatalogMsg.tErrorMsg((String)"Unable to load resource '%0'", (String)"Resource cannot be loaded because a portType with qname '%1' already exists in '%2'", (String)"Please check the resources for duplicated portTypes.");
    private static final TErrorMsg CANNOT_PARSE_BUINESS_RULE = ProjectCatalogMsg.tErrorMsg((String)"Unable to parse business rule '%0'", (String)"%1", (String)"Please check that the business rule is valid.");
    private static final TErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT = ProjectCatalogMsg.tErrorMsg((String)"Unable to build types for business rule '%0'", (String)"The argument '%2' of decision function '%1' could not be build becasue of '%3'.", (String)"Please check the XML-Schema of the function arguments.");
    private static final TErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME = ProjectCatalogMsg.tErrorMsg((String)"Unable to identify the parameter QName", (String)"'%0'", (String)"Make sure that the decision function parameter is of XML type and exactly one XML Schema Element exists that represents the parameter");
    private static final TErrorMsg CANNOT_PARSE_EVENT_DEFINITION = ProjectCatalogMsg.tErrorMsg((String)"Unable to parse event definition '%0'", (String)"%1", (String)"Please check that the event definition is valid.");
    private static final TErrorMsg CANNOT_PARSE_COMPOSITE = ProjectCatalogMsg.tErrorMsg((String)"Unable to parse the composite", (String)"%0", (String)"Please check that the composite is valid.");
    private static final TErrorMsg CANNOT_PARSE_HUMANTASK = ProjectCatalogMsg.tErrorMsg((String)"Unable to parse the human task '%0'", (String)"%1", (String)"Please check that the human task is valid.");
    private static final TErrorMsg DUPLICATED_TYPENAME = ProjectCatalogMsg.tErrorMsg((String)"Unable to load resource '%0'", (String)"Resource cannot be loaded because an object with name '%1' already exists and was created by '%2'", (String)"Please check the resources for duplicates.");
    private static final TErrorMsg NONMATCHING_ARGS_DELEGATED_OPERATION = ProjectCatalogMsg.tErrorMsg((String)"Unable to load operation '%0'", (String)"The operation arguments do not match with delegated operation '%1' on the delegated service", (String)"Please check if the arguments have changed");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_TARGET = ProjectCatalogMsg.tErrorMsg((String)"Customized service '%0' has not a Service target property", (String)"Customized service wsdl is invalid", (String)"Recreate the customized service");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_PORT = ProjectCatalogMsg.tErrorMsg((String)"Customized service '%0' has not a Port Type property", (String)"Customized service wsdl is invalid", (String)"Recreate the customized service");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_NAMESPACE = ProjectCatalogMsg.tErrorMsg((String)"Customized service '%0' has not a Namespace property", (String)"Customized service wsdl is invalid", (String)"Recreate the customized service");
    private static final TMsg CANNOT_FIND_VFILE = ProjectCatalogMsg.tmsg((String)"Cannot find vfile for: '%0'.");
    private static final TMsg ERROR_UPDATING_COMPOSITE = ProjectCatalogMsg.tmsg((String)"Unexpected error updating composite for process '%0'.\nReason:\n%1\nCall Trace:\n%2");
    private static final TMsg MALFORMED_URI = ProjectCatalogMsg.tmsg((String)"Invalid URI '%0'");
    private static final TMsg MISSINGTYPEEXCEPTION = ProjectCatalogMsg.tmsg((String)"Invalid type '%0' with id '%1'");
    private static final TMsg ATTR_GROUP_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Attribute group '%0' not found at '%1'.");
    private static final TMsg ATTR_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Attribute '%0' not found at '%1'.");
    private static final TMsg ELEM_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Element '%0' not found at '%1'.");
    private static final TMsg GROUP_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Group '%0' not found at '%1'.");
    private static final TMsg INV_ATTR_VALUE = ProjectCatalogMsg.tmsg((String)"Invalid value: '%0' for attribute '%1' of element '%2'.");
    private static final TMsg INV_LOCAL_NAME = ProjectCatalogMsg.tmsg((String)"Name '%0' is not a valid local name.");
    private static final TMsg INV_ROOT = ProjectCatalogMsg.tmsg((String)"The specified XML is not a valid XML schema. The root element must be <schema> and not '%0'.'");
    private static final TMsg NS_NOT_DECL = ProjectCatalogMsg.tmsg((String)"The namespace for prefix '%0' is not declared.");
    private static final TMsg TYPE_NOT_FOUND = ProjectCatalogMsg.tmsg((String)"Type '%0' not found in namespace '%1'.");
    private static final TErrorMsg SERVICE_NOT_FOUND = ProjectCatalogMsg.tErrorMsg((String)"Type '%0', the composite.xml has an invalid service reference", (String)"The specified service was not found in the composite.xml", (String)"Verify that all services references are correct");
    private static final TMsg ERROR = ProjectCatalogMsg.tmsg((String)"Error: '%0'");
    private static final TMsg WARNING = ProjectCatalogMsg.tmsg((String)"Warning: '%0'");
    private static final TMsg SOAP_ENCODING_ARRAY_WARNING = ProjectCatalogMsg.tmsg((String)"It is not recommended the usage of SOAP encoding array types, specially if you are working with document/literal WSDLs (complex type name: %0 in namespace: %1 )");
    public static Msg MISSING_NAME_OR_REF = ProjectCatalogMsg.msg((String)"Missing the 'name' or 'ref' attribute.");
    private static final TMsg INVALID_SCHEMA_ELEMENT = ProjectCatalogMsg.tmsg((String)"Invalid schema element '%0'");
    public static TErrorMsg CORRUPTED_CONTENT_MALFORMED_RESOURCE = ProjectCatalogMsg.tErrorMsg((String)"Resource file '%0' could not be parsed", (String)"%1", (String)"Fix the Resource to continue");
    public static Msg SEQUENCE_WITH_RESTRICTION_NOT_SUPPORTED = ProjectCatalogMsg.msg((String)"The sequence structure with maxOccurs or minOccurs is not supported.");
    private static final TMsg INVALID_LOCATION = ProjectCatalogMsg.tmsg((String)"Invalid location: '%0' ");
    public static Msg ERROR_LOADING_COMPOSITE_DATA = ProjectCatalogMsg.msg((String)"Error loading composite data.");
    private static final TMsg CANNOT_LOAD_JDEV_PROJECT = ProjectCatalogMsg.tmsg((String)"Cannot load Jdev project for BPM Project: '%0'");
    private static final TErrorMsg WSDL_RESOURCE_COULD_NOT_BE_LOADED = ProjectCatalogMsg.tErrorMsg((String)"WSDL '%0' could not be loaded due to an error parsing the XML tag '%1' defined at line '%2'", (String)"%3", (String)"Fix the WSDL to continue");
    private static final TErrorMsg XSD_RESOURCE_COULD_NOT_BE_LOADED = ProjectCatalogMsg.tErrorMsg((String)"Xml Schema '%0' could not be loaded due to an error parsing the XML tag '%1' defined at line '%2'", (String)"%3", (String)"Fix the Xml Schema to continue");
    private static final TErrorMsg UNEXPECTED_IO_ERROR = ProjectCatalogMsg.tErrorMsg((String)"Unexpected error when loading resource '%0'", (String)"The specified resource could not be loaded", (String)"Check logs for more detail");
    private static final TErrorMsg FAULT_WITHOUT_ERRORINFO = ProjectCatalogMsg.tErrorMsg((String)"The Exception '%0' doesn't have the errorInfo attribute", (String)"The specified exception is not valid", (String)"Check the attribute of the exception and add the only errorInfo attribute");
    public static TErrorMsg RESOURCE_COULD_NOT_BE_PARSED = ProjectCatalogMsg.tErrorMsg((String)"Resource '%0' could not be parsed.", (String)"%1", (String)"Check the logs for more details");
    private static final TErrorMsg FAULT_INVALID_CONTENT = ProjectCatalogMsg.tErrorMsg((String)"The Exception '%0' has more than one attribute", (String)"The specified exception is not valid", (String)"Check the attribute of the exception and add only the errorInfo attribute");
    public static final Msg XML_ELEMENT = ProjectCatalogMsg.msg((String)"XML Schema Element", (String)"", (String)"xml_element_16X16.png");
    public static final Msg XML_COMPLEX_TYPE = ProjectCatalogMsg.msg((String)"XML Schema Complex Type", (String)"", (String)"xml_complexType_16X16.png");
    public static final Msg XML_ENUM = ProjectCatalogMsg.msg((String)"XML Schema Enumeration", (String)"", (String)"xml_enumeration_16X16.png");
    public static final Msg XML = ProjectCatalogMsg.msg((String)"XML Schema", (String)"", (String)"xml_element_16X16.png");
    public static final Msg EVENT = ProjectCatalogMsg.msg((String)"Event", (String)"", (String)"event_16X16.png");
    public static final Msg CORRUPTED_RESOURCE = ProjectCatalogMsg.msg((String)"Corrupted Resource", (String)"", (String)"corrupted_resource_16X16.gif");

    public static ErrorMsg INVALID_BPMO_NAMESPACE(String _arg0) {
        return INVALID_BPMO_NAMESPACE.args(new Object[]{_arg0});
    }

    public static ErrorMsg DELEGATED_SERVICE_NOT_FOUND(String _arg0, String _arg1) {
        return DELEGATED_SERVICE_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static ErrorMsg MISSING_BPMO_SCHEMA(QName _arg0, String _arg1) {
        return MISSING_BPMO_SCHEMA.args(new Object[]{_arg0, _arg1});
    }

    public static ErrorMsg UNEXPECTED_PARSER_ERROR(String uri, String cause) {
        return UNEXPECTED_PARSER_ERROR.args(new Object[]{uri, cause});
    }

    public static ErrorMsg UNEXPECTED_TYPEBUILD_ERROR(String uri, String cause) {
        return UNEXPECTED_TYPEBUILD_ERROR.args(new Object[]{uri, cause});
    }

    public static ErrorMsg INVALID_BPMO_FORMAT(String name) {
        return INVALID_BPMO_FORMAT.args(new Object[]{name});
    }

    public static ErrorMsg INVALID_BPMO_OPERATION(String operationName) {
        return INVALID_BPMO_OPERATION.args(new Object[]{operationName});
    }

    public static ErrorMsg NONMATCHING_DUPLICATED_SCHEMA(@NotNull String failedResourceUri, @NotNull String failedResourceDep, @NotNull QName qName, @Nullable String originPath) {
        if (failedResourceUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        if (failedResourceDep == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        return NONMATCHING_DUPLICATED_SCHEMA.args(new Object[]{failedResourceUri, failedResourceDep, qName, originPath});
    }

    public static ErrorMsg DUPLICATED_PORTTYPE(String _arg0, QName _arg1, String _arg2) {
        return DUPLICATED_PORTTYPE.args(new Object[]{_arg0, _arg1, _arg2});
    }

    public static ErrorMsg CANNOT_PARSE_BUINESS_RULE(String uri, String cause) {
        return CANNOT_PARSE_BUINESS_RULE.args(new Object[]{uri, cause});
    }

    public static ErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT(String uri, String funcName, String argName, String sdkMsg) {
        return CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT.args(new Object[]{uri, funcName, argName, sdkMsg});
    }

    public static ErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME(String arg) {
        return CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME.args(new Object[]{arg});
    }

    public static ErrorMsg CANNOT_PARSE_EVENT_DEFINITION(String uri, String cause) {
        return CANNOT_PARSE_EVENT_DEFINITION.args(new Object[]{uri, cause});
    }

    public static ErrorMsg CANNOT_PARSE_COMPOSITE(String cause) {
        return CANNOT_PARSE_COMPOSITE.args(new Object[]{cause});
    }

    public static ErrorMsg CANNOT_PARSE_HUMANTASK(String uri, String cause) {
        return CANNOT_PARSE_HUMANTASK.args(new Object[]{uri, cause});
    }

    public static ErrorMsg DUPLICATED_TYPENAME(String _arg0, String _arg1, String _arg2) {
        return DUPLICATED_TYPENAME.args(new Object[]{_arg0, _arg1, _arg2});
    }

    public static ErrorMsg MISSING_DELEGATED_OPERATION(String _arg0, String _arg1) {
        return MISSING_DELEGATED_OPERATION.args(new Object[]{_arg0, _arg1});
    }

    public static ErrorMsg MISSING_OPERATION(String operationName) {
        return MISSING_OPERATION.args(new Object[]{operationName});
    }

    public static ErrorMsg MISSING_BPMO_PORT(String bpmObjectName) {
        return MISSING_BPMO_PORT.args(new Object[]{bpmObjectName});
    }

    public static ErrorMsg MISSING_BPMO_BINDING(String bpmObjectName) {
        return MISSING_BPMO_BINDING.args(new Object[]{bpmObjectName});
    }

    public static ErrorMsg NONMATCHING_ARGS_DELEGATED_OPERATION(String _arg0, String _arg1) {
        return NONMATCHING_ARGS_DELEGATED_OPERATION.args(new Object[]{_arg0, _arg1});
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_TARGET(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_TARGET.args(new Object[]{bpmObject});
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_PORT(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_PORT.args(new Object[]{bpmObject});
    }

    public static ErrorMsg MISSING_DELEGATED_OPERATION_NAME(String bpmObject) {
        return MISSING_DELEGATED_OPERATION_NAME.args(new Object[]{bpmObject});
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_NAMESPACE(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_NAMESPACE.args(new Object[]{bpmObject});
    }

    public static Msg UNSUPPORTED_SERVICE_TYPE(String text, String componentType) {
        return UNSUPPORTED_SERVICE_TYPE.args(new Object[]{text, componentType});
    }

    public static ErrorMsg CORRUPTED_CONTENT_MALFORMED_RESOURCE(@NotNull String uri, @NotNull String cause) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.CORRUPTED_CONTENT_MALFORMED_RESOURCE must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.CORRUPTED_CONTENT_MALFORMED_RESOURCE must not be null");
        }
        return CORRUPTED_CONTENT_MALFORMED_RESOURCE.args(new Object[]{uri, cause});
    }

    public static ErrorMsg WSDL_RESOURCE_COULD_NOT_BE_LOADED(String location, String tagname, int line, String cause) {
        return WSDL_RESOURCE_COULD_NOT_BE_LOADED.args(new Object[]{location, tagname, line, cause});
    }

    public static ErrorMsg XSD_RESOURCE_COULD_NOT_BE_LOADED(String location, String tagname, int line, String cause) {
        return XSD_RESOURCE_COULD_NOT_BE_LOADED.args(new Object[]{location, tagname, line, cause});
    }

    public static Msg CANNOT_FIND_VFILE(String uri) {
        return CANNOT_FIND_VFILE.args(new Object[]{uri});
    }

    public static ErrorMsg UNEXPECTED_IO_ERROR(String _arg0) {
        return UNEXPECTED_IO_ERROR.args(new Object[]{_arg0});
    }

    public static ErrorMsg FAULT_WITHOUT_ERRORINFO(String _arg0) {
        return FAULT_WITHOUT_ERRORINFO.args(new Object[]{_arg0});
    }

    public static ErrorMsg FAULT_INVALID_CONTENT(String _arg0) {
        return FAULT_INVALID_CONTENT.args(new Object[]{_arg0});
    }

    public static Msg MALFORMED_URI(String _arg0) {
        return MALFORMED_URI.args(new Object[]{_arg0});
    }

    public static Msg MISSINGTYPEEXCEPTION(String name, String typeId) {
        return MISSINGTYPEEXCEPTION.args(new Object[]{name, typeId});
    }

    public static Msg ATTR_GROUP_NOT_FOUND(String _arg0, String _arg1) {
        return ATTR_GROUP_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static Msg ATTR_NOT_FOUND(String _arg0, String _arg1) {
        return ATTR_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static Msg ELEM_NOT_FOUND(String _arg0, String _arg1) {
        return ELEM_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static Msg GROUP_NOT_FOUND(String _arg0, String _arg1) {
        return GROUP_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static Msg INV_ATTR_VALUE(String _arg0, String _arg1, String _arg2) {
        return INV_ATTR_VALUE.args(new Object[]{_arg0, _arg1, _arg2});
    }

    public static Msg INV_LOCAL_NAME(String _arg0) {
        return INV_LOCAL_NAME.args(new Object[]{_arg0});
    }

    public static Msg INV_ROOT(String _arg0) {
        return INV_ROOT.args(new Object[]{_arg0});
    }

    public static Msg NS_NOT_DECL(String _arg0) {
        return NS_NOT_DECL.args(new Object[]{_arg0});
    }

    public static Msg TYPE_NOT_FOUND(String name, String namespace) {
        return TYPE_NOT_FOUND.args(new Object[]{name, namespace});
    }

    public static ErrorMsg SERVICE_NOT_FOUND(String serviceName) {
        return SERVICE_NOT_FOUND.args(new Object[]{serviceName});
    }

    public static Msg ERROR_UPDATING_COMPOSITE(String process, String exception, String trace) {
        return ERROR_UPDATING_COMPOSITE.args(new Object[]{process, exception, trace});
    }

    public static Msg ERROR(String _arg0) {
        return ERROR.args(new Object[]{_arg0});
    }

    public static Msg WARNING(String _arg0) {
        return WARNING.args(new Object[]{_arg0});
    }

    public static Msg UNSUPPORTED_TYPE(TypeDescription _arg0) {
        return UNSUPPORTED_TYPE.args(new Object[]{_arg0});
    }

    public static Msg SOAP_ENCODING_ARRAY_WARNING(String _arg0, String _arg1) {
        return SOAP_ENCODING_ARRAY_WARNING.args(new Object[]{_arg0, _arg1});
    }

    public static Msg CANNOT_FIND_DECL(String _arg0) {
        return CANNOT_FIND_DECL.args(new Object[]{_arg0});
    }

    public static Msg ENCODING_NOT_SUPPORTED(String _arg0) {
        return ENCODING_NOT_SUPPORTED.args(new Object[]{_arg0});
    }

    public static Msg ELEMENT_COULD_NOT_BE_RESOLVED(String qname) {
        return ELEMENT_COULD_NOT_BE_RESOLVED.args(new Object[]{qname});
    }

    public static Msg IMPORT_COULD_NOT_BE_PARSED(String location) {
        return IMPORT_COULD_NOT_BE_PARSED.args(new Object[]{location});
    }

    public static ErrorMsg RESOURCE_COULD_NOT_BE_PARSED(String location, String cause) {
        return RESOURCE_COULD_NOT_BE_PARSED.args(new Object[]{location, cause});
    }

    public static Msg MISSING_ATTRIBUTE(String _arg0, String _arg1) {
        return MISSING_ATTRIBUTE.args(new Object[]{_arg0, _arg1});
    }

    public static Msg MISSING_SERVICE(String _arg0) {
        return MISSING_SERVICE.args(new Object[]{_arg0});
    }

    public static ErrorMsg MISSING_BPMO_SCRIPT(String name, String operation) {
        return MISSING_BPMO_SCRIPT.args(new Object[]{name, operation});
    }

    public static Msg MESSAGE_NOT_FOUND(String _arg0, String _arg1) {
        return MESSAGE_NOT_FOUND.args(new Object[]{_arg0, _arg1});
    }

    public static Msg OP_OVERLOADED(String _arg0) {
        return OP_OVERLOADED.args(new Object[]{_arg0});
    }

    public static Msg WSDL_ALREADY_IMPORTED(String _arg0) {
        return WSDL_ALREADY_IMPORTED.args(new Object[]{_arg0});
    }

    public static Msg INVALID_LOCATION(@Nullable String location) {
        return INVALID_LOCATION.args(new Object[]{location == null ? "" : location});
    }

    public static Msg INVALID_SCHEMA_ELEMENT(String tagName) {
        return INVALID_SCHEMA_ELEMENT.args(new Object[]{tagName});
    }

    public static Msg CANNOT_LOAD_JDEV_PROJECT(String projectName) {
        return CANNOT_LOAD_JDEV_PROJECT.args(new Object[]{projectName});
    }

    static {
        ProjectCatalogMsg.init(ProjectCatalogMsg.class, (LogComponent)LogComponent.DEFAULT, (ErrorRange)ErrorRange.PROJECT_CATALOG);
    }
}

