/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.model.Path;
import oracle.rules.sdk2.datamodel.JaxbFactType;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuleDictionaryParsedObject
extends ParsedObject<RuleDictionary> {
    private Set<Dependency> dependencies;

    public RuleDictionaryParsedObject(@NotNull URI uri, @Nullable RuleDictionary parsedData) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/RuleDictionaryParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDependecies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/RuleDictionaryParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<Dependency> parseDependecies() throws TypeParseException {
        HashSet<String> sources = new HashSet<String>();
        TreeSet<Dependency> result = new TreeSet<Dependency>();
        List jaxbFactTypes = ((RuleDictionary)this.getParsedData()).getCombinedDataModel().getJaxbFactTypes();
        for (JaxbFactType jaxbFactType : jaxbFactTypes) {
            String source = jaxbFactType.getSource();
            if (source == null) continue;
            sources.add(source);
        }
        try {
            for (String source : sources) {
                URI uri;
                if (source.contains(":")) {
                    uri = new URI(source);
                } else {
                    VFile fromURI = URLHelper.getFromURI((URI)this.getUri());
                    assert (fromURI != null);
                    VFile vFile = fromURI.getFileSystem().createFile(source);
                    if (!vFile.exists()) {
                        String xsdFolder = Path.XSD.getName() + '/';
                        vFile = fromURI.getFileSystem().createFile(xsdFolder + source);
                        if (!vFile.exists()) continue;
                    }
                    uri = vFile.toURL().toURI();
                }
                result.add(new Dependency(uri, ResourceType.XML_SCHEMA));
            }
        }
        catch (URISyntaxException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (IOException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        TreeSet<Dependency> treeSet = result;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/RuleDictionaryParsedObject.parseDependecies must not return null");
        }
        return treeSet;
    }
}

