/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.model.TRuleEngineRepository;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeParsedObject
extends ParsedObject<CompositeInfo> {
    private Set<Dependency> dependencies;

    public CompositeParsedObject(@NotNull URI uri, @Nullable CompositeInfo parsedData) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDepedencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<Dependency> parseDepedencies() throws TypeParseException {
        HashSet<Dependency> result = new HashSet<Dependency>();
        CompositeInfo controller = (CompositeInfo)this.getParsedData();
        try {
            for (CompositeComponent component : controller.getComponents()) {
                CompositeServiceType type = component.getComponentType();
                if (CompositeServiceType.BUSINESS_RULE.equals((Object)type)) {
                    this.addRuleDependencies(this.getUri(), result, component);
                    continue;
                }
                if (CompositeServiceType.HUMAN_TASK.equals((Object)type)) {
                    this.addHumanTaskDependencies(result, component);
                    continue;
                }
                if (CompositeServiceType.BPMN.equals((Object)type)) continue;
                this.addInterfaceDependencies(result, component.getServices());
            }
            this.addInterfaceDependencies(result, this.filterInterfaces(controller.getReferences()));
            this.addInterfaceDependencies(result, this.filterInterfaces(controller.getServices()));
            this.addImportsDependencies(result, controller.getImports());
        }
        catch (URISyntaxException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (IOException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        HashSet<Dependency> hashSet = result;
        if (hashSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.parseDepedencies must not return null");
        }
        return hashSet;
    }

    private void addImportsDependencies(@NotNull Set<Dependency> result, @NotNull Iterable<CompositeImport> imports) throws IOException, URISyntaxException {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addImportsDependencies must not be null");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addImportsDependencies must not be null");
        }
        for (CompositeImport compositeImport : imports) {
            if (compositeImport.getImportType() == ResourceType.WSDL) continue;
            URI location = URLHelper.createFrom((URI)this.getUri(), (String)compositeImport.getLocation());
            result.add(new Dependency(location, compositeImport.getImportType()));
        }
    }

    private Iterable<CompositeInterface> filterInterfaces(@NotNull Iterable<CompositeInterface> compositeInterfaces) {
        if (compositeInterfaces == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.filterInterfaces must not be null");
        }
        ArrayList<CompositeInterface> result = new ArrayList<CompositeInterface>();
        for (CompositeInterface compositeInterface : compositeInterfaces) {
            CompositeServiceType catalogServiceType = compositeInterface.getComponentType();
            if (!CompositeServiceType.WEB_SERVICE.equals((Object)catalogServiceType)) continue;
            result.add(compositeInterface);
        }
        return result;
    }

    private void addHumanTaskDependencies(Set<Dependency> result, CompositeComponent component) throws IOException, URISyntaxException {
        String location = component.getSrcLocation();
        if (location != null) {
            URI humanTaskUri = URLHelper.createFrom((URI)this.getUri(), (String)location);
            result.add(new Dependency(humanTaskUri, ResourceType.HUMAN_TASK));
        }
    }

    private void addRuleDependencies(URI uri, Set<Dependency> result, CompositeComponent component) throws IOException, URISyntaxException {
        DecisionServices decisionServices;
        URI dec;
        VFile vfile;
        String location = component.getSrcLocation();
        if (location != null && (vfile = URLHelper.getFromURI((URI)(dec = URLHelper.createFrom((URI)this.getUri(), (String)location)))) != null && (decisionServices = this.loadDecisionServices(vfile)) != null) {
            List engineProviders = decisionServices.getRuleEngineProviders();
            for (TRuleEngineProvider engine : engineProviders) {
                TRuleEngineRepository ruleEngineRepository = engine.getRepository();
                String path = ruleEngineRepository.getPath();
                String relativePath = path.substring(path.indexOf("/") + 1, path.length());
                URI ruleUri = URLHelper.createFrom((URI)uri, (String)relativePath);
                result.add(new Dependency(ruleUri, ResourceType.BUSINESS_RULE));
            }
        }
    }

    private void addInterfaceDependencies(Set<Dependency> result, Iterable<CompositeInterface> compositeInterface) throws URISyntaxException {
        for (CompositeInterface ref : compositeInterface) {
            URL location = ref.getLocation();
            URI uri = location.toURI();
            result.add(new Dependency(uri, ResourceType.WSDL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private DecisionServices loadDecisionServices(@NotNull VFile decsFile) {
        BufferedInputStream is;
        DecisionServices services;
        block7: {
            if (decsFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.loadDecisionServices must not be null");
            }
            services = null;
            is = null;
            try {
                if (!decsFile.exists()) break block7;
                RuleEngineFactory factory = RuleEngineFactory.getInstance();
                Unmarshaller unmarshaller = factory.createUnmarshaller();
                is = new BufferedInputStream((InputStream)new VFileInputStream(decsFile));
                services = (DecisionServices)unmarshaller.unmarshal((InputStream)is);
            }
            catch (IOException e) {
                services = null;
                StreamUtils.close((Closeable[])new Closeable[]{is});
            }
            catch (JAXBException e2) {
                services = null;
                {
                    catch (Throwable throwable) {
                        StreamUtils.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                }
                StreamUtils.close((Closeable[])new Closeable[]{is});
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{is});
        return services;
    }
}

