/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.rules.sdk2.dictionary.AbstractDictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import oracle.rules.sdk2.repository.DictionaryFQN;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFileSystemDictionaryFinder
extends AbstractDictionaryFinder {
    private final VFileSystem vFileSystem;
    private static final long serialVersionUID = -7455769574529354052L;

    public VFileSystemDictionaryFinder(@NotNull VFileSystem vFileSystem, @Nullable DictionaryFinder parentFinder) {
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/VFileSystemDictionaryFinder.<init> must not be null");
        }
        super(parentFinder);
        this.vFileSystem = vFileSystem;
    }

    public RuleDictionary findDictionaryWithThisFinder(DictionaryFQN fqn) {
        String fullPath = "oracle/rules/" + fqn.asPath();
        RuleDictionary rd = this.searchProject(fullPath);
        if (rd == null) {
            // empty if block
        }
        return rd;
    }

    private RuleDictionary searchProject(String fullPath) {
        RuleDictionary rd = null;
        VFile file = this.vFileSystem.createFile(fullPath);
        try {
            if (file.exists()) {
                rd = this.readDictionary(file.openInputStream());
            }
        }
        catch (IOException e) {
            Log.logDebug((Throwable)e);
        }
        return rd;
    }

    private RuleDictionary searchMDS(String fullPath) {
        RuleDictionary rd = null;
        try {
            URL url = new URL("oramds:/apps/" + fullPath);
            rd = this.readDictionary(url.openStream());
        }
        catch (MalformedURLException e) {
            Log.logSevere((Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleDictionary readDictionary(@NotNull InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/VFileSystemDictionaryFinder.readDictionary must not be null");
        }
        RuleDictionary rd = null;
        try {
            rd = RuleDictionary.readDictionary((Reader)new InputStreamReader(is), (DictionaryFinder)this);
        }
        catch (IOException e) {
            Log.logDebug((Throwable)e);
        }
        catch (SDKException e) {
            Log.logDebug((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return rd;
    }
}

