/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.TypeLoader;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeLoaderRegistry {
    private HashMap<ResourceType, TypeLoader<?>> typeLoaders;

    private TypeLoaderRegistry() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeLoaderRegistry create(@NotNull TypeIndex finder, @NotNull VFileSystem fileSystem, @NotNull ComponentCatalog catalog, @Nullable CompositeAccessor controller) {
        if (finder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        TypeLoaderRegistry result = new TypeLoaderRegistry();
        result.init(finder, fileSystem, catalog, controller);
        TypeLoaderRegistry typeLoaderRegistry = result;
        if (typeLoaderRegistry == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not return null");
        }
        return typeLoaderRegistry;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeLoaderRegistry create(@NotNull TypeIndex finder, @NotNull VFileSystem fileSystem, @NotNull ComponentCatalog catalog) {
        if (finder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not be null");
        }
        TypeLoaderRegistry typeLoaderRegistry = TypeLoaderRegistry.create(finder, fileSystem, catalog, null);
        if (typeLoaderRegistry == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.create must not return null");
        }
        return typeLoaderRegistry;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeLoader get(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.get must not be null");
        }
        TypeLoader<?> typeLoader = this.typeLoaders.get((Object)type);
        if (typeLoader == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.get must not return null");
        }
        return typeLoader;
    }

    public boolean isTypeSupported(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.isTypeSupported must not be null");
        }
        return this.typeLoaders.containsKey((Object)type);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<String, TypeDescription> defaultModules() {
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        Collection<TypeLoader<?>> typeLoaders = this.typeLoaders.values();
        for (TypeLoader<?> typeLoader : typeLoaders) {
            Collection<TypeDescription> types = typeLoader.buildCommonTypes();
            for (TypeDescription td : types) {
                String typesName = td.getText();
                result.put(typesName, td);
            }
        }
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.defaultModules must not return null");
        }
        return hashMap;
    }

    private void init(@NotNull TypeIndex typeFinder, @NotNull VFileSystem fileSystem, @NotNull ComponentCatalog catalog, @Nullable CompositeAccessor controller) {
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.init must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.init must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.init must not be null");
        }
        this.typeLoaders = new HashMap();
        List factories = Platform.getExtensionService().getExtensionsByPoint(TypeLoaderMetadata.class);
        for (Extension factory : factories) {
            try {
                TypeLoaderMetadata metadata = (TypeLoaderMetadata)factory.getMetadata();
                ResourceType resourceType = metadata.resourceType();
                Class aClass = Cast.toClass(TypeLoader.class, (Class)factory.instanceType());
                Constructor constructor = aClass.getConstructor(ComponentCatalog.class, VFileSystem.class, TypeIndex.class);
                TypeLoader typeLoader = (TypeLoader)constructor.newInstance(catalog, fileSystem, typeFinder);
                if (typeLoader instanceof AbstractTypeLoader) {
                    AbstractTypeLoader atl = (AbstractTypeLoader)typeLoader;
                    atl.setCompositeUri(this.buildCompositeUri(fileSystem));
                    if (controller != null) {
                        atl.setCompositeAccessor(controller);
                    }
                }
                this.typeLoaders.put(resourceType, typeLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException("Type loader could not be initialized.", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private URI buildCompositeUri(@NotNull VFileSystem fileSystem) {
        URI uRI;
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.buildCompositeUri must not be null");
        }
        VFile compositeVFile = fileSystem.createFile("/composite.xml");
        try {
            uRI = compositeVFile.toURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to build composite URI");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to build composite URI");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/TypeLoaderRegistry.buildCompositeUri must not return null");
        }
        return uRI;
    }
}

