/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.net.URI;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class Dependency
implements Comparable<Dependency> {
    private ResourceType resourceType;
    private URI uri;

    public Dependency(@NotNull URI uri, @NotNull ResourceType resourceType) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/Dependency.<init> must not be null");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/Dependency.<init> must not be null");
        }
        this.uri = uri;
        this.resourceType = resourceType;
    }

    public URI getUri() {
        return this.uri;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.resourceType == that.resourceType && this.uri.equals(that.uri);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }

    public String toString() {
        return this.resourceType.toString() + " " + this.uri.toString();
    }

    @Override
    public int compareTo(Dependency dependency) {
        return this.getUri().compareTo(dependency.getUri());
    }
}

