/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.net.URI;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.catalog.loaders.ResourceTypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.impl.TypeErrorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BusinessRuleTypeBuildException
extends ResourceTypeBuildException {
    private static final long serialVersionUID = 6138739963864716664L;

    public BusinessRuleTypeBuildException(@NotNull URI dictionaryUri, @NotNull String funcName, @NotNull String argName, @NotNull String sdkMsg) {
        if (dictionaryUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (funcName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (argName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (sdkMsg == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        super(dictionaryUri, (TypeError)BusinessRuleTypeBuildException.createTypeError(ProjectCatalogMsg.CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT(BusinessRuleTypeBuildException.relativePath(dictionaryUri), funcName, argName, sdkMsg), null));
    }

    public BusinessRuleTypeBuildException(@NotNull URI dictionaryUri, @NotNull String funcName, @NotNull String argName, @NotNull ErrorMsg errMsg) {
        if (dictionaryUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (funcName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (argName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        if (errMsg == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.<init> must not be null");
        }
        super(dictionaryUri, (TypeError)BusinessRuleTypeBuildException.createTypeError(ProjectCatalogMsg.CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT(BusinessRuleTypeBuildException.relativePath(dictionaryUri), funcName, argName, errMsg.toString()), null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static TypeErrorImpl createTypeError(@NotNull ErrorMsg msg, @Nullable TypeBuildException exception) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.createTypeError must not be null");
        }
        TypeErrorImpl typeErrorImpl = TypeErrorImpl.create((Msg)Msg.QUOTE((String)msg.getCause()), (ErrorMsg)msg, (Exception)((Object)exception));
        if (typeErrorImpl == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.createTypeError must not return null");
        }
        return typeErrorImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected static String relativePath(@NotNull URI uri) {
        String result;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.relativePath must not be null");
        }
        try {
            result = URLHelper.getResourceLocation((URI)uri);
        }
        catch (IOException e) {
            result = uri.toString();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/BusinessRuleTypeBuildException.relativePath must not return null");
        }
        return string;
    }
}

