/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.loaders.ErrorParsedObject;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeLoader;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.xsd.exception.UriConversionException;
import oracle.bpm.project.catalog.type.TypeLoadRuntimeException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTypeLoader<T>
implements TypeLoader<T> {
    protected CompositeAccessor compositeAccessor;
    protected URI compositeUri;
    protected TypeIndex typeFinder;
    private ComponentCatalog catalog;
    private VFileSystem fileSystem;

    protected AbstractTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.<init> must not be null");
        }
        this.catalog = catalog;
        this.typeFinder = typeFinder;
        this.fileSystem = fileSystem;
    }

    @Nullable
    public static VFile uriToVFile(@NotNull URI uri, boolean verify) throws UriConversionException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToVFile must not be null");
        }
        VFile vfile = null;
        String uriStr = uri.toString();
        if (uriStr.startsWith("vfile")) {
            try {
                vfile = URLHelper.getFromURI((URI)uri);
            }
            catch (IOException e) {
                throw new UriConversionException(uri, e);
            }
            if (vfile == null) {
                throw new UriConversionException(uri);
            }
        }
        if (verify && vfile == null) {
            throw new UriConversionException(uri);
        }
        return vfile;
    }

    public static void initResourceLocationData(@Nullable VFile vfile, @NotNull String resourcePath, @NotNull ObjectTypeDescription otd) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initResourceLocationData must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initResourceLocationData must not be null");
        }
        otd.setTransientProperty("resource_location", (Object)resourcePath);
        if (vfile != null) {
            VFile[] files = new VFile[]{vfile};
            otd.setTransientProperty("files", (Object)files);
        }
    }

    public static void initResourceLocationData(@NotNull URI uri, @NotNull ObjectTypeDescription otd) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initResourceLocationData must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initResourceLocationData must not be null");
        }
        VFile vfile = AbstractTypeLoader.uriToVFile(uri, false);
        String resourcePath = AbstractTypeLoader.uriToPath(uri);
        AbstractTypeLoader.initResourceLocationData(vfile, resourcePath, otd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public final ParsedObject<T> parse(@NotNull URI uri, @Nullable URI dependant) {
        ParsedObject<T> result;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.parse must not be null");
        }
        try {
            result = this.parseUri(uri);
        }
        catch (TypeParseException e) {
            result = ErrorParsedObject.create(uri, dependant, e);
        }
        ParsedObject<T> parsedObject = result;
        if (parsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.parse must not return null");
        }
        return parsedObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public final Map<String, TypeDescription> buildTypes(@NotNull ParsedObject<T> parsedObject) {
        Map<Object, Object> result;
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.buildTypes must not be null");
        }
        if (parsedObject instanceof ErrorParsedObject) {
            result = new HashMap();
            ErrorParsedObject errorParsedObject = (ErrorParsedObject)parsedObject;
            TypeDescription typeDescription = errorParsedObject.getErrorType();
            result.put(typeDescription.getName(), typeDescription);
        } else {
            try {
                result = this.loadTypes(parsedObject);
                this.initCommonTypeProperties(result.values(), parsedObject.getUri());
            }
            catch (RuntimeException e) {
                String resourceLocation;
                URI uri = parsedObject.getUri();
                try {
                    resourceLocation = URLHelper.getResourceLocation((URI)uri);
                    throw new TypeLoadRuntimeException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(resourceLocation), e);
                }
                catch (IOException e1) {
                    resourceLocation = uri.toString();
                }
                throw new TypeLoadRuntimeException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(resourceLocation), e);
            }
            catch (TypeBuildException e) {
                result = e.buildTypeErrors();
            }
        }
        Map<Object, Object> map = result;
        if (map == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.buildTypes must not return null");
        return map;
    }

    public void setCompositeAccessor(@NotNull CompositeAccessor compositeAccessor) {
        if (compositeAccessor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.setCompositeAccessor must not be null");
        }
        this.compositeAccessor = compositeAccessor;
    }

    public void setCompositeUri(@NotNull URI compositeUri) {
        if (compositeUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.setCompositeUri must not be null");
        }
        this.compositeUri = compositeUri;
    }

    @Override
    public boolean isStructuralDependant() {
        Class<?> aClass = this.getClass();
        TypeLoaderMetadata annotation = aClass.getAnnotation(TypeLoaderMetadata.class);
        return annotation.isStructural();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final Collection<TypeDescription> buildCommonTypes() {
        Class<?> aClass = this.getClass();
        TypeLoaderMetadata annotation = aClass.getAnnotation(TypeLoaderMetadata.class);
        String[] moduleNames = annotation.rootModules();
        ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
        if (moduleNames != null && moduleNames.length > 0) {
            for (String moduleName : moduleNames) {
                if (moduleName.isEmpty()) continue;
                ObjectTypeDescription module = new ObjectTypeDescription(moduleName);
                module.addModifier(0x100000000L);
                module.setCatalog(this.catalog);
                result.add((TypeDescription)module);
            }
        }
        ArrayList<TypeDescription> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.buildCommonTypes must not return null");
        }
        return arrayList;
    }

    @NotNull
    protected abstract ParsedObject<T> parseUri(@NotNull URI var1) throws TypeParseException;

    @NotNull
    protected abstract Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<T> var1) throws TypeBuildException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected static String uriToPath(@NotNull URI uri) throws TypeBuildException {
        String resourceLocation;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToPath must not be null");
        }
        try {
            resourceLocation = URLHelper.getResourceLocation((URI)uri);
        }
        catch (IOException e) {
            throw new UriConversionException(uri, e);
        }
        String string = resourceLocation;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToPath must not return null");
        }
        return string;
    }

    protected VFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected ComponentCatalog getCatalog() {
        return this.catalog;
    }

    protected final TypeIndex getTypeFinder() {
        return this.typeFinder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final VFile uriToVFile(@NotNull URI uri) throws UriConversionException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToVFile must not be null");
        }
        VFile vFile = AbstractTypeLoader.uriToVFile(uri, true);
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToVFile must not return null");
        }
        return vFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected final URL uriToUrl(URI uri) throws UriConversionException {
        URL location;
        try {
            location = URLHelper.toUrl((URI)uri);
        }
        catch (IOException e) {
            throw new UriConversionException(uri, e);
        }
        URL uRL = location;
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/AbstractTypeLoader.uriToUrl must not return null");
        }
        return uRL;
    }

    private void initCommonTypeProperties(@NotNull Collection<TypeDescription> typesDescs, @NotNull URI uri) throws TypeBuildException {
        if (typesDescs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initCommonTypeProperties must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/AbstractTypeLoader.initCommonTypeProperties must not be null");
        }
        VFile vfile = AbstractTypeLoader.uriToVFile(uri, false);
        String resourcePath = AbstractTypeLoader.uriToPath(uri);
        for (TypeDescription td : typesDescs) {
            ObjectTypeDescription otd = td.asObject();
            otd.setCatalog(this.catalog);
            AbstractTypeLoader.initResourceLocationData(vfile, resourcePath, otd);
            ArrayList<TypeDescription> innerTypes = new ArrayList<TypeDescription>();
            for (int i = 0; i < otd.getInnerTypeCount(); ++i) {
                innerTypes.add((TypeDescription)otd.getInnerType(i));
            }
            if (innerTypes.isEmpty()) continue;
            this.initCommonTypeProperties(innerTypes, uri);
        }
    }
}

