/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.project.catalog.config.SchemaResolver;
import oracle.bpm.project.catalog.config.TypeToLoad;

public class ProjectCatalogConfig {
    private Set<SchemaResolver> schemaResolvers = new HashSet<SchemaResolver>();
    private Set<TypeToLoad> typesToLoad = new HashSet<TypeToLoad>();
    private List<URI> urisToLoad = new ArrayList<URI>();
    private static ProjectCatalogConfig ourInstance = new ProjectCatalogConfig();
    private static final String HUMANTASK_SCHEMA_LOCATION = "oramds:/soa/shared/workflow/";

    private ProjectCatalogConfig() {
        this.initResolvers();
        this.initTypesToLoad();
    }

    public static ProjectCatalogConfig getInstance() {
        return ourInstance;
    }

    public Set<SchemaResolver> getSchemaResolvers() {
        return this.schemaResolvers;
    }

    public Set<TypeToLoad> getTypesToLoad() {
        return this.typesToLoad;
    }

    public List<URI> getUrisToLoad() {
        return Collections.unmodifiableList(this.urisToLoad);
    }

    private void initResolvers() {
        this.schemaResolvers.add(SchemaResolver.createSchemaResolver("http://xmlns.oracle.com/bpel/workflow/task", "oramds:/soa/shared/workflow/WorkflowTask.xsd", "oracle/bpel/services/workflow/schema/WorkflowTask.xsd"));
        this.schemaResolvers.add(SchemaResolver.createSchemaResolver("http://xmlns.oracle.com/bpel/workflow/TaskEvidenceService", "oramds:/soa/shared/workflow/TaskEvidenceService.xsd", "oracle/bpel/services/workflow/schema/TaskEvidenceService.xsd"));
        this.schemaResolvers.add(SchemaResolver.createSchemaResolver("http://xmlns.oracle.com/bpel/workflow/common", "oramds:/soa/shared/workflow/WorkflowCommon.xsd", "oracle/bpel/services/workflow/schema/WorkflowCommon.xsd"));
    }

    private void initTypesToLoad() {
        try {
            URI uri = new URI("oramds:/soa/shared/workflow/WorkflowTask.xsd");
            this.urisToLoad.add(uri);
            this.typesToLoad.add(TypeToLoad.createTypeToLoad(uri.toString()));
            uri = new URI("oramds:/soa/shared/workflow/TaskEvidenceService.xsd");
            this.typesToLoad.add(TypeToLoad.createTypeToLoad(uri.toString()));
            uri = new URI("oramds:/soa/shared/workflow/WorkflowCommon.xsd");
            this.typesToLoad.add(TypeToLoad.createTypeToLoad(uri.toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

