/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite.jaxb;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.project.catalog.composite.ScaBindingInfo;
import oracle.bpm.project.catalog.composite.ScaBindingInfoJca;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.ScaEventInfo;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.catalog.composite.jaxb.BPELImplementation;
import oracle.bpm.project.catalog.composite.jaxb.CEPImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Callback;
import oracle.bpm.project.catalog.composite.jaxb.Component;
import oracle.bpm.project.catalog.composite.jaxb.ComponentTypeInfo;
import oracle.bpm.project.catalog.composite.jaxb.Composite;
import oracle.bpm.project.catalog.composite.jaxb.DecisionImplementation;
import oracle.bpm.project.catalog.composite.jaxb.EventAgentImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Implementation;
import oracle.bpm.project.catalog.composite.jaxb.Import;
import oracle.bpm.project.catalog.composite.jaxb.ImportType;
import oracle.bpm.project.catalog.composite.jaxb.JCABinding;
import oracle.bpm.project.catalog.composite.jaxb.MediatorImplementation;
import oracle.bpm.project.catalog.composite.jaxb.NamespaceCollector;
import oracle.bpm.project.catalog.composite.jaxb.ObjectFactory;
import oracle.bpm.project.catalog.composite.jaxb.OverrideOptions;
import oracle.bpm.project.catalog.composite.jaxb.Property;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.SCAMode;
import oracle.bpm.project.catalog.composite.jaxb.SCAState;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.catalog.composite.jaxb.WSDLInterface;
import oracle.bpm.project.catalog.composite.jaxb.WebServiceBinding;
import oracle.bpm.project.catalog.composite.jaxb.Wire;
import oracle.bpm.project.catalog.composite.jaxb.WorkflowImplementation;
import oracle.bpm.project.catalog.composite.jaxb.XmlWriterContentHandler;
import oracle.bpm.project.model.Project;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ContentHandler;

public final class JaxbScaController
implements ScaController {
    @NotNull
    final ObjectFactory factory;
    private Map<String, Component> componentsByName;
    private Map<String, ComponentTypeInfo> componentTypesByName;
    private JAXBElement<Composite> compositeElement;
    private Set<String> importedNamespaces;
    private Set<String> names;
    @NotNull
    private Project project;
    private static final Pattern NUMERIC_SUFFIX_PATTERN = Pattern.compile("(.*?)([0-9]++)");
    public static final String SOA_DESIGNER = "http://xmlns.oracle.com/soa/designer/";
    public static final String WSDL_LOCATION = "wsdlLocation";
    static final Map<String, String> WELL_KNOWN_NAMESPACES;
    private static final JAXBContext jaxbContext;
    static final String WSDL_INTERFACE_FRAGMENT = "#wsdl.interface(";

    public JaxbScaController(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.<init> must not be null");
        }
        this.factory = new ObjectFactory();
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void commitChanges() {
        this.initialize();
        ((Composite)this.compositeElement.getValue()).setName(this.project.getName());
        for (ComponentTypeInfo componentTypeInfo : this.componentTypesByName.values()) {
            componentTypeInfo.commitChanges();
        }
        VFileSystem vfs = this.getFileSystem();
        VFile compositeXml = vfs.createFile("composite.xml");
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream((OutputStream)new VFileOutputStream(compositeXml));
            JaxbScaController.save(this.compositeElement, os);
        }
        catch (JAXBException e) {
            block7: {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
            StreamUtils.close((Closeable[])new Closeable[]{os});
        }
        catch (IOException e2) {
            block8: {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.close((Closeable[])new Closeable[]{os});
                        throw throwable;
                    }
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{os});
        }
        StreamUtils.close((Closeable[])new Closeable[]{os});
    }

    @Override
    public boolean isNameUniqueWithinComposite(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("name is mandatory");
        }
        this.initialize();
        return !this.names.contains(componentName);
    }

    @Override
    public void invokeAssemblyEditor() {
        throw new UnsupportedOperationException("Cannot open assembly editor outside of JDev");
    }

    @Override
    public Sequence<String> getServiceEntrypoints() {
        this.initialize();
        Composite composite = (Composite)this.compositeElement.getValue();
        return CollectionUtils.asSequence(composite.getService()).map((Function)new Function<Service, String>(){

            public String eval(Service value) {
                return value.getName();
            }
        });
    }

    @Override
    public void addComponentTypeProperty(String componentName, String serviceOrReferenceName, ScaPropertyInfo propInfo) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (propInfo == null) {
            throw new IllegalArgumentException("propInfo is mandatory");
        }
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.addProperty(propInfo, serviceOrReferenceName);
    }

    @Override
    public ScaPropertyInfo getComponentTypePropertyInfo(String componentName, String serviceOrReferenceName, String propertyName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is mandatory");
        }
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        return info.getProperty(serviceOrReferenceName, propertyName);
    }

    @Override
    public void deleteComponentTypeProperty(String componentName, String serviceOrReferenceName, String propertyName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is mandatory");
        }
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.deleteProperty(propertyName, serviceOrReferenceName);
    }

    @Override
    public boolean isNameUniqueWithinComponent(String componentName, String serviceName) {
        boolean result;
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is mandatory");
        }
        this.initialize();
        if (this.componentsByName.containsKey(componentName)) {
            ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
            result = componentTypeInfo.isNameUnique(serviceName);
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void createComponent(String componentName, String type, String sourcePath) {
        Object implementationElement;
        Implementation implementation;
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is mandatory");
        }
        if (sourcePath == null) {
            throw new IllegalArgumentException("sourcePath is mandatory");
        }
        if (!this.isNameUniqueWithinComposite(componentName)) {
            throw new IllegalArgumentException("component already exists: " + componentName);
        }
        if ("bpmn".equals(type)) {
            implementation = this.factory.createBPELImplementation();
            ((BPELImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationBpmn((BPELImplementation)implementation);
        } else if ("cqlx".equals(type)) {
            implementation = this.factory.createCEPImplementation();
            ((CEPImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationCqlx((CEPImplementation)implementation);
        } else if ("bpel".equals(type)) {
            implementation = this.factory.createBPELImplementation();
            ((BPELImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationBpel((BPELImplementation)implementation);
        } else if ("workflow".equals(type)) {
            implementation = this.factory.createWorkflowImplementation();
            ((WorkflowImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationWorkflow((WorkflowImplementation)implementation);
        } else if ("mediator".equals(type)) {
            implementation = this.factory.createMediatorImplementation();
            ((MediatorImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationMediator((MediatorImplementation)implementation);
        } else if ("eventAgent".equals(type)) {
            implementation = this.factory.createEventAgentImplementation();
            ((EventAgentImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationEventAgent((EventAgentImplementation)implementation);
        } else if ("decision".equals(type)) {
            implementation = this.factory.createDecisionImplementation();
            ((DecisionImplementation)implementation).setSrc(sourcePath);
            implementationElement = this.factory.createImplementationDecision((DecisionImplementation)implementation);
        } else {
            throw new IllegalArgumentException("unknown type: " + type);
        }
        Component component = this.factory.createComponent();
        component.setName(componentName);
        component.setImplementation((JAXBElement<? extends Implementation>)implementationElement);
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Component> components = composite.getComponent();
        components.add(component);
        this.componentsByName.put(componentName, component);
        this.names.add(componentName);
    }

    @Override
    public void addService(String componentName, String serviceName, ScaWsdlInfo wsdlInfo) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        componentTypeInfo.addService(serviceName, wsdlInfo);
    }

    @Override
    public void addReference(String componentName, String referenceName, ScaWsdlInfo wsdlInfo) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (referenceName == null) {
            throw new IllegalArgumentException("serviceName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        componentTypeInfo.addReference(referenceName, wsdlInfo);
    }

    @Override
    public Map<String, String> getImplementationSources(String implementationType) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.initialize();
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Component> components = composite.getComponent();
        if (components != null) {
            for (Component component : components) {
                JAXBElement<? extends Implementation> implementationElement = component.getImplementation();
                if (implementationElement == null || implementationType != null && !implementationElement.getName().getLocalPart().endsWith(implementationType)) continue;
                Implementation implementation = (Implementation)implementationElement.getValue();
                result.put(component.getName(), this.getSourceAttribute(implementation));
            }
        }
        return result;
    }

    @Override
    public List<String> getComponentServices(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        return componentTypeInfo.getServiceNames();
    }

    @Override
    public List<String> getComponentReferences(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        return componentTypeInfo.getReferenceNames();
    }

    @Override
    public List<String> getComponentReferenceTarget(String componentName, String referenceName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        int index = componentName.indexOf(47);
        final String normalizedSource = index != -1 ? componentName : componentName + "/" + referenceName;
        Composite composite = (Composite)this.compositeElement.getValue();
        ArrayList<String> result = new ArrayList<String>();
        CollectionUtils.asSequence(composite.getWire()).select((Predicate)new Predicate<Wire>(){

            public boolean check(@Nullable Wire wire) {
                return wire != null && normalizedSource.equals(String.valueOf(wire.getSource().getValue()));
            }
        }).map((Function)new Function<Wire, String>(){

            public String eval(Wire value) {
                return String.valueOf(value.getTarget().getValue());
            }
        }).addAllTo(result);
        return result;
    }

    @Override
    public void addWire(String sourceComponent, String sourceReference, String targetComponent, String targetService) {
        Wire wire;
        if (sourceComponent == null) {
            throw new IllegalArgumentException("sourceComponent is mandatory");
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException("targetComponent is mandatory");
        }
        int index = sourceComponent.indexOf(47);
        if (index != -1) {
            sourceReference = sourceComponent.substring(index + 1);
            sourceComponent = sourceComponent.substring(0, index);
        }
        if ((index = targetComponent.indexOf(47)) != -1) {
            targetService = targetComponent.substring(index + 1);
            targetComponent = targetComponent.substring(0, index);
        }
        if (this.isNameUniqueWithinComposite(sourceComponent)) {
            throw new IllegalArgumentException("addWire source " + sourceComponent + " does not exist.");
        }
        if (this.isNameUniqueWithinComposite(targetComponent)) {
            throw new IllegalArgumentException("addWire target " + targetComponent + " does not exist.");
        }
        if (sourceReference != null && this.isNameUniqueWithinComponent(sourceComponent, sourceReference)) {
            throw new IllegalArgumentException("addWire source " + sourceComponent + "/" + sourceReference + " does not exist.");
        }
        if (targetService != null && this.isNameUniqueWithinComponent(targetComponent, targetService)) {
            throw new IllegalArgumentException("addWire target " + targetComponent + "/" + targetService + " does not exist.");
        }
        String normalizedSource = sourceComponent + (sourceReference != null ? "/" + sourceReference : "");
        String normalizedTarget = targetComponent + (targetService != null ? "/" + targetService : "");
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Wire> wires = composite.getWire();
        Iterator<Wire> it = wires.iterator();
        while (it.hasNext()) {
            wire = it.next();
            JAXBElement<?> source = wire.getSource();
            JAXBElement<?> target = wire.getTarget();
            if (source == null || target == null) {
                it.remove();
                continue;
            }
            String srcRef = String.valueOf(source.getValue());
            String tgtRef = String.valueOf(target.getValue());
            if (!srcRef.equals(normalizedSource) || !tgtRef.equals(normalizedTarget)) continue;
            return;
        }
        wire = this.factory.createWire();
        wire.setSource(this.factory.createSourceUri(normalizedSource));
        wire.setTarget(this.factory.createTargetUri(normalizedTarget));
        wires.add(wire);
    }

    @Override
    public void deleteReference(String componentName, String referenceName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (referenceName == null) {
            throw new IllegalArgumentException("referenceName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        this.deleteWireBySource(componentName + "/" + referenceName);
        componentTypeInfo.deleteReference(referenceName);
    }

    @Override
    public void deleteService(String componentName, String serviceName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        this.deleteWireByTarget(componentName + "/" + serviceName);
        componentTypeInfo.deleteService(serviceName);
    }

    @Override
    public void addCompositeProperty(String componentName, ScaPropertyInfo propInfo) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (propInfo == null) {
            throw new IllegalArgumentException("propInfo is mandatory");
        }
        this.initialize();
        Component component = this.componentsByName.get(componentName);
        if (component == null) {
            throw new IllegalArgumentException("unknown component: " + componentName);
        }
        List<Property> properties = component.getProperty();
        for (Property property : properties) {
            if (!property.getName().equals(propInfo.name)) continue;
            this.updateProperty(property, propInfo);
            return;
        }
        Property property = new Property();
        this.updateProperty(property, propInfo);
        properties.add(property);
    }

    @Override
    public void deleteCompositeProperty(String componentName, String propertyName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is mandatory");
        }
        this.initialize();
        Component component = this.componentsByName.get(componentName);
        if (component == null) {
            throw new IllegalArgumentException("unknown component: " + componentName);
        }
        List<Property> properties = component.getProperty();
        Iterator<Property> it = properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            if (!property.getName().equals(propertyName)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public ScaWsdlInfo getWsdlInfoForName(String componentName, String linkName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is mandatory");
        }
        if (linkName == null) {
            throw new IllegalArgumentException("linkName is mandatory");
        }
        ComponentTypeInfo componentTypeInfo = this.getComponentTypeInfo(componentName);
        return componentTypeInfo.getWsdlInfoForName(linkName);
    }

    @Override
    public void updateService(String componentName, String oldServiceName, String newServiceName, ScaWsdlInfo wsdlInfo) {
        this.deleteService(componentName, oldServiceName);
        this.addService(componentName, newServiceName, wsdlInfo);
    }

    @Override
    public void addExternalReference(String referenceName, ScaWsdlInfo wsdlInfo, ScaBindingInfo bindingInfo) {
        this.initialize();
        referenceName = this.makeUniqueName(referenceName);
        Composite composite = (Composite)this.compositeElement.getValue();
        Reference reference = this.factory.createReference();
        reference.setName(referenceName);
        if (bindingInfo.type.equals("jca")) {
            JCABinding jcaBinding = this.factory.createJCABinding();
            jcaBinding.config = ((ScaBindingInfoJca)bindingInfo).config;
            WSDLInterface wsdlInterface = this.factory.createWSDLInterface();
            wsdlInterface.setInterface(this.toInterfaceURI(wsdlInfo.requestPortType));
            if (wsdlInfo.replyPortType != null) {
                wsdlInterface.setCallbackInterface(this.toInterfaceURI(wsdlInfo.replyPortType));
            }
            reference.setInterface(this.factory.createInterfaceWsdl(wsdlInterface));
            reference.getBinding().add(this.factory.createBindingJca(jcaBinding));
            reference.getOtherAttributes().put(new QName(SOA_DESIGNER, WSDL_LOCATION), wsdlInfo.location);
        }
        composite.getReference().add(reference);
    }

    @Override
    public String addServiceEntrypoint(String sourceServiceName, ScaWsdlInfo wsdlInfo) {
        boolean hasRepleyPortType;
        this.initialize();
        String serviceName = Str.isEmpty((String)sourceServiceName) ? "Service" : this.makeUniqueName(sourceServiceName);
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Service> services = composite.getService();
        Service service = this.factory.createService();
        service.setName(serviceName);
        service.setInterface(this.makeWsdlInterface(wsdlInfo));
        this.setServiceLocation(wsdlInfo, service);
        WebServiceBinding binding = this.factory.createWebServiceBinding();
        binding.setPort(this.toEndpointURI(serviceName, wsdlInfo.requestPortType));
        service.getBinding().add(this.factory.createBindingWs(binding));
        boolean bl = hasRepleyPortType = wsdlInfo.replyPortType != null;
        if (hasRepleyPortType) {
            WebServiceBinding callbackBinding = this.factory.createWebServiceBinding();
            callbackBinding.setPort(this.toEndpointURI(serviceName, wsdlInfo.replyPortType));
            Callback callback = this.factory.createCallback();
            service.getCallback().add(callback);
            callback.getBinding().add(this.factory.createBindingWs(callbackBinding));
        }
        services.add(service);
        this.names.add(serviceName);
        this.checkImport(wsdlInfo);
        return serviceName;
    }

    @Override
    public void updateServiceEntrypoint(String oldServiceName, String newServiceName, ScaWsdlInfo wsdlInfo) {
        this.deleteServiceEntrypoint(oldServiceName);
        this.addServiceEntrypoint(newServiceName, wsdlInfo);
    }

    @Override
    public void deleteServiceEntrypoint(String serviceName) {
        this.initialize();
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Service> services = composite.getService();
        Iterator<Service> it = services.iterator();
        while (it.hasNext()) {
            Service service = it.next();
            if (!service.getName().equals(serviceName)) continue;
            it.remove();
            this.deleteWireBySource(serviceName);
            this.names.remove(serviceName);
        }
    }

    @Override
    public void addEventSubscription(String componentName, ScaEventInfo eventInfo) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.addEventSubscription(eventInfo);
        this.checkImport(eventInfo);
    }

    @Override
    public void deleteEventSubscription(String componentName, ScaEventInfo eventInfo) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.deleteEventSubscription(eventInfo);
    }

    @Override
    public Sequence<ScaEventInfo> getEventSubscriptions(String componentName) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        return info.getEventSubscriptions();
    }

    @Override
    public void addEventPublish(String componentName, ScaEventInfo eventInfo) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.addEventPublish(eventInfo);
        this.checkImport(eventInfo);
    }

    @Override
    public void deleteEventPublish(String componentName, ScaEventInfo eventInfo) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.deleteEventPublish(eventInfo);
    }

    @Override
    public Sequence<ScaEventInfo> getEventPublishes(String componentName) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        return info.getEventPublishes();
    }

    @Override
    public void deleteComponent(final String componentName) {
        ComponentTypeInfo info = this.getComponentTypeInfo(componentName);
        info.delete();
        this.deleteComponent(new Predicate<Component>(){

            public boolean check(@Nullable Component component) {
                return component != null && componentName.equals(component.name);
            }
        });
        this.deleteWire(new Predicate<Wire>(){

            public boolean check(@Nullable Wire wire) {
                return wire != null && (String.valueOf(wire.getSource().getValue()).startsWith(componentName + "/") || String.valueOf(wire.getTarget().getValue()).startsWith(componentName + "/"));
            }
        });
        this.componentsByName.remove(componentName);
        this.componentTypesByName.remove(componentName);
        this.names.remove(componentName);
    }

    public void checkImport(ScaWsdlInfo wsdlInfo) {
        boolean hasReplyPortType;
        Composite composite = (Composite)this.compositeElement.getValue();
        boolean bl = hasReplyPortType = wsdlInfo.replyPortType != null;
        if (!this.isNamespaceImported(wsdlInfo.requestPortType.getNamespaceURI())) {
            Import importWsdlRequest = this.factory.createImport();
            importWsdlRequest.setImportType(ImportType.WSDL);
            importWsdlRequest.setNamespace(wsdlInfo.requestPortType.getNamespaceURI());
            importWsdlRequest.setLocation(wsdlInfo.location);
            composite.getImport().add(importWsdlRequest);
            this.importedNamespaces.add(wsdlInfo.requestPortType.getNamespaceURI());
        }
        if (hasReplyPortType && !wsdlInfo.requestPortType.getNamespaceURI().equals(wsdlInfo.replyPortType.getNamespaceURI()) && !this.isNamespaceImported(wsdlInfo.replyPortType.getNamespaceURI())) {
            Import importWsdlReply = this.factory.createImport();
            importWsdlReply.setImportType(ImportType.WSDL);
            importWsdlReply.setNamespace(wsdlInfo.replyPortType.getNamespaceURI());
            importWsdlReply.setLocation(wsdlInfo.location);
            composite.getImport().add(importWsdlReply);
            this.importedNamespaces.add(wsdlInfo.replyPortType.getNamespaceURI());
        }
    }

    static void marshall(JAXBElement<?> compositeElement, OutputStream os, Marshaller marshaller) throws JAXBException {
        XmlWriter writer;
        NamespaceCollector collector = new NamespaceCollector();
        marshaller.marshal(compositeElement, (ContentHandler)collector);
        Set<String> namespaces = collector.getNamespaces();
        Map<String, String> namespaceMapping = collector.getNamespaceMapping();
        LinkedHashMap<String, String> prefixMappings = new LinkedHashMap<String, String>(WELL_KNOWN_NAMESPACES);
        int count = 0;
        for (String namespace : namespaces) {
            if (Str.isEmpty((String)namespace)) continue;
            String prefix = (String)prefixMappings.get(namespace);
            if (prefix == null) {
                prefix = "ns" + ++count;
            }
            prefixMappings.put(namespace, prefix);
        }
        prefixMappings.putAll(namespaceMapping);
        try {
            writer = new XmlWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        writer.setIndentAttributes(true);
        marshaller.marshal(compositeElement, (ContentHandler)new XmlWriterContentHandler(writer, prefixMappings));
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    static void save(@NotNull JAXBElement<?> compositeElement, @NotNull OutputStream os) throws JAXBException {
        if (compositeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.save must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.save must not be null");
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        JaxbScaController.marshall(compositeElement, os, marshaller);
    }

    VFileSystem getFileSystem() {
        return this.project.getLoader().getProjectFileSystem().getDataFileSystem();
    }

    JAXBElement<WSDLInterface> makeWsdlInterface(ScaWsdlInfo wsdlInfo) {
        WSDLInterface wsdlInterface = this.factory.createWSDLInterface();
        JAXBElement<WSDLInterface> interfaceWsdl = this.factory.createInterfaceWsdl(wsdlInterface);
        wsdlInterface.setInterface(this.toInterfaceURI(wsdlInfo.requestPortType));
        if (wsdlInfo.replyPortType != null) {
            wsdlInterface.setCallbackInterface(this.toInterfaceURI(wsdlInfo.replyPortType));
        }
        return interfaceWsdl;
    }

    String getLocation(Map<QName, String> otherAttributes) {
        if (otherAttributes != null) {
            return otherAttributes.get(new QName(SOA_DESIGNER, WSDL_LOCATION));
        }
        return null;
    }

    void setServiceLocation(ScaWsdlInfo wsdlInfo, Service service) {
        Map<QName, String> attributes = service.getOtherAttributes();
        attributes.put(new QName(SOA_DESIGNER, WSDL_LOCATION, "ui"), wsdlInfo.location);
    }

    private void checkImport(ScaEventInfo eventInfo) {
        Composite composite = (Composite)this.compositeElement.getValue();
        if (!this.isNamespaceImported(eventInfo.namespace)) {
            if (eventInfo.edlFile == null) {
                throw new IllegalArgumentException("edlFile is mandatory: " + eventInfo);
            }
            Import importWsdlRequest = this.factory.createImport();
            importWsdlRequest.setImportType(ImportType.EDL);
            importWsdlRequest.setNamespace(eventInfo.namespace);
            importWsdlRequest.setLocation(eventInfo.edlFile);
            composite.getImport().add(importWsdlRequest);
            this.importedNamespaces.add(eventInfo.namespace);
        }
    }

    private void deleteWireBySource(final String wireSource) {
        Predicate<Wire> predicate = new Predicate<Wire>(){

            public boolean check(@Nullable Wire wire) {
                return wire != null && wire.getSource() != null && String.valueOf(wire.getSource().getValue()).equals(wireSource);
            }
        };
        this.deleteWire(predicate);
    }

    private void deleteWireByTarget(final String wireTarget) {
        Predicate<Wire> predicate = new Predicate<Wire>(){

            public boolean check(@Nullable Wire wire) {
                return wire != null && wire.getTarget() != null && String.valueOf(wire.getTarget().getValue()).equals(wireTarget);
            }
        };
        this.deleteWire(predicate);
    }

    private void deleteWire(Predicate<Wire> predicate) {
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Wire> wires = composite.getWire();
        Iterator<Wire> it = wires.iterator();
        while (it.hasNext()) {
            Wire wire = it.next();
            if (!predicate.check((Object)wire)) continue;
            it.remove();
        }
    }

    private void deleteComponent(Predicate<Component> predicate) {
        Composite composite = (Composite)this.compositeElement.getValue();
        List<Component> components = composite.getComponent();
        Iterator<Component> it = components.iterator();
        while (it.hasNext()) {
            Component component = it.next();
            if (!predicate.check((Object)component)) continue;
            it.remove();
        }
    }

    private String makeUniqueName(String name) {
        Matcher matcher = NUMERIC_SUFFIX_PATTERN.matcher("");
        while (this.names.contains(name)) {
            if (matcher.reset(name).matches()) {
                name = matcher.group(1) + (Integer.parseInt(matcher.group(2)) + 1);
                continue;
            }
            name = name + "1";
        }
        return name;
    }

    private boolean isNamespaceImported(String namespace) {
        return this.importedNamespaces.contains(namespace);
    }

    private String toInterfaceURI(QName qName) {
        return qName.getNamespaceURI() + WSDL_INTERFACE_FRAGMENT + qName.getLocalPart() + ")";
    }

    private String toEndpointURI(String serviceName, QName qName) {
        return qName.getNamespaceURI() + "#wsdl.endpoint(" + serviceName + "/" + qName.getLocalPart() + ")";
    }

    private void updateProperty(Property dst, ScaPropertyInfo src) {
        dst.setName(src.name);
        dst.setValue(src.value);
        dst.setMany(src.many);
        dst.setOverride(src.override == null ? null : OverrideOptions.fromValue(src.override.scaName));
        dst.setType(src.type);
        dst.setSource(src.source);
    }

    /*
     * Exception decompiling
     */
    private JAXBElement<Composite> loadComposite() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JAXBElement<Composite> createEmptyComposite() {
        Composite composite = this.factory.createComposite();
        composite.setName(this.project.getName());
        composite.setRevision("1.0");
        composite.setLabel(Time.now().format("yyyy-MM-dd_hh-mm-ss_S"));
        composite.setMode(SCAMode.ACTIVE);
        composite.setState(SCAState.ON);
        return this.factory.createComposite(composite);
    }

    private void initialize() {
        if (this.compositeElement == null) {
            List<Import> imports;
            List<Service> services;
            List<Reference> references;
            List<Property> properties;
            this.compositeElement = this.loadComposite();
            this.names = new HashSet<String>();
            this.importedNamespaces = new HashSet<String>();
            this.componentsByName = new HashMap<String, Component>();
            this.componentTypesByName = new HashMap<String, ComponentTypeInfo>();
            Composite composite = (Composite)this.compositeElement.getValue();
            List<Component> components = composite.getComponent();
            if (components != null) {
                for (Component component : components) {
                    String name = component.getName();
                    this.names.add(name);
                    this.componentsByName.put(name, component);
                }
            }
            if ((properties = composite.getProperty()) != null) {
                for (Property property : properties) {
                    this.names.add(property.getName());
                }
            }
            if ((references = composite.getReference()) != null) {
                for (Reference reference : references) {
                    this.names.add(reference.getName());
                }
            }
            if ((services = composite.getService()) != null) {
                for (Service service : services) {
                    this.names.add(service.getName());
                }
            }
            if ((imports = composite.getImport()) != null) {
                for (Import anImport : imports) {
                    this.importedNamespaces.add(anImport.getNamespace());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ComponentTypeInfo getComponentTypeInfo(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.getComponentTypeInfo must not be null");
        }
        this.initialize();
        ComponentTypeInfo componentTypeInfo = this.componentTypesByName.get(componentName);
        if (componentTypeInfo == null) {
            Component component = this.componentsByName.get(componentName);
            if (component == null) {
                throw new IllegalArgumentException("no such component: " + componentName);
            }
            componentTypeInfo = new ComponentTypeInfo(this, component);
            this.componentTypesByName.put(componentName, componentTypeInfo);
        }
        ComponentTypeInfo componentTypeInfo2 = componentTypeInfo;
        if (componentTypeInfo2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.getComponentTypeInfo must not return null");
        }
        return componentTypeInfo2;
    }

    private String getSourceAttribute(@NotNull Implementation implementation) {
        String src;
        block11: {
            if (implementation == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/JaxbScaController.getSourceAttribute must not be null");
            }
            src = null;
            try {
                src = (String)implementation.getClass().getMethod("getSrc", new Class[0]).invoke((Object)implementation, new Object[0]);
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (IllegalArgumentException e) {
                assert (false) : e;
            }
            catch (InvocationTargetException e) {
                assert (false) : e;
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (SecurityException e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)e);
            }
        }
        return src;
    }

    static {
        jaxbContext = JaxbHelper.newContext((String)Composite.class.getPackage().getName(), (ClassLoader)Composite.class.getClassLoader());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("http://xmlns.oracle.com/sca/1.0", "");
        map.put("http://www.w3.org/2001/XMLSchema", "xs");
        map.put("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
        map.put("http://schemas.oracle.com/ws/2006/01/policy", "orawsp");
        map.put(SOA_DESIGNER, "ui");
        WELL_KNOWN_NAMESPACES = Collections.unmodifiableMap(map);
    }
}

