/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScaEventInfo {
    @Nullable
    public final String edlFile;
    @Nullable
    public final String filter;
    @Nullable
    public final Map<String, URI> filterNamespaces;
    @NotNull
    public final String name;
    @NotNull
    public final String namespace;
    @NotNull
    public final String runAsRoles;
    @NotNull
    public final Consistency subscriptionConsistency;
    public static final String EVENT_DEFAULT_ROLE = "$publisher";

    private ScaEventInfo(@NotNull String namespace, @NotNull String name, @Nullable String edlFile, @NotNull Consistency subscriptionConsistency, @Nullable String filter, @Nullable Map<String, URI> filterNamespaces, @Nullable String runAsRoles) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.<init> must not be null");
        }
        if (subscriptionConsistency == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.<init> must not be null");
        }
        this.namespace = namespace;
        this.name = name;
        this.edlFile = edlFile;
        this.subscriptionConsistency = subscriptionConsistency;
        this.filter = filter;
        this.filterNamespaces = filterNamespaces;
        this.runAsRoles = runAsRoles;
    }

    public static ScaEventInfo createEventInfo(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.createEventInfo must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.createEventInfo must not be null");
        }
        return new ScaEventInfo(namespace, name, null, Consistency.ONEONLY, null, null, EVENT_DEFAULT_ROLE);
    }

    public ScaEventInfo filter(@Nullable String filter, @Nullable Map<String, URI> filterNamespaces) {
        if (filter == null != (filterNamespaces == null)) {
            throw new IllegalArgumentException("Inconsistent parameters. Either both are null or none are.");
        }
        return new ScaEventInfo(this.namespace, this.name, this.edlFile, this.subscriptionConsistency, filter, Collections.unmodifiableMap(new HashMap<String, URI>(filterNamespaces)), this.runAsRoles);
    }

    public ScaEventInfo consistency(@NotNull Consistency subscriptionConsistency) {
        if (subscriptionConsistency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.consistency must not be null");
        }
        return new ScaEventInfo(this.namespace, this.name, this.edlFile, subscriptionConsistency, this.filter, this.filterNamespaces, this.runAsRoles);
    }

    public ScaEventInfo runAsRoles(@Nullable String runAsRoles) {
        return new ScaEventInfo(this.namespace, this.name, this.edlFile, this.subscriptionConsistency, this.filter, this.filterNamespaces, runAsRoles);
    }

    public ScaEventInfo edlFile(@NotNull String edlFile) {
        if (edlFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.edlFile must not be null");
        }
        return new ScaEventInfo(this.namespace, this.name, edlFile, this.subscriptionConsistency, this.filter, this.filterNamespaces, this.runAsRoles);
    }

    public ScaEventInfo name(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.name must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo.name must not be null");
        }
        return new ScaEventInfo(namespace, name, this.edlFile, this.subscriptionConsistency, this.filter, this.filterNamespaces, this.runAsRoles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaEventInfo that = (ScaEventInfo)o;
        return this.name.equals(that.name) && this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "ScaEventInfo{edlFile='" + this.edlFile + '\'' + ", filter='" + this.filter + '\'' + ", filterNamespaces=" + this.filterNamespaces + ", name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + ", runAsRoles='" + this.runAsRoles + '\'' + ", subscriptionConsistency=" + (Object)((Object)this.subscriptionConsistency) + '}';
    }

    public static enum Consistency {
        IMMEDIATE("immediate"),
        GUARANTEED("guaranteed"),
        ONEONLY("oneAndOnlyOne");

        private final String text;

        private Consistency(String text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaEventInfo$Consistency.<init> must not be null");
            }
            this.text = text;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/ScaEventInfo$Consistency.text must not return null");
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public static Consistency fromString(@Nullable String s) {
            Consistency consistency;
            for (Consistency consistency2 : Consistency.values()) {
                if (!consistency2.text().equals(s)) continue;
                consistency = consistency2;
                if (consistency == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/ScaEventInfo$Consistency.fromString must not return null");
                return consistency;
            }
            consistency = ONEONLY;
            if (consistency != null) return consistency;
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/ScaEventInfo$Consistency.fromString must not return null");
        }
    }
}

