/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeObject;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeInterface
implements CompositeObject {
    private final QName callback;
    private final CompositeServiceType compositeServiceType;
    private final CatalogInterfaceType interfaceType;
    private final URL location;
    private final String name;
    private final QName service;
    private final String target;
    private final String targetPort;
    private Map<String, ScaPropertyInfo> properties;

    public CompositeInterface(@NotNull String name, @NotNull URL location, @NotNull QName service, @Nullable QName callback, @NotNull String target, @Nullable String targetPort, @NotNull CompositeServiceType compositeServiceType, CatalogInterfaceType interfaceType, Map<String, ScaPropertyInfo> properties) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeInterface.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeInterface.<init> must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeInterface.<init> must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeInterface.<init> must not be null");
        }
        if (compositeServiceType == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeInterface.<init> must not be null");
        }
        this.name = name;
        this.location = location;
        this.service = service;
        this.callback = callback;
        this.target = target;
        this.targetPort = targetPort;
        this.compositeServiceType = compositeServiceType;
        this.interfaceType = interfaceType;
        this.properties = properties;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeInterface.getName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public URL getLocation() {
        URL uRL = this.location;
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeInterface.getLocation must not return null");
        }
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public QName getService() {
        QName qName = this.service;
        if (qName == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeInterface.getService must not return null");
        }
        return qName;
    }

    public QName getCallback() {
        return this.callback;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTarget() {
        String string = this.target;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeInterface.getTarget must not return null");
        }
        return string;
    }

    @Override
    public CompositeServiceType getComponentType() {
        return this.compositeServiceType;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public Map<String, ScaPropertyInfo> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public boolean isService() {
        return this.interfaceType == CatalogInterfaceType.SERVICE;
    }

    public CatalogInterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    @Nullable
    public String getTargetPort() {
        return this.targetPort;
    }

    public String toString() {
        return "name: " + this.name + " location: " + this.location + " service: " + this.service + " callback: " + this.callback + " target: " + this.target + " targetPort: " + this.targetPort + " compositeServiceType: " + (Object)((Object)this.compositeServiceType) + " interfaceType: " + (Object)((Object)this.interfaceType);
    }
}

