/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.CompositeAccessorMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeUpdater;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.jaxb.JaxbScaController;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeAccessorFactory {
    private static final CompositeAccessorFactory INSTANCE;
    private static final String JAXB_COMPOSITE_ACCESOR = "use.jaxb.composite.accesor";

    protected CompositeAccessorFactory() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CompositeAccessor createCompositeAccessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessorFactory.createCompositeAccessor must not be null");
        }
        CompositeAccessor compositeAccessor = INSTANCE.instantiateCompositeAccessor(project);
        if (compositeAccessor == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessorFactory.createCompositeAccessor must not return null");
        }
        return compositeAccessor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CompositeUpdater createCompositeUpdater(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessorFactory.createCompositeUpdater must not be null");
        }
        CompositeUpdater compositeUpdater = new CompositeUpdater(process, CompositeAccessorFactory.createScaController(process.getProject()));
        if (compositeUpdater == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessorFactory.createCompositeUpdater must not return null");
        }
        return compositeUpdater;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ScaController createScaController(Project project) {
        ScaController scaController = INSTANCE.instantiateScaController(project);
        if (scaController == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessorFactory.createScaController must not return null");
        }
        return scaController;
    }

    @NotNull
    protected abstract CompositeAccessor instantiateCompositeAccessor(@NotNull Project var1);

    protected ScaController instantiateScaController(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessorFactory.instantiateScaController must not be null");
        }
        return new JaxbScaController(project);
    }

    static {
        CompositeAccessorFactory factory;
        List factories = Platform.getExtensionService().getExtensionsByPoint(CompositeAccessorMetadata.class);
        Extension extension = Boolean.parseBoolean(System.getProperty(JAXB_COMPOSITE_ACCESOR)) ? (Extension)CollectionUtils.max((Iterable)factories, (Comparator)new ExtensionPriorityComparator()) : (Extension)CollectionUtils.min((Iterable)factories, (Comparator)new ExtensionPriorityComparator());
        if (extension == null) {
            throw new Error("Cannot find a suitable CompositeAccessorFactory");
        }
        try {
            factory = (CompositeAccessorFactory)extension.instantiateAs(CompositeAccessorFactory.class);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        INSTANCE = factory;
    }

    private static class ExtensionPriorityComparator
    implements Comparator<Extension<CompositeAccessorMetadata>> {
        private ExtensionPriorityComparator() {
        }

        @Override
        public int compare(Extension<CompositeAccessorMetadata> o1, Extension<CompositeAccessorMetadata> o2) {
            int rightPriority;
            int leftPriority = ((CompositeAccessorMetadata)o1.getMetadata()).priority();
            return leftPriority < (rightPriority = ((CompositeAccessorMetadata)o2.getMetadata()).priority()) ? -1 : (leftPriority == rightPriority ? 0 : 1);
        }
    }
}

