/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.common.Resource;
import oracle.bpm.project.catalog.composite.util.FlowNodeFilter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final String DOT_HOLDER = ".Holder";

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getTypeName(@NotNull VFile vfile, @NotNull String startPath) {
        if (vfile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        if (startPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        String canonicalPath = vfile.getCanonicalPath();
        String string = Utils.getTypeName(canonicalPath, startPath);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.getTypeName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getTypeName(@NotNull String cannonicalPath, @NotNull String startPath) {
        if (cannonicalPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        if (startPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        String[] paths = Str.split((String)Utils.excludeExtension(cannonicalPath), (char)'/', (boolean)false);
        String typeName = null;
        for (int i = 1; i < paths.length; ++i) {
            String path = paths[i];
            if (i == 1 && path.equals(startPath)) continue;
            String name = Identifier.classname((String)path);
            typeName = typeName == null ? name : typeName + "." + name;
        }
        assert (typeName != null);
        String string = typeName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.getTypeName must not return null");
        }
        return string;
    }

    public static boolean isBpmObjectNamespace(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isBpmObjectNamespace must not be null");
        }
        return namespace.startsWith("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    public static List<Resource> tsort(@NotNull Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.tsort must not be null");
        }
        ArrayList<Resource> sortedList = new ArrayList<Resource>();
        Utils.tsort(resource, sortedList, new IdentitySet<Resource>());
        return sortedList;
    }

    public static boolean isHolderType(@NotNull String namespace, @NotNull String typeName) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isHolderType must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isHolderType must not be null");
        }
        return (Utils.isBpmObjectNamespace(namespace) || Utils.isBpmObjectNamespace(namespace)) && typeName.endsWith(DOT_HOLDER);
    }

    public static String excludeExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.excludeExtension must not be null");
        }
        int index = fileName.indexOf(".");
        String result = fileName;
        if (index > 0) {
            result = fileName.substring(0, index);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VFile vFileUrlToVFile(@NotNull URL location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.vFileUrlToVFile must not be null");
        }
        VFile result = VFileURLConnection.get((URL)location);
        assert (result != null) : "Could not load result resource:" + location;
        VFile vFile = result;
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.vFileUrlToVFile must not return null");
        }
        return vFile;
    }

    public static boolean deepCompareXmlTypes(@NotNull XmlTypeDescription source, @NotNull XmlTypeDescription target) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.deepCompareXmlTypes must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.deepCompareXmlTypes must not be null");
        }
        return source.equals((Object)target) && TypeUtils.compareObjectMembers((ObjectTypeDescription)source, (ObjectTypeDescription)target);
    }

    public static String buildFreeName(@NotNull Set<String> existingNames, @NotNull String typeName) {
        if (existingNames == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        String result = typeName;
        int i = 1;
        while (existingNames.contains(result)) {
            result = typeName + i;
            ++i;
        }
        return result;
    }

    public static String buildFreeName(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        String result = typeName;
        int i = 1;
        while (typeIndex.findExact(result) != null) {
            result = typeName + i;
            ++i;
        }
        return result;
    }

    public static void fixResourceLocation(@NotNull URL location, String relativePath, @NotNull TypeDescription type) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.fixResourceLocation must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.fixResourceLocation must not be null");
        }
        if (type instanceof ObjectTypeDescription) {
            ObjectTypeDescription otd = (ObjectTypeDescription)type;
            if ("vfile".equals(location.getProtocol())) {
                VFile vFile = Utils.vFileUrlToVFile(location);
                otd.setTransientProperty("resource_location", (Object)relativePath);
                otd.setTransientProperty("files", (Object)new VFile[]{vFile});
            } else {
                otd.setTransientProperty("resource_location", (Object)location.toString());
            }
            for (TypeRef typeRef : otd.getInnerTypeRefs()) {
                Utils.fixResourceLocation(location, relativePath, typeRef.get());
            }
        }
    }

    public static String resolvePath(@NotNull URL location, @NotNull VFileSystem fileSystem) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.resolvePath must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.resolvePath must not be null");
        }
        String relativePath = "vfile".equals(location.getProtocol()) ? fileSystem.createFile(location.getPath()).getCanonicalPath() : location.toString();
        return relativePath;
    }

    public static boolean isServiceInterfaceDefined(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isServiceInterfaceDefined must not be null");
        }
        Sequence definedServices = process.getChildrenByType(FlowNode.class).select(PredicateUtils.or(ModelUtils.ACTIVITY_FILTER, ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL).select(ModelUtils.INITIATOR_CONVERSATION_FILTER).map(FlowNodeFilter.NODE_OPERATION_MAPPER).select(FlowNodeFilter.SERVICE_FILTER).select(FlowNodeFilter.SERVICE_DEFINER_FILTER);
        return !definedServices.isEmpty();
    }

    private static void tsort(Resource resource, List<Resource> sortedList, IdentitySet<Resource> visited) {
        Set<Resource> dependencies = resource.getDependencies();
        for (Resource dependency : dependencies) {
            if (visited.contains(dependency)) continue;
            visited.add(dependency);
            Utils.tsort(dependency, sortedList, visited);
        }
        sortedList.add(resource);
    }

    static class IdentitySet<T> {
        IdentityHashMap<T, T> map = new IdentityHashMap();

        IdentitySet() {
        }

        public boolean contains(T target) {
            return this.map.containsKey(target);
        }

        public void add(T target) {
            this.map.put(target, target);
        }
    }
}

