/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceUUID;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.bundles.ServiceBuilder;
import oracle.bpm.project.catalog.bundles.SynthesizedReferenceManager;
import oracle.bpm.project.catalog.bundles.XmlSchemaReferenceManager;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.CompositeObject;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.type.ErrorTypeFactory;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceReferenceManager
extends SynthesizedReferenceManager {
    private CompositeAccessor controller;
    private BiMap<String, String> customizedServices;
    private BiMap<String, String> synthesizedServices;
    private XmlSchemaReferenceManager xmlManager;

    public ServiceReferenceManager(@NotNull CompositeAccessor controller, @NotNull ComponentCatalog catalog, @NotNull XmlSchemaReferenceManager xmlManager) {
        if (controller == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.<init> must not be null");
        }
        if (xmlManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.<init> must not be null");
        }
        super(catalog);
        this.controller = controller;
        this.xmlManager = xmlManager;
        this.customizedServices = new HashBiMap();
        this.synthesizedServices = new HashBiMap();
    }

    @Override
    public void addObject(MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription otd) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addObject must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addObject must not be null");
        }
        if (this.needsProcessing(otd)) {
            this.addCustomizedService(typeIndex, typeName, (XObjectTypeDescription)otd);
        } else {
            this.fixSynthesizedService(typeIndex, typeName);
        }
    }

    @Override
    public void typeAddedOrUpdated(MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription otd) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.typeAddedOrUpdated must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.typeAddedOrUpdated must not be null");
        }
        this.addObject(typeIndex, typeName, otd);
    }

    @Override
    public void typeRemoved(MutableTypeIndex typeIndex, @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.typeRemoved must not be null");
        }
        String serviceObjectId = (String)this.customizedServices.inverse().get((Object)typeName);
        if (serviceObjectId != null) {
            this.addSynthesizedService(typeIndex, serviceObjectId);
        }
    }

    public List<String> refresh(@NotNull MutableTypeIndex typeIndex) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.refresh must not be null");
        }
        ArrayList<String> typesToUpdate = new ArrayList<String>();
        Map<String, TypeDescription> types = this.createAllSynthesizedServices(typeIndex);
        BiMap invertedMap = this.synthesizedServices.inverse();
        for (Map.Entry<String, TypeDescription> entry : types.entrySet()) {
            String typeName = entry.getKey();
            String serviceObjectId = (String)invertedMap.get((Object)typeName);
            if (serviceObjectId == null) {
                boolean exists;
                try {
                    exists = this.getCatalog().find(entry.getKey()) != null;
                }
                catch (AmbiguousTypeNameException ignore) {
                    exists = false;
                }
                if (exists) continue;
                this.addSynthesizedServices(typeIndex, entry.getKey(), entry.getValue().asObject());
                continue;
            }
            if (!this.needsUpdate(typeIndex, typeName, entry.getValue().asObject())) continue;
            this.reloadSynthesizedService(typeIndex, serviceObjectId);
        }
        HashSet typesToRemove = new HashSet();
        for (Map.Entry entry : this.synthesizedServices.entrySet()) {
            String typeName = (String)entry.getValue();
            if (types.get(typeName) != null) continue;
            typesToRemove.add(entry.getKey());
        }
        for (String serviceObjectId : typesToRemove) {
            this.removeSynthesizedService(typeIndex, serviceObjectId);
        }
        for (Map.Entry entry : this.customizedServices.entrySet()) {
            String customizedServiceId = (String)entry.getKey();
            if (this.existsService(types.values(), customizedServiceId)) continue;
            typesToUpdate.add((String)entry.getValue());
        }
        return typesToUpdate;
    }

    @Override
    public void clear() {
        this.customizedServices.clear();
        this.synthesizedServices.clear();
    }

    public void buildAllSynthesizedServices(@NotNull MutableTypeIndex typeIndex) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildAllSynthesizedServices must not be null");
        }
        for (Map.Entry<String, TypeDescription> entry : this.createAllSynthesizedServices(typeIndex).entrySet()) {
            TypeDescription value = entry.getValue();
            this.addSynthesizedServices(typeIndex, entry.getKey(), value.asObject());
        }
    }

    private boolean existsService(@NotNull Collection<TypeDescription> types, @NotNull String serviceObjectId) {
        if (types == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.existsService must not be null");
        }
        if (serviceObjectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.existsService must not be null");
        }
        boolean result = false;
        for (TypeDescription type : types) {
            ObjectTypeDescription otd;
            if (!type.isObject() || !serviceObjectId.equals((otd = type.asObject()).getProperty("service.object.id"))) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean needsUpdate(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription newType) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.needsUpdate must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.needsUpdate must not be null");
        }
        if (newType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.needsUpdate must not be null");
        }
        boolean result = true;
        try {
            TypeRef typeRef = this.getCatalog().find(typeName);
            if (typeRef != null) {
                ObjectTypeDescription originalType = typeRef.get().asObject();
                this.xmlManager.addObject(typeIndex, typeName, newType);
                result = !this.equalsType(newType, originalType);
            }
        }
        catch (AmbiguousTypeNameException e) {
            // empty catch block
        }
        return result;
    }

    private boolean equalsType(ObjectTypeDescription newType, ObjectTypeDescription originalType) {
        return this.typeHash(newType).equals(this.typeHash(originalType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private String typeHash(@NotNull ObjectTypeDescription otd) {
        String string;
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.typeHash must not be null");
        }
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes;
            MessageDigest md = MessageDigest.getInstance("MD5");
            String name = otd.getName();
            md.update(name.getBytes());
            List methods = otd.getMethods();
            ArrayList<String> names = new ArrayList<String>();
            for (MethodTypeDescription method : methods) {
                String methodName = method.getName();
                names.add(methodName);
                for (Argument arg : method.getArguments()) {
                    String argName = arg.getName();
                    String argType = arg.getTypeRef().getText();
                    String inout = "";
                    if (arg.isIn()) {
                        inout = "in";
                    }
                    if (arg.isOut()) {
                        inout = "out";
                    }
                    names.add(methodName + ":" + argName + ":" + argType + inout);
                }
            }
            Collections.sort(names);
            for (String value : names) {
                md.update(value.getBytes());
            }
            for (byte aByte : bytes = md.digest()) {
                sb.append(Integer.toHexString(0xFF & aByte));
            }
            string = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ServiceReferenceManager.typeHash must not return null");
        }
        return string;
    }

    private void addSynthesizedService(@NotNull MutableTypeIndex typeIndex, @NotNull String serviceObjectId) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addSynthesizedService must not be null");
        }
        if (serviceObjectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addSynthesizedService must not be null");
        }
        this.customizedServices.remove((Object)serviceObjectId);
        ServiceUUID serviceUUID = UUIDFactory.parseServiceId((String)serviceObjectId);
        String target = serviceUUID.getTarget();
        String targetPort = serviceUUID.getTargetPort();
        Tuple<? extends CompositeObject, CompositeInterface> tuple = this.findCompositeObject(target, targetPort);
        if (tuple != null) {
            CompositeInterface compositeInterface = (CompositeInterface)tuple.getSecond();
            String baseModule = this.buildSynthesizedModule((CompositeObject)tuple.getFirst(), compositeInterface.getInterfaceType());
            Map<String, ObjectTypeDescription> services = this.createSynthesizedService(typeIndex, baseModule, compositeInterface);
            for (Map.Entry<String, ObjectTypeDescription> service : services.entrySet()) {
                this.addSynthesizedServices(typeIndex, service.getKey(), service.getValue());
            }
        }
    }

    @Nullable
    private CompositeInfo parseCompositeInfo() {
        CompositeInfo compositeInfo = null;
        try {
            compositeInfo = this.controller.parseComposite();
        }
        catch (CompositeAccessorException e) {
            Log.logSevere((Throwable)((Object)e));
        }
        return compositeInfo;
    }

    private void addCustomizedService(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull XObjectTypeDescription bpmObject) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addCustomizedService must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addCustomizedService must not be null");
        }
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addCustomizedService must not be null");
        }
        String serviceObjectId = bpmObject.getProperty("service.object.id");
        this.customizedServices.put((Object)serviceObjectId, (Object)typeName);
        this.removeSynthesizedService(typeIndex, serviceObjectId);
    }

    private void removeSynthesizedService(@NotNull MutableTypeIndex typeIndex, String serviceObjectId) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.removeSynthesizedService must not be null");
        }
        String serviceName = (String)this.synthesizedServices.get((Object)serviceObjectId);
        if (serviceName != null) {
            try {
                TypeRef typeRef = this.getCatalog().find(serviceName);
                ArrayList<String> innerTypes = new ArrayList<String>();
                if (typeRef != null) {
                    TypeDescription td = typeRef.get();
                    for (TypeRef ref : td.asObject().getInnerTypeRefs()) {
                        innerTypes.add(ref.getText());
                    }
                    TypeDescription parent = td.getParent();
                    parent.asObject().removeInnerType(typeRef);
                    typeIndex.remove(serviceName);
                    this.removeUnusedVirtualTypes(typeIndex, parent.getText());
                }
                this.synthesizedServices.remove((Object)serviceObjectId);
                this.xmlManager.typeRemoved(typeIndex, serviceName);
                for (String innerType : innerTypes) {
                    this.xmlManager.typeRemoved(typeIndex, innerType);
                }
            }
            catch (AmbiguousTypeNameException e) {
                Log.logWarning((Throwable)e);
            }
            catch (TypeCatalogException e) {
                Log.logWarning((Throwable)e);
            }
        }
    }

    private void removeUnusedVirtualTypes(@NotNull MutableTypeIndex typeIndex, @NotNull String module) throws TypeCatalogException {
        ObjectTypeDescription otd;
        TypeDescription td;
        TypeRef typeRef;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.removeUnusedVirtualTypes must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.removeUnusedVirtualTypes must not be null");
        }
        if (module.contains(".") && (typeRef = typeIndex.findExact(module)) != null && (td = typeRef.get()).isObject() && !(otd = td.asObject()).hasInnerTypes()) {
            TypeDescription parent = otd.getParent();
            parent.asObject().removeInnerType(typeRef);
            typeIndex.remove(typeRef.getText());
            this.removeUnusedVirtualTypes(typeIndex, parent.getText());
        }
    }

    private boolean needsProcessing(@NotNull ObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.needsProcessing must not be null");
        }
        String serviceObjectId = bpmObject.getProperty("service.object.id");
        String isCallback = bpmObject.getProperty("is.callback");
        return !Str.isEmpty((String)serviceObjectId) && !bpmObject.isSynthesized() && Boolean.valueOf(isCallback) == false;
    }

    private Map<String, TypeDescription> createAllSynthesizedServices(@NotNull MutableTypeIndex typeIndex) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.createAllSynthesizedServices must not be null");
        }
        CompositeInfo compositeInfo = this.parseCompositeInfo();
        Set<String> genProcessServiceNames = this.buildGeneratedProcessServiceNames(compositeInfo.getComponents());
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        if (compositeInfo != null) {
            Iterable<CompositeComponent> components = compositeInfo.getComponents();
            for (CompositeComponent component : components) {
                CompositeServiceType type = component.getComponentType();
                if (CompositeServiceType.HUMAN_TASK.equals((Object)type) || CompositeServiceType.BUSINESS_RULE.equals((Object)type) || CompositeServiceType.BPMN.equals((Object)type)) continue;
                String referenceModule = this.buildSynthesizedModule(component, CatalogInterfaceType.REFERENCE);
                String serviceModule = this.buildSynthesizedModule(component, CatalogInterfaceType.SERVICE);
                for (CompositeInterface serv : component.getServices()) {
                    result.putAll(this.createSynthesizedService(typeIndex, serviceModule, serv));
                }
                for (CompositeInterface serv : component.getReferences()) {
                    CompositeServiceType componentType = serv.getComponentType();
                    if (componentType.equals((Object)CompositeServiceType.HUMAN_TASK) || componentType.equals((Object)CompositeServiceType.BUSINESS_RULE)) continue;
                    result.putAll(this.createSynthesizedService(typeIndex, referenceModule, serv));
                }
            }
            Iterable<CompositeInterface> compositeInterfaceList = compositeInfo.getReferences();
            this.buildSynthesizeInterface(typeIndex, compositeInterfaceList, CatalogInterfaceType.SERVICE, genProcessServiceNames, result);
            this.buildSynthesizeInterface(typeIndex, compositeInfo.getServices(), CatalogInterfaceType.REFERENCE, genProcessServiceNames, result);
        }
        return result;
    }

    private Set<String> buildGeneratedProcessServiceNames(Iterable<CompositeComponent> components) {
        HashSet<String> result = new HashSet<String>();
        for (CompositeComponent component : components) {
            for (CompositeInterface compositeInterface : component.getServices()) {
                String value;
                ScaPropertyInfo propertyInfo = compositeInterface.getProperties().get("bpm.generated.exposed.serviceName");
                if (propertyInfo == null || Str.isEmpty((String)(value = propertyInfo.value))) continue;
                result.add(value);
            }
        }
        return result;
    }

    private void buildSynthesizeInterface(@NotNull MutableTypeIndex typeIndex, @NotNull Iterable<CompositeInterface> interfaces, @NotNull CatalogInterfaceType interfaceType, @NotNull Set<String> genProcessServiceNames, @NotNull Map<String, TypeDescription> result) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizeInterface must not be null");
        }
        if (interfaces == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizeInterface must not be null");
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizeInterface must not be null");
        }
        if (genProcessServiceNames == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizeInterface must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizeInterface must not be null");
        }
        for (CompositeInterface compositeInterface : interfaces) {
            if (!CompositeServiceType.WEB_SERVICE.equals((Object)compositeInterface.getComponentType()) || genProcessServiceNames.contains(compositeInterface.getName())) continue;
            String baseModule = this.buildSynthesizedModule(compositeInterface, interfaceType);
            Map<String, ObjectTypeDescription> objectTypeDescriptionMap = this.createSynthesizedService(typeIndex, baseModule, compositeInterface);
            result.putAll(objectTypeDescriptionMap);
        }
    }

    private void fixSynthesizedService(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.fixSynthesizedService must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.fixSynthesizedService must not be null");
        }
        try {
            TypeRef ref = this.getCatalog().find(typeName);
            if (ref != null && ComponentType.PORT_TYPE.getText().equals(ref.getComponentType())) {
                ArrayList typesToReload = new ArrayList();
                for (Map.Entry entry : CollectionUtils.createCopy((Iterable)this.synthesizedServices.entrySet())) {
                    String text;
                    ObjectTypeDescription otd;
                    TypeRef originalType;
                    TypeRef typeRef = this.getCatalog().find((String)entry.getValue());
                    if (typeRef == null || (originalType = (TypeRef)(otd = typeRef.get().asObject()).getTransientProperty("service.type.ref")) == null || !typeName.equals(text = originalType.getText())) continue;
                    typesToReload.add(entry.getKey());
                }
                for (String serviceObjectId : typesToReload) {
                    this.reloadSynthesizedService(typeIndex, serviceObjectId);
                }
            }
        }
        catch (TypeCatalogException e) {
            Log.logSevere((Throwable)e);
        }
    }

    private void reloadSynthesizedService(@NotNull MutableTypeIndex typeIndex, @NotNull String serviceObjectId) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.reloadSynthesizedService must not be null");
        }
        if (serviceObjectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.reloadSynthesizedService must not be null");
        }
        this.removeSynthesizedService(typeIndex, serviceObjectId);
        this.addSynthesizedService(typeIndex, serviceObjectId);
    }

    private void addSynthesizedServices(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName, @NotNull ObjectTypeDescription otd) {
        String serviceObjectId;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addSynthesizedServices must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addSynthesizedServices must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.addSynthesizedServices must not be null");
        }
        String isCallback = otd.getProperty("is.callback");
        if (!Boolean.valueOf(isCallback).booleanValue() && this.customizedServices.get((Object)(serviceObjectId = otd.getProperty("service.object.id"))) == null) {
            try {
                boolean hasErrors = otd.hasErrors();
                assert (serviceObjectId.charAt(0) == 'S' || hasErrors) : "Only services can be added:" + serviceObjectId;
                typeIndex.add(otd, TypeUtils.moduleName((String)typeName, (String)""));
                if (!hasErrors) {
                    this.synthesizedServices.put((Object)serviceObjectId, (Object)typeName);
                    this.xmlManager.addObject(typeIndex, typeName, otd);
                    if (otd.getInnerTypeCount() > 0) {
                        this.xmlManager.addObject(typeIndex, typeName + "." + "Callback", otd.getInnerType(0));
                    }
                }
            }
            catch (TypeCatalogException e) {
                Log.logFatal((Throwable)e);
            }
        }
    }

    @Nullable
    private Tuple<? extends CompositeObject, CompositeInterface> findCompositeObject(final @NotNull String target, final @Nullable String targetPort) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.findCompositeObject must not be null");
        }
        Tuple result = null;
        CompositeInfo compositeInfo = this.parseCompositeInfo();
        CompositeObject compositeObject = null;
        CompositeInterface compositeInterface = null;
        if (compositeInfo != null) {
            if (targetPort == null) {
                Iterable<CompositeInterface> references = compositeInfo.getReferences();
                Collection filteredInterfaces = CollectionUtils.createFilteredCollection(references, (Predicate)new Predicate<CompositeInterface>(){

                    public boolean check(CompositeInterface value) {
                        return value != null && target.equals(value.getTarget());
                    }
                });
                int r = filteredInterfaces.size();
                assert (r == 0 || r == 1) : "More than one matching reference has been found in composite: " + filteredInterfaces;
                if (r == 0) {
                    Iterable<CompositeInterface> services = compositeInfo.getServices();
                    filteredInterfaces = CollectionUtils.createFilteredCollection(services, (Predicate)new Predicate<CompositeInterface>(){

                        public boolean check(CompositeInterface value) {
                            return value != null && target.equals(value.getTarget());
                        }
                    });
                    int s = filteredInterfaces.size();
                    assert (s == 0 || s == 1) : "More than one matching service has been found in composite: " + filteredInterfaces;
                }
                compositeObject = compositeInterface = (CompositeInterface)CollectionUtils.first((Iterable)filteredInterfaces);
            } else {
                Iterable<CompositeComponent> components = compositeInfo.getComponents();
                for (CompositeComponent component : components) {
                    List<CompositeInterface> componentReferences = component.getServices();
                    Collection filteredInterfaces = CollectionUtils.createFilteredCollection(componentReferences, (Predicate)new Predicate<CompositeInterface>(){

                        public boolean check(CompositeInterface value) {
                            return value != null && targetPort.equals(value.getTargetPort()) && target.equals(value.getTarget());
                        }
                    });
                    int r = filteredInterfaces.size();
                    assert (r == 0 || r == 1) : "More than one matching reference has been found in component " + component.getName() + "composite: " + filteredInterfaces;
                    if (r == 0) {
                        List<CompositeInterface> componentServices = component.getReferences();
                        filteredInterfaces = CollectionUtils.createFilteredCollection(componentServices, (Predicate)new Predicate<CompositeInterface>(){

                            public boolean check(CompositeInterface value) {
                                return value != null && targetPort.equals(value.getTargetPort()) && target.equals(value.getTarget());
                            }
                        });
                        int s = filteredInterfaces.size();
                        assert (s == 0 || s == 1) : "More than one matching service has been found in component " + component.getName() + "composite: " + filteredInterfaces;
                    }
                    if ((compositeInterface = (CompositeInterface)CollectionUtils.first((Iterable)filteredInterfaces)) == null) continue;
                    compositeObject = component;
                    break;
                }
            }
            if (compositeInterface != null) {
                result = Tuple.create(compositeObject, compositeInterface);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Map<String, ObjectTypeDescription> createSynthesizedService(@NotNull MutableTypeIndex typeIndex, @NotNull String module, @NotNull CompositeInterface compositeInterface) {
        HashMap<String, ObjectTypeDescription> result;
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.createSynthesizedService must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.createSynthesizedService must not be null");
        }
        if (compositeInterface == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.createSynthesizedService must not be null");
        }
        QName serviceQname = compositeInterface.getService();
        QName callbackQname = compositeInterface.getCallback();
        String portTypeId = this.buildPortTypeId(serviceQname);
        WsdlTypeDescription portType = (WsdlTypeDescription)this.findById(typeIndex, portTypeId);
        if (portType == null) {
            result = new HashMap();
            ObjectTypeDescription typeDescription = ErrorTypeFactory.createObjectErrorType(Identifier.classname((String)compositeInterface.getName()), ProjectCatalogMsg.SERVICE_NOT_FOUND(compositeInterface.getName()));
            typeDescription.setProperty("service.object.id", portTypeId);
            typeDescription.setProperty("target", compositeInterface.getTarget());
            typeDescription.setProperty("target.port", compositeInterface.getTargetPort());
            result.put(module + "." + typeDescription.getText(), typeDescription);
        } else {
            WsdlTypeDescription callbackType = null;
            if (callbackQname != null) {
                String callbackServiceId = this.buildPortTypeId(callbackQname);
                callbackType = (WsdlTypeDescription)this.findById(typeIndex, callbackServiceId);
            }
            result = ServiceBuilder.createSynthesizedServices(this.getCatalog(), module, compositeInterface, portType, callbackType);
        }
        HashMap<String, ObjectTypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ServiceReferenceManager.createSynthesizedService must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String buildSynthesizedModule(@NotNull CompositeObject composite, @NotNull CatalogInterfaceType interfaceType) {
        if (composite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizedModule must not be null");
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizedModule must not be null");
        }
        String module = interfaceType == CatalogInterfaceType.SERVICE ? "Services" : "References";
        if (composite.isComponent()) {
            CompositeServiceType serviceType = composite.getComponentType();
            String serviceName = Identifier.classname((String)composite.getName());
            module = module + "." + Identifier.classname((String)serviceType.getServiceType()) + "." + serviceName;
        } else {
            module = module + "." + "Externals";
        }
        String string = module;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildSynthesizedModule must not return null");
        }
        return string;
    }

    @Nullable
    private TypeDescription findById(@NotNull MutableTypeIndex typeIndex, @NotNull String id) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.findById must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.findById must not be null");
        }
        SortedSet ref = typeIndex.findByPropertyValue("typeId", id);
        TypeDescription result = null;
        if (!ref.isEmpty()) {
            result = ((TypeRef)ref.first()).get();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String buildPortTypeId(@NotNull QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildPortTypeId must not be null");
        }
        String nativeName = qName.getLocalPart();
        String namespace = qName.getNamespaceURI();
        String string = UUIDFactory.createPortTypeId((String)namespace, (String)nativeName).getId();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ServiceReferenceManager.buildPortTypeId must not return null");
        }
        return string;
    }
}

