/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceBuilder {
    public static Map<String, ObjectTypeDescription> createSynthesizedServices(@NotNull ComponentCatalog catalog, @NotNull String baseModule, @NotNull CompositeInterface compositeRef, @NotNull WsdlTypeDescription portType, @Nullable WsdlTypeDescription callbackPortType) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createSynthesizedServices must not be null");
        }
        if (baseModule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createSynthesizedServices must not be null");
        }
        if (compositeRef == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createSynthesizedServices must not be null");
        }
        if (portType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createSynthesizedServices must not be null");
        }
        HashMap<String, ObjectTypeDescription> result = new HashMap<String, ObjectTypeDescription>();
        String serviceName = compositeRef.getName();
        String displayName = Identifier.classname((String)serviceName);
        XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescription((String)displayName, (String)baseModule, (ComponentCatalog)catalog);
        String target = compositeRef.getTarget();
        String targetPort = compositeRef.getTargetPort();
        bpmObject.setProperty("target", target);
        bpmObject.setProperty("target.port", targetPort);
        bpmObject.setModifiers(bpmObject.getModifiers() | 0x100000000L);
        String interfaceObjectValue = compositeRef.isService() ? "service.object" : "reference.object";
        bpmObject.setProperty("interface.object", interfaceObjectValue);
        ObjectTypeDescription serviceObject = portType.asObject();
        DynamicRef ref = new DynamicRef(serviceObject, catalog);
        bpmObject.setTransientProperty("service.type.ref", (Object)ref);
        bpmObject.setProperty("service.object.id", UUIDFactory.createServiceId((String)portType.getNamespace(), (String)portType.getNativeName(), (String)target, (String)targetPort).getId());
        ServiceBuilder.createDelegatedMethods(bpmObject, serviceObject);
        result.put(baseModule + "." + bpmObject.getText(), (ObjectTypeDescription)bpmObject);
        if (callbackPortType != null) {
            XObjectTypeDescription callbackOtd = BpmObjectFactory.createCallbackXObjectTypeDescription((ComponentCatalog)catalog, (XObjectTypeDescription)bpmObject, (WsdlTypeDescription)callbackPortType, (String)baseModule);
            callbackOtd.setProperty("interface.object", interfaceObjectValue);
            callbackOtd.addModifier(0x100000000L);
            DynamicRef callbackRef = new DynamicRef((ObjectTypeDescription)callbackPortType, catalog);
            bpmObject.setTransientProperty("callback.type.ref", (Object)callbackRef);
            ServiceBuilder.createDelegatedMethods(callbackOtd, (ObjectTypeDescription)callbackPortType);
        }
        return result;
    }

    private static void createDelegatedMethods(@NotNull XObjectTypeDescription otd, @NotNull ObjectTypeDescription service) {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createDelegatedMethods must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ServiceBuilder.createDelegatedMethods must not be null");
        }
        for (MethodTypeDescription method : service.getMethods()) {
            if (method.isConstructor()) continue;
            String displayName = method.getName();
            TypeRef parent = method.getParentRef();
            DelegatedMethodTypeDescription member = new DelegatedMethodTypeDescription(displayName, parent, method.getSignature());
            if (method.getExceptionCount() != 0) {
                member.setExceptions(method.getExceptions());
            }
            for (Argument arg : method.getArguments()) {
                member.addArgument(arg.copy());
            }
            otd.addMember((MethodTypeDescription)member);
        }
    }
}

