/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.util.ArrayList;
import java.util.SortedSet;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.bundles.ComponentBundleTypeIndex;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class NoCatalogTypeIndex
implements MutableTypeIndex {
    private ComponentBundleTypeIndex typeIndex;

    public NoCatalogTypeIndex(@NotNull ComponentBundleTypeIndex typeIndex) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.<init> must not be null");
        }
        this.typeIndex = typeIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeRef add(@NotNull ObjectTypeDescription otd, @NotNull String module) throws TypeCatalogException {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.add must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.add must not be null");
        }
        String typeName = !Str.isEmpty((String)module) ? module + "." + otd.getName() : otd.getText();
        for (TypeRef typeRef : new ArrayList(otd.getInnerTypeRefs())) {
            if (!(typeRef instanceof ObjectTypeDescription)) continue;
            ObjectTypeDescription innerOtd = (ObjectTypeDescription)typeRef;
            this.add(innerOtd, module + "." + otd.getName());
        }
        this.removeParent(otd);
        this.typeIndex.indexTypeAdded(typeName, (TypeDescription)otd);
        ObjectTypeDescription objectTypeDescription = otd;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.add must not return null");
        }
        return objectTypeDescription;
    }

    public void remove(@NotNull String typeName) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.remove must not be null");
        }
        this.typeIndex.indexTypeRemoved(typeName);
    }

    public void update(@NotNull ObjectTypeDescription type) throws TypeCatalogException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.update must not be null");
        }
    }

    public TypeRef findExact(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findExact must not be null");
        }
        return this.typeIndex.findExact(typeName);
    }

    public TypeRef findById(@NotNull String componentType, @NotNull String id) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findById must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findById must not be null");
        }
        return this.typeIndex.findById(componentType, id);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SortedSet<TypeRef> findByPropertyValue(@NotNull String propertyName, @NotNull String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findByPropertyValue must not be null");
        }
        if (propertyValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findByPropertyValue must not be null");
        }
        SortedSet<TypeRef> sortedSet = this.typeIndex.findByPropertyValue(propertyName, propertyValue);
        if (sortedSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/NoCatalogTypeIndex.findByPropertyValue must not return null");
        }
        return sortedSet;
    }

    private void removeParent(ObjectTypeDescription otd) {
        TypeRef typeRef = otd.getParentRef();
        if (typeRef != null) {
            typeRef.get().asObject().removeInnerType(otd.getRef());
        }
    }
}

