/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

class ProcessTemplateRenderer
implements Renderer {
    private final DrawableProcess process;
    private static final Image BIG_LOCK = Image.create((Msg)ProjectDrawMsg.BIG_LOCK_CLOSED).getGrayed();
    private static final int LOCK_GAP = 15;

    public ProcessTemplateRenderer(@NotNull DrawableProcess process) {
        this.process = process;
    }

    public static ProcessTemplateRenderer create(@NotNull DrawableProcess container) {
        return new ProcessTemplateRenderer(container);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        ProcessSealType type = (ProcessSealType)((Object)this.getFeature(ProcessSealTypeFeature.class).getValue());
        if (type.isFlowSealed() && this.getProcess().getProject().isTemplate()) {
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            Dimension canvas = this.getRoot().getCanvasSize();
            if (canvas.equals((Object)Dimension.ZERO)) {
                canvas = this.getRoot().getBounds(context).getSize();
            }
            Image image = BIG_LOCK;
            int deltaX = context.getDeltaX();
            int deltaY = context.getDeltaY();
            graphics.setForeground(Color.TRANSLUCENT_35);
            int x = deltaX + canvas.getWidth() - image.getWidth() - 15;
            int y = deltaY + 15;
            graphics.drawImage(image, x, y, image.getWidth(), image.getHeight());
            graphics.setForeground(original);
        }
    }

    private DrawableRoot getRoot() {
        Drawable parent = this.process.getContainer();
        while (!(parent instanceof DrawableRoot)) {
            parent = parent.getContainer();
        }
        return (DrawableRoot)parent;
    }

    private <T extends Feature> T getFeature(Class<T> featureClass) {
        return this.getProcess().getFeature(featureClass);
    }

    private Process getProcess() {
        return (Process)this.process.getModelObject();
    }
}

