/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class FlowElementTemplateRenderer
implements FlowElementRenderer {
    private DrawableFlowElement<?> drawable;
    private static final Image LOCK_CLOSED = Image.create((Msg)UIMsg.LOCK_CLOSED);
    private static final Image PENCIL = Image.create((Msg)ProjectDrawMsg.PENCIL);

    private FlowElementTemplateRenderer(@NotNull DrawableFlowElement drawable) {
        this.drawable = drawable;
    }

    public static FlowElementTemplateRenderer create(@NotNull DrawableFlowElement drawable) {
        return new FlowElementTemplateRenderer(drawable);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        ActivityPermissionFeature feature = this.getFeature(ActivityPermissionFeature.class);
        if (feature != null && this.getModelObject().getProject().isTemplate()) {
            ActivityPermissionType type = (ActivityPermissionType)((Object)feature.getValue());
            if (type.isUseProcessPermission()) {
                ProcessSealType processSeal = (ProcessSealType)((Object)this.getProcessSealType().getValue());
                ActivityPermissionType activityPermissionType = type = processSeal.isActivitySealed() ? ActivityPermissionType.SEALED : ActivityPermissionType.CAN_REDEFINE;
            }
            if (type == ActivityPermissionType.SEALED || type == ActivityPermissionType.SHOULD_DEFINE) {
                Image image = type == ActivityPermissionType.SEALED ? LOCK_CLOSED : PENCIL;
                int imageWidth = context.scale(image.getWidth());
                int imageHeight = context.scale(image.getHeight());
                Rectangle bounds = this.getScaledDrawableBounds(context);
                int deltaX = context.scale(4);
                int deltaY = context.scale(5);
                int imageX = bounds.getX() + bounds.getWidth() - imageWidth - deltaX;
                int imageY = bounds.getY() + deltaY;
                context.getGraphics().drawImage(image, imageX, imageY, imageWidth, imageHeight);
            }
        }
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        return false;
    }

    @Override
    public Rectangle getRenderBounds(@NotNull DrawContext context) {
        return null;
    }

    @Override
    public Dimension getRenderDimension(@NotNull DrawContext context) {
        return null;
    }

    private Rectangle getScaledDrawableBounds(@NotNull DrawContext context) {
        return context.scaleRectangle(this.drawable.getBounds(context));
    }

    private <T extends Feature> T getFeature(Class<T> featureClass) {
        return this.getModelObject().getFeature(featureClass);
    }

    private ProcessSealTypeFeature getProcessSealType() {
        return this.getModelObject().getProcess().getFeature(ProcessSealTypeFeature.class);
    }

    @NotNull
    private FlowElement getModelObject() {
        return this.drawable.getModelObject();
    }
}

