/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.renderer.FlowElementImageRenderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class FlowElementScaledImageRenderer
extends FlowElementImageRenderer {
    private EventTriggerType cachedTrigger = this.getModelObject().getEventTriggerType();
    private Image scaledNormal;
    private Image scaledSelected;
    private static final float SCALE_FACTOR = 0.75f;

    private FlowElementScaledImageRenderer(@NotNull DrawableEvent drawable) {
        super(drawable);
    }

    public static FlowElementScaledImageRenderer create(@NotNull DrawableEvent drawable) {
        return new FlowElementScaledImageRenderer(drawable);
    }

    @Override
    public Rectangle getRenderBounds(@NotNull DrawContext context) {
        Rectangle result = super.getRenderBounds(context);
        if (this.isBoundary()) {
            int deltaWidth = (result.getWidth() - context.scale(result.getWidth())) / 2;
            int deltaHeight = (result.getHeight() - context.scale(result.getHeight())) / 2;
            result = Rectangle.valueOf((int)(result.getX() - deltaWidth), (int)(result.getY() - deltaHeight), (int)(result.getWidth() + deltaWidth * 2), (int)(result.getHeight() + deltaHeight * 2));
        }
        return result;
    }

    @Override
    public Dimension getRenderDimension(@NotNull DrawContext context) {
        Dimension result = super.getRenderDimension(context);
        if (this.isBoundary()) {
            int deltaWidth = (result.getWidth() - context.scale(result.getWidth())) / 2;
            int deltaHeight = (result.getHeight() - context.scale(result.getHeight())) / 2;
            result = Dimension.valueOf((int)(result.getWidth() + deltaWidth * 2), (int)(result.getHeight() + deltaHeight * 2));
        }
        return result;
    }

    @Override
    protected Image getNormalImage(@NotNull DrawContext context) {
        if (!this.isCorrespondingImageCached()) {
            this.generateCachedImages(context);
        }
        return this.scaledNormal;
    }

    @Override
    protected Image getSelectedImage(@NotNull DrawContext context) {
        if (!this.isCorrespondingImageCached()) {
            this.generateCachedImages(context);
        }
        return this.scaledSelected;
    }

    @Override
    @NotNull
    protected Event getModelObject() {
        return (Event)super.getModelObject();
    }

    private boolean isCorrespondingImageCached() {
        return this.scaledNormal != null && this.scaledSelected != null && this.getModelObject().getEventTriggerType() == this.cachedTrigger;
    }

    private void generateCachedImages(@NotNull DrawContext context) {
        this.scaledNormal = this.scaleIfBoundary(super.getNormalImage(context));
        this.scaledSelected = this.scaleIfBoundary(super.getSelectedImage(context));
        this.cachedTrigger = this.getModelObject().getEventTriggerType();
    }

    private Image scaleIfBoundary(@NotNull Image result) {
        Activity activity;
        if (this.isBoundary() && !(activity = this.getBoundaryEvent().getBoundaryActivity()).isSubprocess()) {
            Dimension scaled = result.getDimension().scale(0.75f);
            result = result.getScaledInstance(scaled.getWidth(), scaled.getHeight(), 4);
        }
        return result;
    }

    private boolean isBoundary() {
        return this.getModelObject().isCatchEvent() && this.getModelObject().asCatchEvent().isBoundaryEvent();
    }

    private BoundaryEvent getBoundaryEvent() {
        return this.getModelObject().asCatchEvent().asAnyNode(BoundaryEvent.class);
    }
}

