/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.renderer.DefaultRenderer;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.renderer.FlowElementTemplateRenderer;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ScaledPolygon;
import org.jetbrains.annotations.NotNull;

public class FlowElementImageRenderer
extends DefaultRenderer
implements FlowElementRenderer {
    private FlowElementTemplateRenderer template;

    protected FlowElementImageRenderer(@NotNull DrawableFlowElement drawable) {
        super(drawable);
        this.template = FlowElementTemplateRenderer.create(drawable);
    }

    public static FlowElementImageRenderer create(@NotNull DrawableFlowElement drawable) {
        return new FlowElementImageRenderer(drawable);
    }

    public static Image getImage(@NotNull DrawableFlowElement<?> drawable, @NotNull DrawContext context) {
        Object flowElement = drawable.getModelObject();
        return drawable.isShowSelection() || context.isHighlighted(drawable) ? FlowElementImageRenderer.getSelectedImage(flowElement, context) : FlowElementImageRenderer.getNormalImage(flowElement, context);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Graphics g = context.getGraphics();
        Image imageToShow = this.getImage(context);
        Rectangle bounds = this.getScaledDrawableBounds(context);
        g.drawImage(imageToShow, bounds);
        super.render(context);
        this.template.render(context);
        if (context.isHighlighted(this.getDrawable())) {
            Color c = g.getForeground();
            Stroke s = g.getStroke();
            g.setForeground(Color.DARK_GREEN);
            g.setStroke(Stroke.FOUR_SOLID);
            g.translate(bounds.getX(), bounds.getY());
            g.draw(this.getScaledDrawPolygon(context));
            g.setForeground(Color.BLACK);
            g.setStroke(Stroke.ONE_SOLID);
            g.draw(this.getScaledDrawPolygon(context));
            g.translate(-bounds.getX(), -bounds.getY());
            g.setForeground(c);
            g.setStroke(s);
        }
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        Point check;
        Point top = this.getDrawable().getBounds(context).getTop();
        Image image = this.getImage(context);
        return image.isVisible((check = top.translate(-x, -y)).getX(), check.getY()) || image.isInside(check);
    }

    @Override
    public Rectangle getRenderBounds(@NotNull DrawContext context) {
        Image image = this.getImage(context);
        return Rectangle.createAround((Point)this.getDrawable().getLocation(), (int)image.getWidth(), (int)image.getHeight());
    }

    @Override
    public Dimension getRenderDimension(@NotNull DrawContext context) {
        Image image = this.getImage(context);
        return Dimension.valueOf((int)image.getWidth(), (int)image.getHeight());
    }

    @Override
    protected DrawableFlowElement getDrawable() {
        return (DrawableFlowElement)super.getDrawable();
    }

    protected Image getNormalImage(@NotNull DrawContext context) {
        return FlowElementImageRenderer.getNormalImage(this.getDrawable().getModelObject(), context);
    }

    protected Image getSelectedImage(@NotNull DrawContext context) {
        return FlowElementImageRenderer.getSelectedImage(this.getDrawable().getModelObject(), context);
    }

    @NotNull
    protected FlowElement getModelObject() {
        return this.getDrawable().getModelObject();
    }

    private static Image getNormalImage(@NotNull FlowElement flowElement, @NotNull DrawContext context) {
        return context.getTheme().getImageFor(flowElement);
    }

    private static Image getSelectedImage(@NotNull FlowElement flowElement, @NotNull DrawContext context) {
        return context.getTheme().getImageFor(flowElement, ImageType.SELECTED);
    }

    private Image getImage(@NotNull DrawContext context) {
        Object flowElement = this.getDrawable().getModelObject();
        return this.getDrawable().isShowSelection() || context.isHighlighted(this.getDrawable()) ? this.getSelectedImage(context) : FlowElementImageRenderer.getNormalImage(flowElement, context);
    }

    private Polygon getScaledDrawPolygon(@NotNull DrawContext context) {
        FlowFigureType type = FlowFigureUtils.fromElement(this.getModelObject());
        ScaledPolygon polygon = context.getTheme().getPolygon(type);
        return polygon.getScaledPolygon(context.getScale());
    }

    private Rectangle getScaledDrawableBounds(@NotNull DrawContext context) {
        return context.scaleRectangle(this.getDrawable().getBounds(context));
    }
}

