/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import java.io.IOException;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Utilities;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.activities.CustomImageFeature;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class FlowElementCustomImageRenderer
implements FlowElementRenderer {
    private final DrawableFlowElement<?> drawable;
    private Image localImage;
    private Image selectedLocalImage;

    private FlowElementCustomImageRenderer(@NotNull DrawableFlowElement drawable) {
        this.drawable = drawable;
    }

    public static FlowElementCustomImageRenderer create(@NotNull DrawableFlowElement drawable) {
        return new FlowElementCustomImageRenderer(drawable);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Image image = this.getImage(context);
        Rectangle bounds = this.getScaledDrawableBounds(context);
        context.getGraphics().drawImage(image, bounds);
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        Point location = this.drawable.getBounds(context).getOrigin();
        Point position = new Point(x, y);
        return this.getImage(context).isInside(position.sub(location));
    }

    @Override
    public Rectangle getRenderBounds(@NotNull DrawContext context) {
        return Rectangle.createAround((Point)this.drawable.getLocation(), (int)this.drawable.getWidth(context), (int)this.drawable.getHeight(context));
    }

    @Override
    public Dimension getRenderDimension(@NotNull DrawContext context) {
        return Dimension.valueOf((int)this.drawable.getWidth(context), (int)this.drawable.getHeight(context));
    }

    private Image getImage(@NotNull DrawContext context) {
        return this.drawable.isShowSelection() || context.isHighlighted(this.drawable) ? this.getSelectedImage(context) : this.getNormalImage(context);
    }

    private Image getNormalImage(@NotNull DrawContext context) {
        Image result = context.getTheme().getImageFor(this.getModelObject());
        if (this.getFeature(CustomImageFeature.class).getUseLocalImageFeature().getValue().booleanValue()) {
            Image local = this.getLocalImage();
            result = local == null ? result : local;
        }
        return result;
    }

    private Image getLocalImage() {
        if (this.localImage == null) {
            try {
                this.localImage = Image.createFromBase64((String)this.getFeature(CustomImageFeature.class).getEncodedLocalImage());
            }
            catch (IOException e) {
                Log.logWarning((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Log.logWarning((Throwable)e);
            }
        }
        return this.localImage;
    }

    private Image getSelectedImage(@NotNull DrawContext context) {
        Image result = context.getTheme().getImageFor(this.getModelObject(), ImageType.SELECTED);
        if (this.getFeature(CustomImageFeature.class).getUseLocalImageFeature().getValue().booleanValue()) {
            Image local = this.getSelectedLocalImage();
            result = local == null ? result : local;
        }
        return result;
    }

    private Image getSelectedLocalImage() {
        if (this.selectedLocalImage == null) {
            Image image = this.getLocalImage();
            this.selectedLocalImage = this.getFeature(CustomImageFeature.class).getInvertPaletteFeature().getValue() != false ? Utilities.invertImage(image) : image;
        }
        return this.selectedLocalImage;
    }

    private Rectangle getScaledDrawableBounds(@NotNull DrawContext context) {
        return context.scaleRectangle(this.drawable.getBounds(context));
    }

    private <T extends Feature> T getFeature(Class<T> featureClass) {
        return this.getModelObject().getFeature(featureClass);
    }

    @NotNull
    private FlowElement getModelObject() {
        return this.drawable.getModelObject();
    }
}

